/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.wizard;

import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.enterprise.metadata.ui.query.wizard.Messages;
import com.ibm.team.enterprise.metadata.ui.query.wizard.SparseLoadFilesContentProvider;
import com.ibm.team.enterprise.metadata.ui.query.wizard.SparseLoadNode;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class FetchSCMChildrenJob
extends TeamBuildJob {
    private final SparseLoadNode folderNode;
    private final SparseLoadFilesContentProvider toUpdate;
    private SparseLoadNode[] fetchedChildren;

    public FetchSCMChildrenJob(SparseLoadNode parent, SparseLoadFilesContentProvider toUpdate) {
        super(Messages.SparseLoadWizard_FetchChildrenJobName, true, parent.getConfiguration().teamRepository());
        this.folderNode = parent;
        this.toUpdate = toUpdate;
    }

    protected IStatus runProtected(IProgressMonitor monitor) throws TeamRepositoryException {
        this.fetchedChildren = FetchSCMChildrenJob.computeChildren(this.folderNode, monitor);
        return Status.OK_STATUS;
    }

    public static SparseLoadNode[] computeChildren(SparseLoadNode folderNode, IProgressMonitor monitor) throws TeamRepositoryException {
        IConfiguration config = folderNode.getConfiguration();
        Map map = config.childEntries((IFolderHandle)folderNode.getHandle(), monitor);
        ArrayList<SparseLoadNode> kids = new ArrayList<SparseLoadNode>();
        for (Map.Entry next : map.entrySet()) {
            String name = (String)next.getKey();
            if (".project".equals(name) || ".ibmi".equals(name)) continue;
            kids.add(new SparseLoadNode(name, (IVersionableHandle)next.getValue(), config, false, folderNode));
        }
        return kids.toArray(new SparseLoadNode[kids.size()]);
    }

    protected void jobFinished(IStatus status) {
        this.toUpdate.updateChildren(this.folderNode, this.fetchedChildren);
    }
}

