/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.wizard;

import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.enterprise.metadata.ui.query.wizard.Messages;
import com.ibm.team.enterprise.metadata.ui.query.wizard.RepositoryWorkspaceNode;
import com.ibm.team.enterprise.metadata.ui.query.wizard.SparseLoadModel;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.ComponentNotInWorkspaceException;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IWorkspaceSearchCriteria;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Display;

public class FetchRepositoryWorkspacesJob
extends TeamBuildJob {
    private final SparseLoadModel model;
    private final TableViewer viewer;
    private final UUID rwsUUID;
    private RepositoryWorkspaceNode[] workspaceArray;
    private RepositoryWorkspaceNode toSelect;

    public FetchRepositoryWorkspacesJob(SparseLoadModel model, TableViewer viewer, UUID rwsUUID) {
        super(Messages.SparseLoadWizard_FetchRWS_Job_Name, true, model.getRepository());
        this.model = model;
        this.viewer = viewer;
        this.rwsUUID = rwsUUID;
    }

    protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
        IWorkspaceSearchCriteria searchCrit = IWorkspaceSearchCriteria.FACTORY.newInstance();
        ITeamRepository repo = this.model.getRepository();
        searchCrit.getFilterByOwnerOptional().add(repo.loggedInContributor());
        List workspaces = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).findWorkspaces(searchCrit, Integer.MAX_VALUE, monitor);
        int numWorkspaces = workspaces == null ? 0 : workspaces.size();
        Map<UUID, Set<UUID>> toLoad = this.model.getVersionablesToLoad();
        this.workspaceArray = new RepositoryWorkspaceNode[numWorkspaces];
        int i = 0;
        while (i < numWorkspaces) {
            IWorkspaceHandle wsHandle = (IWorkspaceHandle)workspaces.get(i);
            IWorkspaceConnection wsConn = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getWorkspaceConnection(wsHandle, monitor);
            this.workspaceArray[i] = new RepositoryWorkspaceNode(wsConn, FetchRepositoryWorkspacesJob.calculateNumMissing(wsConn, toLoad, repo, monitor));
            if (this.rwsUUID != null && wsHandle.getItemId().equals((Object)this.rwsUUID)) {
                this.toSelect = this.workspaceArray[i];
            }
            ++i;
        }
        return Status.OK_STATUS;
    }

    private static int calculateNumMissing(IWorkspaceConnection wsConn, Map<UUID, Set<UUID>> toLoad, ITeamRepository repo, IProgressMonitor monitor) throws TeamRepositoryException {
        int numMissing = 0;
        for (Map.Entry<UUID, Set<UUID>> nextComp : toLoad.entrySet()) {
            UUID compUUID = nextComp.getKey();
            Set<UUID> filesInCompToLoad = nextComp.getValue();
            try {
                IConfiguration config = wsConn.configuration((IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(compUUID, null));
                ArrayList<IFileItemHandle> toFetch = new ArrayList<IFileItemHandle>(filesInCompToLoad.size());
                for (UUID file : filesInCompToLoad) {
                    toFetch.add((IFileItemHandle)IFileItem.ITEM_TYPE.createItemHandle(file, null));
                }
                List handles = config.fetchPartialItems(toFetch, new ArrayList(), monitor);
                for (IVersionableHandle handle : handles) {
                    if (handle != null) continue;
                    ++numMissing;
                }
            }
            catch (ComponentNotInWorkspaceException ex) {
                numMissing += filesInCompToLoad.size();
            }
        }
        return numMissing;
    }

    protected void jobFinished(IStatus status) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (FetchRepositoryWorkspacesJob.this.viewer != null && !FetchRepositoryWorkspacesJob.this.viewer.getTable().isDisposed()) {
                    FetchRepositoryWorkspacesJob.this.viewer.setInput((Object)FetchRepositoryWorkspacesJob.this.workspaceArray);
                    if (FetchRepositoryWorkspacesJob.this.toSelect != null) {
                        FetchRepositoryWorkspacesJob.this.viewer.setSelection((ISelection)new StructuredSelection((Object)FetchRepositoryWorkspacesJob.this.toSelect));
                    } else if (FetchRepositoryWorkspacesJob.this.workspaceArray != null && FetchRepositoryWorkspacesJob.this.workspaceArray.length == 1 && FetchRepositoryWorkspacesJob.this.workspaceArray[0] != null) {
                        FetchRepositoryWorkspacesJob.this.viewer.setSelection((ISelection)new StructuredSelection((Object)FetchRepositoryWorkspacesJob.this.workspaceArray[0]));
                    }
                }
            }
        });
    }
}

