/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.wizard;

import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.enterprise.metadata.ui.query.wizard.Messages;
import com.ibm.team.enterprise.metadata.ui.query.wizard.SparseLoadFilesContentProvider;
import com.ibm.team.enterprise.metadata.ui.query.wizard.SparseLoadNode;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class FetchComponentsJob
extends TeamBuildJob {
    private final IWorkspaceConnection wsConn;
    private final SparseLoadFilesContentProvider toUpdate;
    private SparseLoadNode[] fetchedComponents;

    public FetchComponentsJob(IWorkspaceConnection wsConn, SparseLoadFilesContentProvider toUpdate) {
        super(Messages.SparseLoadWizard_FetchComponentsJobName, true, wsConn.teamRepository());
        this.wsConn = wsConn;
        this.toUpdate = toUpdate;
    }

    protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
        this.fetchedComponents = FetchComponentsJob.computeChildren(this.wsConn, monitor);
        return Status.OK_STATUS;
    }

    public static SparseLoadNode[] computeChildren(IWorkspaceConnection wsConn, IProgressMonitor monitor) throws TeamRepositoryException {
        List comps = wsConn.teamRepository().itemManager().fetchPartialItems(wsConn.getComponents(), 1, Collections.singletonList(IComponent.NAME_PROPERTY), monitor);
        int numComps = comps == null ? 0 : comps.size();
        SparseLoadNode[] kids = new SparseLoadNode[numComps];
        int i = 0;
        while (i < numComps) {
            IComponent thisComp = (IComponent)comps.get(i);
            IConfiguration config = wsConn.configuration((IComponentHandle)thisComp);
            kids[i] = new SparseLoadNode(thisComp.getName(), (IVersionableHandle)config.rootFolderHandle(monitor), config, true, wsConn);
            ++i;
        }
        return kids;
    }

    protected void jobFinished(IStatus status) {
        this.toUpdate.updateChildren(this.wsConn, this.fetchedComponents);
    }
}

