/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.wizard;

import com.ibm.team.enterprise.metadata.ui.MetadataUIPlugin;
import com.ibm.team.enterprise.metadata.ui.query.wizard.Messages;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.IExtraLoadWizard;
import com.ibm.team.repository.rcp.ui.utils.LayoutConstants2;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class BlindLoadPage
extends WizardPage
implements IPropertyChangeListener {
    private Button eclipseWks;
    private Button[] extra;
    static final String FILESYSTEM_IDE_UI_PLUGIN_ID = "com.ibm.team.filesystem.ide.ui";
    static final String EXTRA_LOAD_WIZARDS_EP = "extraLoadWizards";
    static final String EXTRA_LOAD_WIZARD_ID_ATTR = "id";
    static final String EXTRA_LOAD_WIZARD_LABEL_ATTR = "label";

    public String getSelectedExtraWizardId() {
        if (this.eclipseWks.getSelection()) {
            return null;
        }
        Button[] buttonArray = this.extra;
        int n = this.extra.length;
        int n2 = 0;
        while (n2 < n) {
            Object data;
            Button b = buttonArray[n2];
            if (b.getSelection() && (data = b.getData()) instanceof String) {
                return (String)b.getData();
            }
            ++n2;
        }
        return null;
    }

    public BlindLoadPage() {
        super(BlindLoadPage.class.getName());
        this.setTitle(Messages.SparseLoadWizard_BlindLoadPage_Title);
        this.setDescription(Messages.SparseLoadWizard_BlindLoadPage_Description);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.createButtons(composite);
        Dialog.applyDialogFont((Control)composite);
        GridLayoutFactory.fillDefaults().extendedMargins(LayoutConstants2.getWizardPageMargins()).generateLayout(composite);
        this.setControl((Control)composite);
        this.initControls();
    }

    private void createButtons(Composite composite) {
        Map<String, String> wizardInfos = BlindLoadPage.getExtraLoadWizardInformations(true);
        this.extra = new Button[wizardInfos.size()];
        int i = 0;
        for (Map.Entry<String, String> wizard : wizardInfos.entrySet()) {
            Button wizardButton = new Button(composite, 80);
            wizardButton.setText(wizard.getValue());
            wizardButton.setData((Object)wizard.getKey());
            this.extra[i] = wizardButton;
            ++i;
        }
        this.eclipseWks = new Button(composite, 80);
        this.eclipseWks.setText(Messages.SparseLoadWizard_BlindLoadPage_Load_Locally);
        this.eclipseWks.setData((Object)1);
        this.eclipseWks.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                BlindLoadPage.this.setPageComplete(BlindLoadPage.this.eclipseWks.getSelection());
            }
        });
    }

    protected static Map<String, String> getExtraLoadWizardInformations(boolean canLoadFilesNeeded) {
        IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint(FILESYSTEM_IDE_UI_PLUGIN_ID, EXTRA_LOAD_WIZARDS_EP);
        HashMap<String, String> infos = new HashMap<String, String>();
        IExtension[] iExtensionArray = ep.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement ce = iConfigurationElementArray[n4];
                if (canLoadFilesNeeded) {
                    try {
                        IExtraLoadWizard wizard = (IExtraLoadWizard)ce.createExecutableExtension("class");
                        if (!wizard.canLoadFiles()) {
                            break;
                        }
                    }
                    catch (CoreException e) {
                        MetadataUIPlugin.log(e.getStatus());
                    }
                    catch (ClassCastException e) {
                        MetadataUIPlugin.log(e.getMessage(), e);
                    }
                }
                infos.put(ce.getAttribute(EXTRA_LOAD_WIZARD_ID_ATTR), ce.getAttribute(EXTRA_LOAD_WIZARD_LABEL_ATTR));
                ++n4;
            }
            ++n2;
        }
        return infos;
    }

    public void dispose() {
        super.dispose();
    }

    public boolean canFlipToNextPage() {
        return this.getNextPage() != null;
    }

    private void initControls() {
        this.eclipseWks.setSelection(false);
        this.extra[0].setSelection(true);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("com.ibm.team.filesystem.ide.ui.LoadTypeProperty")) {
            this.getContainer().updateButtons();
        }
    }
}

