/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.view;

import com.ibm.team.enterprise.common.ui.IEnterpriseExtensionsNode;
import com.ibm.team.enterprise.internal.common.ui.EnterpriseExtensionsDomainRegistry;
import com.ibm.team.enterprise.metadata.ui.MetadataUIPlugin;
import com.ibm.team.enterprise.metadata.ui.query.editor.QueryEditorInput;
import com.ibm.team.enterprise.metadata.ui.query.navigator.QueryNodeEE;
import com.ibm.team.enterprise.metadata.ui.query.navigator.SharedQueriesNodeEE;
import com.ibm.team.enterprise.metadata.ui.query.view.QueryView;
import com.ibm.team.enterprise.rdf.query.common.select.result.Binding;
import com.ibm.team.enterprise.rdf.query.common.select.result.SelectResult;
import com.ibm.team.process.internal.rcp.ui.TeamArtifactsNavigator;
import java.util.Iterator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ViewUtil {
    private static final String QUERY_VIEW_ID = "com.ibm.team.enterprise.metadata.ui.query.view.QueryView";
    private static final String TEAM_ARTIFACTS_VIEW_ID = "com.ibm.team.process.rcp.ui.teamArtifactsNavigator";

    public static final QueryView openQueryView() {
        try {
            return (QueryView)MetadataUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(QUERY_VIEW_ID);
        }
        catch (PartInitException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void refreshTeamArtifacts() {
        ViewUtil.refreshTeamArtifacts(null);
    }

    public static void refreshTeamArtifacts(QueryEditorInput input) {
        try {
            TeamArtifactsNavigator view = (TeamArtifactsNavigator)MetadataUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().findView(TEAM_ARTIFACTS_VIEW_ID);
            if (view == null) {
                return;
            }
            if (input == null) {
                Object element;
                ISelection selection = view.getSite().getSelectionProvider().getSelection();
                if (selection instanceof IStructuredSelection && ((element = ((IStructuredSelection)selection).getFirstElement()) instanceof SharedQueriesNodeEE || element instanceof QueryNodeEE)) {
                    ViewUtil.refreshQueries((IEnterpriseExtensionsNode)element, view);
                }
            } else {
                IEnterpriseExtensionsNode sharedQueriesNode = null;
                Iterator iterator = EnterpriseExtensionsDomainRegistry.getInstance().getChildrenNodes(input.getProjectArea(), "SourceCodeData", null);
                while (sharedQueriesNode == null && iterator.hasNext()) {
                    IEnterpriseExtensionsNode nextNode = (IEnterpriseExtensionsNode)iterator.next();
                    if (!nextNode.getId().equals("com.ibm.team.enterprise.metadata.ui.query.sharedqueries")) continue;
                    sharedQueriesNode = nextNode;
                }
                if (sharedQueriesNode != null) {
                    ViewUtil.refreshQueries(sharedQueriesNode, view);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void refreshQueries(IEnterpriseExtensionsNode node, TeamArtifactsNavigator view) {
        SharedQueriesNodeEE sharedQueriesNode = null;
        if (node instanceof QueryNodeEE) {
            sharedQueriesNode = (SharedQueriesNodeEE)((QueryNodeEE)node).getParent();
        } else if (node instanceof SharedQueriesNodeEE) {
            sharedQueriesNode = (SharedQueriesNodeEE)node;
        }
        if (sharedQueriesNode != null) {
            StructuredSelection newSelection = new StructuredSelection((Object)sharedQueriesNode);
            view.getSite().getSelectionProvider().setSelection((ISelection)newSelection);
            view.refresh();
        }
    }

    public static String getBindingValue(SelectResult result, String bindingName) {
        for (Binding binding : result.getBindings()) {
            if (!binding.getName().equals(bindingName)) continue;
            return binding.getValue();
        }
        return "";
    }

    public static void forceCloseEditors(String[] names) {
        IEditorReference[] editors;
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorReference[] iEditorReferenceArray = editors = activePage.getEditorReferences();
        int n = editors.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference editor = iEditorReferenceArray[n2];
            String[] stringArray = names;
            int n3 = names.length;
            int n4 = 0;
            while (n4 < n3) {
                String name = stringArray[n4];
                if (editor.getName() != null && editor.getName().equals(name)) {
                    ViewUtil.forceCloseEditor(activePage, editor.getEditor(false));
                }
                ++n4;
            }
            ++n2;
        }
    }

    public static void forceCloseEditor(IWorkbenchPage activePage, IEditorPart editor) {
        try {
            if (editor != null) {
                activePage.closeEditor(editor, false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

