/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.view;

import com.ibm.team.enterprise.metadata.query.common.AttributeColumn;
import com.ibm.team.enterprise.metadata.ui.query.view.ViewUtil;
import com.ibm.team.enterprise.rdf.query.common.select.result.SelectResult;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;

public class ResultTableLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private ResourceManager resources = null;
    private final Table table;

    public ResultTableLabelProvider(Table table) {
        this.table = table;
    }

    public String getColumnText(Object element, int columnIndex) {
        String text = "";
        if (element instanceof SelectResult) {
            SelectResult result = (SelectResult)element;
            switch (columnIndex) {
                case 0: {
                    break;
                }
                default: {
                    String bindingName = ((AttributeColumn)this.table.getColumn(columnIndex).getData()).getAttribute().getDisplayName();
                    text = ViewUtil.getBindingValue(result, bindingName);
                }
            }
        }
        return text;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0 && element instanceof SelectResult) {
            String filePath = ViewUtil.getBindingValue((SelectResult)element, "filePath");
            if (filePath != null) {
                ImageDescriptor imageDesc = PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(filePath);
                return this.getImage(imageDesc);
            }
            return this.getResources().createImageWithDefault(null);
        }
        return null;
    }

    protected final ResourceManager getResources() {
        if (this.resources == null) {
            this.resources = new LocalResourceManager(JFaceResources.getResources());
        }
        return this.resources;
    }

    protected final Image getImage(ImageDescriptor descriptor) {
        Object o = this.getResources().find((DeviceResourceDescriptor)descriptor);
        if (o instanceof Image) {
            return (Image)o;
        }
        return this.getResources().createImageWithDefault(descriptor);
    }

    public void dispose() {
        super.dispose();
        if (this.resources != null) {
            this.resources.dispose();
        }
    }
}

