/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.view;

import com.ibm.team.enterprise.build.ui.actions.AddToSubsetFromSCDAction;
import com.ibm.team.enterprise.build.ui.actions.CreateSubsetFromSCDAction;
import com.ibm.team.enterprise.build.ui.actions.ViewBuildMapFromSCDAction;
import com.ibm.team.enterprise.build.ui.data.export.IQueryResultExportSupplier;
import com.ibm.team.enterprise.build.ui.data.export.TableData;
import com.ibm.team.enterprise.metadata.query.common.AttributeColumn;
import com.ibm.team.enterprise.metadata.ui.query.QueryResult;
import com.ibm.team.enterprise.metadata.ui.query.action.ImpactAnalysisAction;
import com.ibm.team.enterprise.metadata.ui.query.action.LoadWithDependenciesAction;
import com.ibm.team.enterprise.metadata.ui.query.action.OpenDefaultEditorAction;
import com.ibm.team.enterprise.metadata.ui.query.action.OpenDependencyEditorAction;
import com.ibm.team.enterprise.metadata.ui.query.action.ShowRepositoryFileAction;
import com.ibm.team.enterprise.metadata.ui.query.action.SparseLoadAction;
import com.ibm.team.enterprise.metadata.ui.query.view.Messages;
import com.ibm.team.enterprise.metadata.ui.query.view.QueryTableViewer;
import com.ibm.team.enterprise.rdf.query.common.select.result.SelectResult;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class QueryView
extends ViewPart
implements IQueryResultExportSupplier {
    private Label statusLabel;
    private QueryTableViewer viewer;
    private OpenDependencyEditorAction editMetadataAction = new OpenDependencyEditorAction();
    private OpenDefaultEditorAction openDefaultEditorAction = new OpenDefaultEditorAction();
    private ShowRepositoryFileAction showRepositoryFileAction = new ShowRepositoryFileAction();
    private SparseLoadAction sparseLoadAction = new SparseLoadAction();
    private LoadWithDependenciesAction loadWithDependenciesAction = new LoadWithDependenciesAction();
    private ImpactAnalysisAction impactAnalysisAction = new ImpactAnalysisAction();
    private ViewBuildMapFromSCDAction viewBuildMapAction = new ViewBuildMapFromSCDAction();
    private CreateSubsetFromSCDAction createSubsetAction = new CreateSubsetFromSCDAction();
    private AddToSubsetFromSCDAction addToSubsetAction = new AddToSubsetFromSCDAction();

    public void createPartControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(composite);
        this.statusLabel = new Label(composite, 16384);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.statusLabel);
        this.viewer = new QueryTableViewer(composite);
        this.openDefaultEditorAction.setActivePart(null, this.getSite().getPart());
        this.showRepositoryFileAction.setActivePart(null, this.getSite().getPart());
        this.sparseLoadAction.setActivePart(null, this.getSite().getPart());
        this.loadWithDependenciesAction.setActivePart(null, this.getSite().getPart());
        this.impactAnalysisAction.setActivePart(null, this.getSite().getPart());
        this.viewBuildMapAction.setActivePart(null, this.getSite().getPart());
        this.createSubsetAction.setActivePart(null, this.getSite().getPart());
        this.addToSubsetAction.setActivePart(null, this.getSite().getPart());
        this.installContextMenu();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.team.filesystem.ide.ui.view_queryResults");
    }

    public void setColumns(List<AttributeColumn> columns) {
        if (this.viewer != null) {
            this.viewer.setColumns(columns);
        }
    }

    public void setInput(Object object) {
        this.setInput(object, -1);
    }

    public void setInput(Object object, int limit) {
        if (this.viewer != null) {
            if (object instanceof QueryResult) {
                QueryResult queryResult = (QueryResult)object;
                List<SelectResult> result = queryResult.result;
                int totalResults = queryResult.totalResults;
                this.viewer.setInput(result);
                if (result instanceof List) {
                    int resultSize = result.size();
                    String status = resultSize == totalResults || limit < 0 ? NLS.bind((String)Messages.QueryView_FOUND_MATCHES, (Object)resultSize, (Object)totalResults) : NLS.bind((String)Messages.QueryView_FOUND_MATCHES_WITH_MAX, (Object[])new Object[]{resultSize, limit, totalResults});
                    this.setStatus(status);
                } else if (result instanceof IStatus) {
                    this.setStatus(((IStatus)object).getMessage());
                }
            } else {
                this.viewer.setInput(object);
                if (object instanceof List) {
                    this.setStatus(NLS.bind((String)Messages.QueryView_FOUND_MATCHES_WITH_MAX, (Object)((List)object).size(), (Object)limit));
                } else if (object instanceof IStatus) {
                    this.setStatus(((IStatus)object).getMessage());
                }
                this.viewer.clearSorting();
                this.refresh();
            }
            this.viewer.clearSorting();
            this.refresh();
        }
    }

    public void setFocus() {
        if (this.viewer != null) {
            this.viewer.setFocus();
        }
    }

    public void refresh() {
        if (this.viewer != null) {
            this.viewer.refresh();
        }
    }

    public void setStatus(String status) {
        this.statusLabel.setText(status);
    }

    private void installContextMenu() {
        MenuManager contextMenuMgr = new MenuManager("#PopupMenu");
        contextMenuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IStructuredSelection selection = QueryView.this.viewer.getSelection();
                QueryView.this.editMetadataAction.selectionChanged(null, (ISelection)selection);
                QueryView.this.openDefaultEditorAction.selectionChanged(null, (ISelection)selection);
                QueryView.this.showRepositoryFileAction.selectionChanged(null, (ISelection)selection);
                QueryView.this.sparseLoadAction.selectionChanged(null, (ISelection)selection);
                QueryView.this.loadWithDependenciesAction.selectionChanged(null, (ISelection)selection);
                QueryView.this.impactAnalysisAction.selectionChanged(null, (ISelection)selection);
                QueryView.this.viewBuildMapAction.selectionChanged(null, (ISelection)selection);
                QueryView.this.createSubsetAction.selectionChanged(null, (ISelection)selection);
                QueryView.this.addToSubsetAction.selectionChanged(null, (ISelection)selection);
            }
        });
        contextMenuMgr.add((IAction)this.openDefaultEditorAction);
        contextMenuMgr.add((IAction)this.showRepositoryFileAction);
        contextMenuMgr.add((IAction)this.editMetadataAction);
        contextMenuMgr.add((IAction)this.sparseLoadAction);
        contextMenuMgr.add((IAction)this.loadWithDependenciesAction);
        contextMenuMgr.add((IAction)this.impactAnalysisAction);
        contextMenuMgr.add((IAction)this.viewBuildMapAction);
        contextMenuMgr.add((IContributionItem)new Separator());
        contextMenuMgr.add((IAction)this.createSubsetAction);
        contextMenuMgr.add((IAction)this.addToSubsetAction);
        this.viewer.installContextMenu(contextMenuMgr);
        this.getSite().registerContextMenu(contextMenuMgr, this.viewer.getSelectionProvider());
    }

    public TableData gatherExportData(IProgressMonitor monitor) {
        return this.viewer.getTableData(monitor);
    }
}

