/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.view;

import com.ibm.icu.text.Collator;
import com.ibm.team.enterprise.build.ui.data.export.TableData;
import com.ibm.team.enterprise.metadata.query.common.AttributeColumn;
import com.ibm.team.enterprise.metadata.ui.query.view.MetadataResultComparator;
import com.ibm.team.enterprise.metadata.ui.query.view.ResultContentProvider;
import com.ibm.team.enterprise.metadata.ui.query.view.ResultTableLabelProvider;
import com.ibm.team.enterprise.rdf.query.common.select.result.SelectResult;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class QueryTableViewer {
    private Table table;
    private TableViewer tableViewer;
    private final Composite parent;
    private ResultTableLabelProvider labelProvider;
    private final SelectionListener sortListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            QueryTableViewer.this.handleSorting(event);
        }
    };

    public QueryTableViewer(Composite parent) {
        this.parent = parent;
        this.createTable();
        this.installDragSupport(this.tableViewer);
    }

    private void createTable() {
        int style = 101122;
        this.table = new Table(this.parent, style);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.table);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.setContentProvider((IContentProvider)new ResultContentProvider());
        this.labelProvider = new ResultTableLabelProvider(this.table);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
    }

    private void installDragSupport(final TableViewer viewer) {
        viewer.addDragSupport(23, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DragSourceListener)new DragSourceAdapter(){

            public void dragStart(DragSourceEvent event) {
                LocalSelectionTransfer.getTransfer().setSelection(viewer.getSelection());
            }

            public void dragFinished(DragSourceEvent event) {
                LocalSelectionTransfer.getTransfer().setSelection(null);
            }

            public void dragSetData(DragSourceEvent event) {
                if (LocalSelectionTransfer.getTransfer().isSupportedType(event.dataType)) {
                    event.data = LocalSelectionTransfer.getTransfer().getSelection();
                }
            }
        });
    }

    public void setColumns(List<AttributeColumn> columns) {
        TableColumn[] tableColumns = this.table.getColumns();
        if (tableColumns.length == 0) {
            TableColumn tableColumn = new TableColumn(this.table, 0x1000000);
            tableColumn.setWidth(30);
        } else {
            int i = 1;
            while (i < tableColumns.length) {
                tableColumns[i].dispose();
                ++i;
            }
        }
        if (columns != null) {
            int i = 1;
            for (AttributeColumn column : columns) {
                TableColumn tableColumn = new TableColumn(this.table, 16384, i++);
                tableColumn.setData((Object)column);
                tableColumn.setText(column.getAttribute().getFullDisplayName());
                tableColumn.setWidth(150);
                tableColumn.addSelectionListener(this.sortListener);
            }
        }
        this.tableViewer.refresh();
    }

    public void setInput(Object input) {
        this.tableViewer.setInput(input);
    }

    public void dispose() {
        if (this.labelProvider != null) {
            this.labelProvider.dispose();
        }
    }

    public void refresh() {
        this.tableViewer.refresh(true);
    }

    public void setFocus() {
        this.tableViewer.getTable().setFocus();
    }

    public IStructuredSelection getSelection() {
        return (IStructuredSelection)this.tableViewer.getSelection();
    }

    public void installContextMenu(MenuManager menuManager) {
        Menu menu = menuManager.createContextMenu(this.tableViewer.getControl());
        this.tableViewer.getControl().setMenu(menu);
    }

    public void clearSorting() {
        if (this.tableViewer != null) {
            this.tableViewer.setComparator(null);
        }
    }

    private void handleSorting(SelectionEvent event) {
        AttributeColumn sortColumn = (AttributeColumn)event.widget.getData();
        boolean ascending = this.updateSortOrderIndication(sortColumn);
        Comparator<Object> comparator = this.createComparator(ascending);
        this.tableViewer.setComparator((ViewerComparator)new MetadataResultComparator(comparator, sortColumn.getAttribute().getDisplayName()));
    }

    private boolean updateSortOrderIndication(AttributeColumn sortColumn) {
        Table table = this.tableViewer.getTable();
        AttributeColumn previous = table.getSortColumn() != null ? (AttributeColumn)table.getSortColumn().getData() : null;
        int i = 0;
        while (i < table.getColumnCount()) {
            TableColumn tableColumn = table.getColumn(i);
            AttributeColumn column = (AttributeColumn)tableColumn.getData();
            if (sortColumn != null && column != null && sortColumn.equals((Object)column)) {
                table.setSortColumn(tableColumn);
                if (previous != null && previous.equals((Object)sortColumn)) {
                    int direction = table.getSortDirection();
                    table.setSortDirection(direction == 1024 || direction == 0 ? 128 : 1024);
                } else {
                    table.setSortDirection(128);
                }
                return table.getSortDirection() == 128;
            }
            ++i;
        }
        return true;
    }

    private Comparator<Object> createComparator(boolean ascending) {
        Comparator<Object> comparator = new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                Collator collator = Collator.getInstance((Locale)Locale.getDefault());
                return collator.compare(o1, o2);
            }
        };
        if (ascending) {
            return comparator;
        }
        return new ReverseComparator<Object>(comparator);
    }

    public ISelectionProvider getSelectionProvider() {
        return this.tableViewer;
    }

    public TableData getTableData(IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("", this.tableViewer.getTable().getItemCount());
        TableData data = new TableData(this.tableViewer.getTable().getColumns());
        int i = 0;
        while (i < this.tableViewer.getTable().getItemCount()) {
            if (monitor.isCanceled()) break;
            data.addRow((SelectResult)this.tableViewer.getElementAt(i));
            monitor.worked(1);
            ++i;
        }
        return data;
    }

    class ReverseComparator<T>
    implements Comparator<T> {
        private final Comparator<T> comparator;

        public ReverseComparator(Comparator<T> comparator) {
            this.comparator = comparator;
        }

        @Override
        public int compare(T o1, T o2) {
            return this.comparator.compare(o2, o1);
        }
    }
}

