/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.util;

import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.databinding.swt.DisplayRealm;
import org.eclipse.swt.widgets.Display;

class WorkQueue {
    private boolean updateScheduled = false;
    private final LinkedList<Runnable> pendingWork = new LinkedList();
    private final Realm d;
    private final Set pendingWorkSet = new HashSet();
    private final Runnable updateJob = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LinkedList linkedList = WorkQueue.this.pendingWork;
            synchronized (linkedList) {
                WorkQueue.this.updateScheduled = false;
            }
            Realm.runWithDefault((Realm)DisplayRealm.getRealm((Display)Display.getCurrent()), (Runnable)WorkQueue.this.defaultRealmJob);
        }
    };
    private final Runnable defaultRealmJob = new Runnable(){

        @Override
        public void run() {
            WorkQueue.this.doUpdate();
        }
    };

    public WorkQueue(Realm targetDisplay) {
        Assert.isNotNull((Object)targetDisplay);
        this.d = targetDisplay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdate() {
        long operationStart = System.currentTimeMillis();
        while (true) {
            Runnable next;
            LinkedList<Runnable> linkedList = this.pendingWork;
            synchronized (linkedList) {
                long currentTime;
                if (this.pendingWork.isEmpty()) {
                    break;
                }
                if (!this.updateScheduled) {
                    this.updateScheduled = true;
                    this.d.asyncExec(this.updateJob);
                }
                if ((currentTime = System.currentTimeMillis()) - operationStart > 100L) {
                    break;
                }
                next = this.pendingWork.removeFirst();
                this.pendingWorkSet.remove(next);
            }
            try {
                next.run();
            }
            catch (RuntimeException e) {
                StatusUtil.log((Object)this, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runOnce(Runnable work) {
        LinkedList<Runnable> linkedList = this.pendingWork;
        synchronized (linkedList) {
            if (this.pendingWorkSet.contains(work)) {
                return;
            }
            this.pendingWorkSet.add(work);
            this.asyncExec(work);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncExec(Runnable work) {
        LinkedList<Runnable> linkedList = this.pendingWork;
        synchronized (linkedList) {
            this.pendingWork.add(work);
            if (!this.updateScheduled) {
                this.updateScheduled = true;
                this.d.asyncExec(this.updateJob);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelExec(Runnable toCancel) {
        LinkedList<Runnable> linkedList = this.pendingWork;
        synchronized (linkedList) {
            this.pendingWork.remove(toCancel);
            this.pendingWorkSet.remove(toCancel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAll() {
        LinkedList<Runnable> linkedList = this.pendingWork;
        synchronized (linkedList) {
            this.pendingWork.clear();
            this.pendingWorkSet.clear();
        }
    }
}

