/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.util;

import com.ibm.icu.text.Collator;
import com.ibm.team.enterprise.metadata.client.collection.ClientFactory;
import com.ibm.team.enterprise.metadata.client.collection.IMetadataCollectionClient;
import com.ibm.team.enterprise.metadata.common.collection.transport.TransportFile;
import com.ibm.team.enterprise.metadata.common.collection.transport.TransportUtil;
import com.ibm.team.enterprise.metadata.common.query.util.AttributeProviderFactory;
import com.ibm.team.enterprise.metadata.query.common.IAttribute;
import com.ibm.team.enterprise.metadata.ui.MetadataUIPlugin;
import com.ibm.team.enterprise.rdf.query.common.select.result.Binding;
import com.ibm.team.enterprise.rdf.query.common.select.result.SelectResult;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.dto.IWorkspaceSearchCriteria;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class Utils {
    private static final String BUILD_DEFINITION_INFO_FILE_NAME = ".buildDefAndWorkspaceInfo";
    private static final IPath BUILD_DEFINITION_INFO_FILE = MetadataUIPlugin.getDefault().getStateLocation().append(".buildDefAndWorkspaceInfo");

    public static int convertWidthInCharsToPixels(Control control, int chars) {
        GC gc = new GC((Drawable)control);
        gc.setFont(control.getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        return Dialog.convertWidthInCharsToPixels((FontMetrics)fontMetrics, (int)chars);
    }

    public static List<IWorkspace> getWorkspaces(final ITeamRepository teamRepository, Display display) {
        final ArrayList<IWorkspace> streams = new ArrayList<IWorkspace>();
        IRunnableWithProgress operation = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    IWorkspaceSearchCriteria criteria = IWorkspaceSearchCriteria.FACTORY.newInstance().setKind(1);
                    IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)teamRepository);
                    List hStreams = workspaceManager.findWorkspaces(criteria, Integer.MAX_VALUE, null);
                    streams.addAll(teamRepository.itemManager().fetchCompleteItems(hStreams, 0, null));
                }
                catch (TeamRepositoryException teamRepositoryException) {
                    // empty catch block
                }
            }
        };
        try {
            try {
                if (display == null) {
                    display = Display.getCurrent();
                }
                if (display.getActiveShell() != null) {
                    display.getActiveShell().setCursor(Display.getCurrent().getSystemCursor(1));
                }
                ModalContext.run((IRunnableWithProgress)operation, (boolean)true, (IProgressMonitor)new NullProgressMonitor(), (Display)Display.getCurrent());
            }
            catch (Exception exception) {
                if (display.getActiveShell() != null) {
                    display.getActiveShell().setCursor(null);
                }
            }
        }
        finally {
            if (display.getActiveShell() != null) {
                display.getActiveShell().setCursor(null);
            }
        }
        return streams;
    }

    public static String getStreamDisplayName(IWorkspaceConnection workspace) {
        StringBuilder buffer = new StringBuilder();
        if (workspace != null) {
            buffer.append(workspace.getName());
            if (workspace.getDescription() != null && workspace.getDescription().length() > 0) {
                buffer.append(" (" + workspace.getDescription() + ")");
            }
        }
        return buffer.toString();
    }

    public static String getStreamDisplayName(IWorkspace workspace) {
        StringBuilder buffer = new StringBuilder();
        if (workspace != null) {
            buffer.append(workspace.getName());
            if (workspace.getDescription() != null && workspace.getDescription().length() > 0) {
                buffer.append(" (" + workspace.getDescription() + ")");
            }
        }
        return buffer.toString();
    }

    @Deprecated
    public static boolean isSameResult(SelectResult result1, SelectResult result2) {
        if (result1.getBindings().size() != result2.getBindings().size()) {
            return false;
        }
        List bindings1 = result1.getBindings();
        List bindings2 = result2.getBindings();
        for (Binding binding1 : bindings1) {
            if (binding1.getName().equals("index") || binding1.getName().equals("index")) continue;
            Binding binding2 = Utils.getBinding(bindings2, binding1.getName());
            if (binding2 == null) {
                return false;
            }
            if (AttributeProviderFactory.getInstance().isParentComplexAttribute(binding1.getName()) || binding1.getValue().equals(binding2.getValue())) continue;
            return false;
        }
        return true;
    }

    public static boolean isSameResult2(SelectResult result1, SelectResult result2) {
        List bindings1 = result1.getBindings();
        for (Binding binding1 : bindings1) {
            Binding binding2;
            if (!binding1.getName().equals("index") || (binding2 = Utils.getBinding(result2.getBindings(), binding1.getName())) == null || !binding1.getValue().equals(binding2.getValue())) continue;
            Binding streamId1 = Utils.getBinding(result1.getBindings(), "streamId");
            Binding streamId2 = Utils.getBinding(result2.getBindings(), "streamId");
            if (streamId1 == null || streamId2 == null) continue;
            return streamId1.getValue().equals(streamId2.getValue());
        }
        return false;
    }

    public static Binding getBinding(List<Binding> bindings, String name) {
        for (Binding binding : bindings) {
            if (!binding.getName().equals(name)) continue;
            return binding;
        }
        return null;
    }

    public static boolean hasValue(Binding binding, String value) {
        String[] valArray;
        String values;
        boolean result = false;
        if (binding != null && value != null && value.length() > 0 && (values = binding.getValue()) != null && values.length() > 0 && (valArray = values.split(",")) != null && valArray.length > 0) {
            String[] stringArray = valArray;
            int n = valArray.length;
            int n2 = 0;
            while (n2 < n) {
                String val = stringArray[n2];
                if (val != null && value.equals(val.trim())) {
                    result = true;
                    break;
                }
                ++n2;
            }
        }
        return result;
    }

    public static Comparator<IAttribute> createAttributeDisplayNameComparator() {
        return Utils.createAttributeDisplayNameComparator(Locale.getDefault());
    }

    public static Comparator<IAttribute> createAttributeDisplayNameComparator(Locale locale) {
        return new Comparator<IAttribute>(locale){
            private final Collator collator;
            {
                this.collator = Collator.getInstance((Locale)locale);
            }

            @Override
            public int compare(IAttribute a1, IAttribute a2) {
                return this.collator.compare(a1.getDisplayName(), a2.getDisplayName());
            }
        };
    }

    public static Character findFirstNonLetterOrNumeric(String testString) {
        int i = 0;
        while (i < testString.length()) {
            char ch = testString.charAt(i);
            if (!Character.isLetterOrDigit(ch)) {
                return Character.valueOf(ch);
            }
            ++i;
        }
        return null;
    }

    public static TransportFile getSourceFileMetadata(ITeamRepository repo, String streamId, String componentId, String fileItemId, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        TransportFile tFile = null;
        IMetadataCollectionClient client = ClientFactory.getMetadataCollectionClient((ITeamRepository)repo);
        String metadata = client.getSourceFileMetadata(streamId, componentId, fileItemId, progressMonitor);
        if (metadata != null) {
            try {
                List fileList = TransportUtil.fromXML((String)metadata);
                if (fileList.size() == 1) {
                    tFile = (TransportFile)fileList.get(0);
                }
            }
            catch (Exception e) {
                throw new TeamRepositoryException((Throwable)e);
            }
        }
        return tFile;
    }

    public static Properties retrieveBuildDefinitionMetadata() {
        Properties uildDefinitionMetadata = null;
        File file = BUILD_DEFINITION_INFO_FILE.toFile();
        FileInputStream fis = null;
        ObjectInputStream in = null;
        try {
            fis = new FileInputStream(file);
            in = new ObjectInputStream(fis);
            uildDefinitionMetadata = (Properties)in.readObject();
            in.close();
        }
        catch (Exception e) {
            file.delete();
        }
        return uildDefinitionMetadata;
    }

    public static String retrieveBuildDefinitionMetadataProperty(String key) {
        Properties buildDefinitionMetadata = Utils.retrieveBuildDefinitionMetadata();
        return buildDefinitionMetadata == null ? null : buildDefinitionMetadata.getProperty(key);
    }

    public static void storeBuildDefinitionMetadata(String key, String builUUID) {
        Properties buildDefinitionMetadata = Utils.retrieveBuildDefinitionMetadata();
        if (buildDefinitionMetadata == null) {
            buildDefinitionMetadata = new Properties();
        }
        buildDefinitionMetadata.put(key, builUUID);
        Utils.doWriteObject(buildDefinitionMetadata);
    }

    public static boolean deleteBuildDefinitionMetadata() {
        File file = BUILD_DEFINITION_INFO_FILE.toFile();
        if (file != null) {
            return file.delete();
        }
        return false;
    }

    public static boolean deleteBuildDefinitionMetadata(String key) {
        Object obj;
        Properties buildDefinitionMetadata = Utils.retrieveBuildDefinitionMetadata();
        Object object = obj = buildDefinitionMetadata != null ? buildDefinitionMetadata.remove(key) : null;
        if (obj == null) {
            return false;
        }
        return Utils.doWriteObject(buildDefinitionMetadata);
    }

    private static boolean doWriteObject(Object buildMetadataObject) {
        File file = BUILD_DEFINITION_INFO_FILE.toFile();
        FileOutputStream fos = null;
        ObjectOutputStream out = null;
        try {
            fos = new FileOutputStream(file);
            out = new ObjectOutputStream(fos);
            out.writeObject(buildMetadataObject);
            out.close();
        }
        catch (Exception e) {
            return file.delete();
        }
        return true;
    }
}

