/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.util;

import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class TreeHoverInfo {
    private Shell tipShell;
    private Label tipLabelText;
    private Widget tipWidget;
    private Point tipPosition;

    public TreeHoverInfo(Shell parent) {
        Display display = parent.getDisplay();
        this.tipShell = new Shell(parent, 16388);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 2;
        gridLayout.marginHeight = 2;
        this.tipShell.setLayout((Layout)gridLayout);
        this.tipShell.setBackground(display.getSystemColor(29));
        this.tipLabelText = new Label((Composite)this.tipShell, 0);
        this.tipLabelText.setForeground(display.getSystemColor(28));
        this.tipLabelText.setBackground(display.getSystemColor(29));
        this.tipLabelText.setLayoutData((Object)new GridData(772));
    }

    public void activateHoverInfo(final Control control) {
        control.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (TreeHoverInfo.this.tipShell.isVisible()) {
                    TreeHoverInfo.this.tipShell.setVisible(false);
                }
            }
        });
        control.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseExit(MouseEvent e) {
                if (TreeHoverInfo.this.tipShell.isVisible()) {
                    TreeHoverInfo.this.tipShell.setVisible(false);
                }
                TreeHoverInfo.this.tipWidget = null;
            }

            public void mouseHover(MouseEvent event) {
                Point pt = new Point(event.x, event.y);
                Widget widget = event.widget;
                if (widget instanceof Tree) {
                    Tree w = (Tree)widget;
                    widget = w.getItem(pt);
                }
                if (widget == null) {
                    TreeHoverInfo.this.tipShell.setVisible(false);
                    TreeHoverInfo.this.tipWidget = null;
                    return;
                }
                if (widget == TreeHoverInfo.this.tipWidget) {
                    return;
                }
                TreeHoverInfo.this.tipWidget = widget;
                String text = (String)widget.getData("hoverInfo");
                if (text != null) {
                    TreeHoverInfo.this.tipPosition = control.toDisplay(pt);
                    TreeHoverInfo.this.tipLabelText.setText(text != null ? text : "");
                    TreeHoverInfo.this.tipShell.pack();
                    TreeHoverInfo.this.setHoverLocation(TreeHoverInfo.this.tipShell, TreeHoverInfo.this.tipPosition);
                    TreeHoverInfo.this.tipShell.setVisible(true);
                }
            }
        });
    }

    private void setHoverLocation(Shell shell, Point position) {
        Rectangle displayBounds = shell.getDisplay().getBounds();
        Rectangle shellBounds = shell.getBounds();
        shellBounds.x = Math.max(Math.min(position.x, displayBounds.width - shellBounds.width), 0);
        shellBounds.y = Math.max(Math.min(position.y + 16, displayBounds.height - shellBounds.height), 0);
        shell.setBounds(shellBounds);
    }
}

