/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.util;

import com.ibm.team.enterprise.metadata.ui.MetadataUIPlugin;
import com.ibm.team.enterprise.rdf.query.common.select.result.Binding;
import com.ibm.team.enterprise.rdf.query.common.select.result.SelectResult;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IComponentSearchCriteria;
import com.ibm.team.scm.common.dto.IWorkspaceSearchCriteria;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SCMUtil {
    public static void addComponentNameBinding(ITeamRepository repository, List<SelectResult> results) {
        SCMUtil.addComponentNameBinding(SCMUtil.getAllComponents(repository), results);
    }

    public static void addComponentNameBinding(List<IComponent> components, List<SelectResult> results) {
        block0: for (SelectResult result : results) {
            List bindings = result.getBindings();
            for (Binding binding : bindings) {
                if (!binding.getName().equals("componentId")) continue;
                String componentId = binding.getValue();
                String componentName = SCMUtil.getComponentName(components, componentId);
                if (componentName == null) continue block0;
                Binding componentNameBinding = new Binding("componentName", componentName);
                result.add(componentNameBinding);
                continue block0;
            }
        }
    }

    protected static String getComponentName(List<IComponent> components, String componentUUID) {
        IComponent component = SCMUtil.getComponent(components, componentUUID);
        if (component != null) {
            return component.getName();
        }
        return null;
    }

    public static IComponent getComponent(List<IComponent> components, String componentUUID) {
        if (componentUUID == null) {
            return null;
        }
        for (IComponent component : components) {
            if (!component.getItemId().getUuidValue().equals(componentUUID)) continue;
            return component;
        }
        return null;
    }

    public static List<IComponent> getAllComponents(final ITeamRepository repository) {
        final ArrayList<IComponent> componentList = new ArrayList<IComponent>();
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    IWorkspaceManager manager = SCMPlatform.getWorkspaceManager((ITeamRepository)repository);
                    IComponentSearchCriteria criteria = IComponentSearchCriteria.FACTORY.newInstance();
                    List componentHandles = manager.findComponents(criteria, Integer.MAX_VALUE, null);
                    List tempcomponents = repository.itemManager().fetchPartialItems(componentHandles, 1, Arrays.asList(IComponent.ITEM_ID_PROPERTY, IComponent.NAME_PROPERTY), null);
                    componentList.addAll(tempcomponents);
                }
                catch (TeamRepositoryException e) {
                    MetadataUIPlugin.getDefault().logError(null, (Exception)((Object)e));
                }
            }
        };
        try {
            thread.start();
            thread.join();
        }
        catch (InterruptedException e) {
            MetadataUIPlugin.getDefault().logError(null, e);
        }
        return componentList;
    }

    public static List<IComponent> getComponentsByProjectArea(final IProjectAreaHandle projectArea, final boolean isCurrentPA) throws TeamRepositoryException {
        final ArrayList<IComponent> componentList = new ArrayList<IComponent>();
        final StringBuilder logMesages = new StringBuilder();
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    ITeamRepository repository = (ITeamRepository)projectArea.getOrigin();
                    if (!repository.loggedIn()) {
                        repository.login(null);
                    }
                    IWorkspaceManager manager = SCMPlatform.getWorkspaceManager((ITeamRepository)repository);
                    IComponentSearchCriteria criteria = IComponentSearchCriteria.FACTORY.newInstance();
                    if (isCurrentPA) {
                        criteria.getFilterByOwnerOptional().add(projectArea);
                        if (projectArea instanceof IProjectArea) {
                            criteria.getFilterByOwnerOptional().addAll(((IProjectArea)projectArea).getTeamAreas());
                        }
                        criteria.getFilterByOwnerOptional().add(repository.loggedInContributor());
                    }
                    List componentHandles = manager.findComponents(criteria, Integer.MAX_VALUE, null);
                    List tempcomponents = repository.itemManager().fetchPartialItems(componentHandles, 1, Arrays.asList(IComponent.ITEM_ID_PROPERTY, IComponent.NAME_PROPERTY), null);
                    if (tempcomponents != null) {
                        componentList.addAll(tempcomponents);
                    }
                }
                catch (TeamRepositoryException e) {
                    MetadataUIPlugin.getDefault().logError(null, (Exception)((Object)e));
                    logMesages.append(e.getLocalizedMessage());
                }
            }
        };
        try {
            thread.start();
            thread.join();
        }
        catch (InterruptedException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        if (logMesages.toString().length() > 0) {
            throw new TeamRepositoryException(logMesages.toString());
        }
        return componentList;
    }

    public static Map<String, String> getComponentOwnerUUIDAndNameMap(final IProjectAreaHandle projectArea) throws TeamRepositoryException {
        final HashMap<String, String> result = new HashMap<String, String>();
        final StringBuilder logMesages = new StringBuilder();
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    ITeamRepository repository = (ITeamRepository)projectArea.getOrigin();
                    if (!repository.loggedIn()) {
                        repository.login(null);
                    }
                    if (projectArea instanceof IProjectArea) {
                        IProjectArea pa = (IProjectArea)projectArea;
                        result.put(pa.getItemId().getUuidValue(), pa.getName());
                        List teams = repository.itemManager().fetchPartialItems(pa.getTeamAreas(), 1, Collections.singletonList("name"), null);
                        int i = 0;
                        while (i < teams.size()) {
                            Object team = teams.get(i);
                            if (team != null && team instanceof ITeamArea) {
                                ITeamArea teamArea = (ITeamArea)team;
                                result.put(teamArea.getItemId().getUuidValue(), teamArea.getName());
                            }
                            ++i;
                        }
                        IContributor owner = repository.loggedInContributor();
                        if (owner != null) {
                            result.put(owner.getItemId().getUuidValue(), owner.getName());
                        }
                    }
                }
                catch (TeamRepositoryException e) {
                    MetadataUIPlugin.getDefault().logError(null, (Exception)((Object)e));
                    logMesages.append(e.getLocalizedMessage());
                }
            }
        };
        try {
            thread.start();
            thread.join();
        }
        catch (InterruptedException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        if (logMesages.toString().length() > 0) {
            throw new TeamRepositoryException(logMesages.toString());
        }
        return result;
    }

    public static Map<String, String> getComponentOwnerMap(IProjectAreaHandle projectArea, List<IComponentHandle> componentHandles) throws TeamRepositoryException {
        return SCMUtil.getComponentOwnerMap((ITeamRepository)projectArea.getOrigin(), componentHandles);
    }

    public static Map<String, String> getComponentOwnerMap(final ITeamRepository repository, final List<IComponentHandle> componentHandles) throws TeamRepositoryException {
        final HashMap<String, String> result = new HashMap<String, String>();
        final StringBuilder logMesages = new StringBuilder();
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    if (!repository.loggedIn()) {
                        repository.login(null);
                    }
                    IWorkspaceManager manager = SCMPlatform.getWorkspaceManager((ITeamRepository)repository);
                    List owners = manager.findOwnersForComponents(componentHandles, null);
                    int i = 0;
                    while (i < owners.size()) {
                        result.put(((IComponentHandle)componentHandles.get(i)).getItemId().getUuidValue(), ((IAuditableHandle)owners.get(i)).getItemId().getUuidValue());
                        ++i;
                    }
                }
                catch (TeamRepositoryException e) {
                    MetadataUIPlugin.getDefault().logError(null, (Exception)((Object)e));
                    logMesages.append(e.getLocalizedMessage());
                }
            }
        };
        try {
            thread.start();
            thread.join();
        }
        catch (InterruptedException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        if (logMesages.toString().length() > 0) {
            throw new TeamRepositoryException(logMesages.toString());
        }
        return result;
    }

    public static List<IWorkspace> getAllStreams(final ITeamRepository repo) {
        final ArrayList<IWorkspace> streams = new ArrayList<IWorkspace>();
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    IWorkspaceManager manager = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
                    IWorkspaceSearchCriteria criteria = IWorkspaceSearchCriteria.FACTORY.newInstance().setKind(1);
                    List streamHandles = manager.findWorkspaces(criteria, Integer.MAX_VALUE, null);
                    List tempstreams = repo.itemManager().fetchPartialItems(streamHandles, 1, Collections.singletonList(IWorkspace.NAME_PROPERTY), null);
                    if (tempstreams != null) {
                        streams.addAll(tempstreams);
                    }
                }
                catch (TeamRepositoryException e) {
                    MetadataUIPlugin.getDefault().logError(null, (Exception)((Object)e));
                }
            }
        };
        try {
            thread.start();
            thread.join();
        }
        catch (InterruptedException e) {
            MetadataUIPlugin.getDefault().logError(null, e);
        }
        return streams;
    }

    public static List<IWorkspaceConnection> getAllStreamsConnections(final ITeamRepository repo) {
        final ArrayList<IWorkspaceConnection> streams = new ArrayList<IWorkspaceConnection>();
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    IWorkspaceManager manager = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
                    IWorkspaceSearchCriteria criteria = IWorkspaceSearchCriteria.FACTORY.newInstance().setKind(1);
                    List streamHandles = manager.findWorkspaces(criteria, Integer.MAX_VALUE, null);
                    List tempstreams = manager.getWorkspaceConnections(streamHandles, null);
                    if (tempstreams != null) {
                        streams.addAll(tempstreams);
                    }
                }
                catch (TeamRepositoryException e) {
                    MetadataUIPlugin.getDefault().logError(null, (Exception)((Object)e));
                }
            }
        };
        try {
            thread.start();
            thread.join();
        }
        catch (InterruptedException e) {
            MetadataUIPlugin.getDefault().logError(null, e);
        }
        return streams;
    }

    public static IWorkspaceConnection getWorkspaceConnection(IWorkspace stream) throws TeamRepositoryException {
        IWorkspaceConnection result = null;
        if (stream != null) {
            ITeamRepository repo = (ITeamRepository)stream.getOrigin();
            IWorkspaceManager manager = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
            result = manager.getWorkspaceConnection((IWorkspaceHandle)stream, null);
        }
        return result;
    }

    public static void addStreamNameBinding(ITeamRepository repository, List<SelectResult> results) {
        SCMUtil.addStreamNameBinding(SCMUtil.getAllStreams(repository), results);
    }

    public static String getStreamName(List<IWorkspace> streams, String streamUUID) {
        IWorkspace stream = SCMUtil.getStream(streams, streamUUID);
        if (stream != null) {
            return stream.getName();
        }
        return null;
    }

    public static IWorkspace getStream(List<IWorkspace> streams, String streamUUID) {
        if (streamUUID == null) {
            return null;
        }
        for (IWorkspace stream : streams) {
            if (!stream.getItemId().getUuidValue().equals(streamUUID)) continue;
            return stream;
        }
        return null;
    }

    public static void addStreamNameBinding(List<IWorkspace> streams, List<SelectResult> results) {
        block0: for (SelectResult result : results) {
            List bindings = result.getBindings();
            for (Binding binding : bindings) {
                if (!binding.getName().equals("streamId")) continue;
                String streamId = binding.getValue();
                String streamName = SCMUtil.getStreamName(streams, streamId);
                Binding streamNameBinding = new Binding("streamName", streamName);
                result.add(streamNameBinding);
                continue block0;
            }
        }
    }
}

