/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.util;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.enterprise.build.client.dependencyset.ClientFactory;
import com.ibm.team.enterprise.build.client.dependencyset.IDependencySetClient;
import com.ibm.team.enterprise.metadata.ui.MetadataUIPlugin;
import com.ibm.team.enterprise.metadata.ui.query.util.DependencySetFileParser;
import com.ibm.team.enterprise.metadata.ui.query.util.ImpactAnalysisCalculator;
import com.ibm.team.enterprise.metadata.ui.query.util.JazzFile;
import com.ibm.team.enterprise.metadata.ui.query.util.SCMUtil;
import com.ibm.team.enterprise.metadata.ui.query.view.QueryView;
import com.ibm.team.enterprise.rdf.query.common.select.result.Binding;
import com.ibm.team.enterprise.rdf.query.common.select.result.SelectResult;
import com.ibm.team.enterprise.systemdefinition.common.model.ILanguageDefinition;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.PartInitException;

public class PhysicalImpactAnalysisCalculator
extends ImpactAnalysisCalculator {
    private static final String QUERY_VIEW_ID = "com.ibm.teamz.metadata.query.ui.view.QueryView";

    public PhysicalImpactAnalysisCalculator(IResource resource, IProgressMonitor monitor) throws TeamRepositoryException {
        super(resource, monitor);
    }

    public PhysicalImpactAnalysisCalculator(SelectResult selectResult, IProgressMonitor monitor) throws TeamRepositoryException {
        super(JazzFile.createJazzFile(selectResult, monitor));
    }

    public PhysicalImpactAnalysisCalculator(JazzFile jazzFile) throws TeamRepositoryException {
        super(jazzFile);
    }

    public List<SelectResult> calculatePhysicalDependencies(ILanguageDefinition langDef, IBuildDefinition buildDef, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.calculatePhysicalDependencies(langDef.getItemId().getUuidValue(), buildDef, monitor);
    }

    @Deprecated
    public List<SelectResult> calculatePhysicalDependencies(com.ibm.team.enterprise.systemdefinition.common.ILanguageDefinition langDef, IBuildDefinition buildDef, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.calculatePhysicalDependencies(langDef.getUuid(), buildDef, monitor);
    }

    private List<SelectResult> calculatePhysicalDependencies(String langDefUUIDString, IBuildDefinition buildDef, IProgressMonitor monitor) throws TeamRepositoryException {
        this.fTeamRepository = this.jazzFile.getTeamRepository();
        IComponentHandle componentHandle = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(UUID.valueOf((String)this.jazzFile.getComponentId()), null);
        IComponent component = (IComponent)this.fTeamRepository.itemManager().fetchCompleteItem((IItemHandle)componentHandle, 0, null);
        IDependencySetClient client = ClientFactory.getDependencySetClient((ITeamRepository)this.fTeamRepository);
        String dsString = client.buildDependencySet2(this.jazzFile.getFileItemId(), langDefUUIDString, component.getName(), this.jazzFile.getStreamId(), this.createBuildProperties(buildDef.getProperties()), monitor);
        List<String> dependencySetFiles = null;
        try {
            dependencySetFiles = new DependencySetFileParser().parse(new ByteArrayInputStream(dsString.getBytes("UTF-8")));
        }
        catch (Exception e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        ArrayList<SelectResult> allDependencies = new ArrayList<SelectResult>();
        this.calculatePhysicalDependencies(dependencySetFiles, this.jazzFile, allDependencies, monitor);
        for (SelectResult result : allDependencies) {
            result.add(new Binding("repositoryId", this.fTeamRepository.getId().getUuidValue()));
        }
        SCMUtil.addComponentNameBinding(this.fTeamRepository, allDependencies);
        return allDependencies;
    }

    private void calculatePhysicalDependencies(List<String> dependencySetFiles, JazzFile jazzFile, List<SelectResult> allDependencies, IProgressMonitor monitor) throws TeamRepositoryException {
        List<SelectResult> logicalDependencies = this.calculateLogicalDependencies(jazzFile, null, monitor);
        for (SelectResult logicalDependency : logicalDependencies) {
            JazzFile logicalFile = JazzFile.createJazzFile(logicalDependency, monitor);
            if (logicalFile.getFileItemId() == null || dependencySetFiles.indexOf(logicalFile.getFileItemId()) <= -1) continue;
            allDependencies.add(logicalDependency);
            dependencySetFiles.remove(logicalFile.getFileItemId());
            this.calculatePhysicalDependencies(dependencySetFiles, logicalFile, allDependencies, monitor);
        }
    }

    public List<SelectResult> calculatePhysicalImpacts(ILanguageDefinition langDef, IBuildDefinition buildDef, IProgressMonitor monitor) throws TeamRepositoryException {
        this.fTeamRepository = this.jazzFile.getTeamRepository();
        ArrayList<SelectResult> allImpacts = new ArrayList<SelectResult>();
        this.calculatePhysicalImpacts(this.jazzFile, allImpacts, langDef, buildDef, monitor);
        for (SelectResult result : allImpacts) {
            result.add(new Binding("repositoryId", this.fTeamRepository.getId().getUuidValue()));
        }
        SCMUtil.addComponentNameBinding(this.fTeamRepository, allImpacts);
        return allImpacts;
    }

    private void calculatePhysicalImpacts(JazzFile jazzFile, List<SelectResult> allImpacts, ILanguageDefinition langDef, IBuildDefinition buildDef, IProgressMonitor monitor) throws TeamRepositoryException {
        List<SelectResult> impacts = this.calculateLogicalImpacts(jazzFile, null, monitor);
        for (SelectResult impact : impacts) {
            JazzFile impactFile = JazzFile.createJazzFile(impact, monitor);
            if (this.findJazzFile(impactFile, allImpacts, monitor)) continue;
            IComponentHandle componentHandle = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(UUID.valueOf((String)impactFile.getComponentId()), null);
            IComponent component = (IComponent)this.fTeamRepository.itemManager().fetchCompleteItem((IItemHandle)componentHandle, 0, null);
            IDependencySetClient client = ClientFactory.getDependencySetClient((ITeamRepository)this.fTeamRepository);
            String dsString = client.buildDependencySet2(impactFile.getFileItemId(), langDef.getItemId().getUuidValue(), component.getName(), impactFile.getStreamId(), this.createBuildProperties(buildDef.getProperties()), monitor);
            List<String> dependencySetFiles = null;
            try {
                dependencySetFiles = new DependencySetFileParser().parse(new ByteArrayInputStream(dsString.getBytes("UTF-8")));
            }
            catch (Exception e) {
                throw new TeamRepositoryException((Throwable)e);
            }
            if (dependencySetFiles.indexOf(jazzFile.getFileItemId()) <= -1) continue;
            allImpacts.add(impact);
            this.calculatePhysicalImpacts(impactFile, allImpacts, langDef, buildDef, monitor);
        }
    }

    private Map<String, Object> createBuildProperties(List<?> propertyList) {
        if (propertyList == null || propertyList.size() == 0) {
            return null;
        }
        HashMap<String, Object> propertyMap = new HashMap<String, Object>();
        for (IBuildProperty prop : propertyList) {
            propertyMap.put(prop.getName(), prop.getValue());
        }
        return propertyMap;
    }

    private boolean findJazzFile(JazzFile file, List<SelectResult> allImpacts, IProgressMonitor monitor) throws TeamRepositoryException {
        for (SelectResult impact : allImpacts) {
            JazzFile jFile = JazzFile.createJazzFile(impact, monitor);
            if (!jFile.getFileItemId().equals(file.getFileItemId())) continue;
            return true;
        }
        return false;
    }

    public static final QueryView openQueryView() {
        try {
            return (QueryView)MetadataUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(QUERY_VIEW_ID);
        }
        catch (PartInitException e) {
            e.printStackTrace();
            return null;
        }
    }
}

