/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.util;

import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class ObservableJFacePropertyValue
extends AbstractObservableValue {
    private final Object model;
    private final String fieldName;
    private Class<?> returnType;
    private Method setterMethod;
    private Method getterMethod;
    private final String property;
    private IPropertyChangeListener listener;
    private Method removePropertyListenerMethod;

    private static String getSetterName(String fieldName) {
        return "set" + ObservableJFacePropertyValue.toMethodSuffix(fieldName);
    }

    private static String getGetterName(String fieldName) {
        return "get" + ObservableJFacePropertyValue.toMethodSuffix(fieldName);
    }

    private static String getBooleanGetterName(String fieldName) {
        return "is" + ObservableJFacePropertyValue.toMethodSuffix(fieldName);
    }

    private static String toMethodSuffix(String fieldName) {
        if (Character.isLowerCase(fieldName.charAt(0))) {
            return String.valueOf(Character.toUpperCase(fieldName.charAt(0))) + fieldName.substring(1);
        }
        return fieldName;
    }

    public ObservableJFacePropertyValue(Object model, String fieldName, String property) {
        this(Realm.getDefault(), model, fieldName, property);
    }

    public ObservableJFacePropertyValue(Realm realm, Object model, String fieldName, String property) {
        super(realm);
        this.model = model;
        this.fieldName = fieldName;
        this.property = property;
        try {
            try {
                String getterName = ObservableJFacePropertyValue.getGetterName(fieldName);
                this.getterMethod = model.getClass().getMethod(getterName, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                String getterName = ObservableJFacePropertyValue.getBooleanGetterName(fieldName);
                this.getterMethod = model.getClass().getMethod(getterName, new Class[0]);
            }
            this.returnType = this.getterMethod.getReturnType();
            this.setterMethod = model.getClass().getMethod(ObservableJFacePropertyValue.getSetterName(fieldName), this.returnType);
            this.listener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    if (event.getProperty().equals(ObservableJFacePropertyValue.this.property)) {
                        ObservableJFacePropertyValue.this.fireValueChange(Diffs.createValueDiff((Object)event.getOldValue(), (Object)event.getNewValue()));
                    }
                }
            };
            Method addPropertyListenerMethod = model.getClass().getMethod("addPropertyChangeListener", IPropertyChangeListener.class);
            this.removePropertyListenerMethod = model.getClass().getMethod("removePropertyChangeListener", IPropertyChangeListener.class);
            addPropertyListenerMethod.invoke(model, this.listener);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public synchronized void dispose() {
        super.dispose();
        try {
            this.removePropertyListenerMethod.invoke(this.model, this.listener);
        }
        catch (IllegalArgumentException e) {
            StatusUtil.log((Object)((Object)this), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            StatusUtil.log((Object)((Object)this), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            StatusUtil.log((Object)((Object)this), (Throwable)e);
        }
    }

    protected Object doGetValue() {
        try {
            return this.getterMethod.invoke(this.model, new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void doSetValue(Object value) {
        try {
            this.setterMethod.invoke(this.model, value);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    public Object getValueType() {
        return this.returnType;
    }

    public String getFieldName() {
        return this.fieldName;
    }
}

