/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.util;

import com.ibm.team.enterprise.metadata.query.common.IValidator;
import com.ibm.team.enterprise.metadata.ui.query.util.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class NumberValidator {
    public static final IValidator DOUBLE_VALIDATOR = new DoubleValidator(null, null);

    private static <T extends Number> IStatus checkRange(Comparable<T> value, T start, T end) {
        if (start != null && value.compareTo(start) < 0 || end != null && value.compareTo(end) > 0) {
            return NumberValidator.getRangeStatus(start, end);
        }
        return Status.OK_STATUS;
    }

    private static IStatus getRangeStatus(Number start, Number end) {
        String message = NLS.bind((String)Messages.NumberValidator_RANGE_MESSAGE_FORMAT, (Object)start.toString(), (Object)end.toString());
        return new Status(4, "com.ibm.team.enterprise.metadata.ui", message, null);
    }

    private static IStatus getStatus(String input, Throwable e) {
        String message = Messages.NumberValidator_ENTER_NUMBER_MESSAGE;
        return new Status(4, "com.ibm.team.enterprise.metadata.ui", message, e);
    }

    public static class DoubleValidator
    implements IValidator {
        private final Double rangeStart;
        private final Double rangeEnd;

        public DoubleValidator(Double rangeStart, Double rangeEnd) {
            this.rangeStart = rangeStart;
            this.rangeEnd = rangeEnd;
        }

        public IStatus validate(Object object) {
            String input = object.toString().trim();
            if (input.length() == 0) {
                return Status.OK_STATUS;
            }
            try {
                Double value = Double.parseDouble(object.toString());
                return NumberValidator.checkRange(value, this.rangeStart, this.rangeEnd);
            }
            catch (NumberFormatException e) {
                return NumberValidator.getStatus(input, e);
            }
        }
    }
}

