/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.util;

import com.ibm.team.enterprise.metadata.ui.query.util.ILanguageDefinitionContext;
import com.ibm.team.enterprise.metadata.ui.query.util.Messages;
import com.ibm.team.enterprise.systemdefinition.client.ClientFactory;
import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.common.model.ILanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.ui.jobs.SystemDefinitionJob;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.ItemNotFoundException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;

public class LanguageDefinitionHelper {
    public void languageDefinitionAvailable(ILanguageDefinition languageDefinition, String errorMessage) {
    }

    public void getLanguageDefinitionInBackground(final ILanguageDefinitionContext context) {
        SystemDefinitionJob job = new SystemDefinitionJob(Messages.LanguageDefinitionLabelHelper_JobLabel, false){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                String langDefUuid = context.getLanguageDefinitionUUID();
                ILanguageDefinition langDef = null;
                if (langDefUuid.length() > 0) {
                    ISystemDefinitionModelClient langdefClient = ClientFactory.getSystemDefinitionModelClient((ITeamRepository)context.getTeamRepository());
                    langDef = (ILanguageDefinition)langdefClient.findSystemDefinition(langDefUuid, null, ILanguageDefinition.ITEM_TYPE, monitor);
                }
                if (langDef.getTranslators().size() < 1) {
                    LanguageDefinitionHelper.this.asyncLanguageDefintionAvailable(null, Messages.LanguageDefinitionHelper_MissingTranslators);
                } else {
                    LanguageDefinitionHelper.this.asyncLanguageDefintionAvailable(langDef, null);
                }
                return Status.OK_STATUS;
            }

            protected void jobFinished(IStatus status) {
                if (status.getException() instanceof ItemNotFoundException) {
                    LanguageDefinitionHelper.this.asyncLanguageDefintionAvailable(null, Messages.LabelHelper_ITEM_NOT_FOUND);
                } else if (status.getSeverity() == 4) {
                    LanguageDefinitionHelper.this.asyncLanguageDefintionAvailable(null, Messages.LabelHelper_EXCEPTION_OCCURRED);
                }
            }
        };
        job.schedule();
    }

    protected void asyncLanguageDefintionAvailable(final ILanguageDefinition languageDefinition, final String errorMessage) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                LanguageDefinitionHelper.this.languageDefinitionAvailable(languageDefinition, errorMessage);
            }
        });
    }
}

