/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.util;

import com.ibm.team.enterprise.metadata.ui.query.IRemoteFileDescriptor;
import com.ibm.team.enterprise.metadata.ui.query.util.ImpactAnalysisUtils;
import com.ibm.team.enterprise.rdf.query.common.select.result.Binding;
import com.ibm.team.enterprise.rdf.query.common.select.result.SelectResult;
import com.ibm.team.enterprise.systemdefinition.common.model.IIBMiPlatformObject;
import com.ibm.team.enterprise.systemdefinition.common.model.IPlatformObject;
import com.ibm.team.enterprise.systemdefinition.common.model.IZosPlatformObject;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.internal.filesystem.ui.adapters.AbstractAdaptableRemoteResource;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class JazzFile {
    private String streamId;
    private String fileItemId;
    private String componentId;
    private String fileResourceURI;
    private String filePath;
    private ITeamRepository teamRepository;
    private Class<? extends IPlatformObject> platform;
    private static final String IBMI_NATURE = "com.ibm.etools.iseries.perspective.nature";
    private static final String ZOS_NATURE = "com.ibm.teamz.zcomponent.AntzBuild";

    private JazzFile() {
    }

    public static JazzFile createJazzFile(IResource resource, IProgressMonitor monitor) throws TeamRepositoryException {
        JazzFile jazzFile = new JazzFile();
        jazzFile.filePath = resource.getLocation().toString();
        IShareable shareable = ImpactAnalysisUtils.getSharable((IAdaptable)resource);
        ITeamRepository repo = ImpactAnalysisUtils.getTeamRepository(shareable);
        if (repo != null && !repo.loggedIn()) {
            repo.login(monitor);
        }
        jazzFile.teamRepository = repo;
        IWorkspace stream = ImpactAnalysisUtils.getWorkspaceStream(SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getWorkspaceConnection(ImpactAnalysisUtils.getWorkspaceHandle(shareable), monitor), monitor);
        if (stream != null) {
            jazzFile.streamId = stream.getItemId().getUuidValue();
        }
        IShare share = shareable.getShare(monitor);
        ISharingDescriptor desc = share.getSharingDescriptor();
        jazzFile.componentId = desc.getComponent().getItemId().getUuidValue();
        try {
            if (resource.getProject().hasNature(IBMI_NATURE)) {
                jazzFile.platform = IIBMiPlatformObject.class;
            } else if (resource.getProject().hasNature(ZOS_NATURE)) {
                jazzFile.platform = IZosPlatformObject.class;
            }
        }
        catch (CoreException ce) {
            throw new TeamRepositoryException((Throwable)ce);
        }
        IVersionableHandle vh = shareable.getVersionable((IProgressMonitor)new NullProgressMonitor());
        if (vh != null) {
            jazzFile.fileItemId = vh.getItemId().getUuidValue();
            String fileSlug = ImpactAnalysisUtils.getSlug(jazzFile.fileItemId);
            jazzFile.fileResourceURI = "http://www.ibm.com/xmlns/prod/rational/rtc/scd/file/" + fileSlug;
        }
        return jazzFile;
    }

    public static JazzFile createJazzFile(SelectResult selectResult, IProgressMonitor monitor) throws TeamRepositoryException {
        JazzFile jazzFile = new JazzFile();
        List bindings = selectResult.getBindings();
        for (Binding binding : bindings) {
            if (binding.getName().equals("streamId")) {
                jazzFile.streamId = binding.getValue();
                continue;
            }
            if (binding.getName().equals("fileItemId")) {
                jazzFile.fileItemId = binding.getValue();
                continue;
            }
            if (binding.getName().equals("componentId")) {
                jazzFile.componentId = binding.getValue();
                continue;
            }
            if (binding.getName().equals("filePath")) {
                jazzFile.filePath = binding.getValue();
                continue;
            }
            if (!"repositoryId".equals(binding.getName())) continue;
            jazzFile.teamRepository = ImpactAnalysisUtils.lookupRepository(UUID.valueOf((String)binding.getValue()));
        }
        String fileSlug = ImpactAnalysisUtils.getSlug(jazzFile.fileItemId);
        jazzFile.fileResourceURI = "http://www.ibm.com/xmlns/prod/rational/rtc/scd/file/" + fileSlug;
        if (jazzFile.teamRepository != null && !jazzFile.teamRepository.loggedIn()) {
            jazzFile.teamRepository.login(monitor);
        }
        return jazzFile;
    }

    public static JazzFile createJazzFile(IRemoteFileDescriptor remoteFileDescriptor, IProgressMonitor monitor) throws TeamRepositoryException {
        JazzFile jazzFile = new JazzFile();
        jazzFile.streamId = remoteFileDescriptor.getStreamUUID().getUuidValue();
        jazzFile.fileItemId = remoteFileDescriptor.getFileUUID().getUuidValue();
        jazzFile.fileResourceURI = "http://www.ibm.com/xmlns/prod/rational/rtc/scd/file/" + ImpactAnalysisUtils.getSlug(jazzFile.fileItemId);
        jazzFile.componentId = remoteFileDescriptor.getComponentUUID().getUuidValue();
        jazzFile.teamRepository = ImpactAnalysisUtils.lookupRepository(remoteFileDescriptor.getRepoUUID());
        if (jazzFile.teamRepository != null && !jazzFile.teamRepository.loggedIn()) {
            jazzFile.teamRepository.login(monitor);
        }
        return jazzFile;
    }

    public static JazzFile createJazzFile(AbstractAdaptableRemoteResource remote, IProgressMonitor monitor) throws TeamRepositoryException {
        JazzFile jazzFile = new JazzFile();
        IShareable shareable = (IShareable)remote.getAdapter(IShareable.class);
        jazzFile.filePath = shareable.getFullPath().toString();
        ITeamRepository repo = ImpactAnalysisUtils.getTeamRepository(shareable);
        if (repo != null && !repo.loggedIn()) {
            repo.login(monitor);
        }
        jazzFile.teamRepository = repo;
        IWorkspace stream = ImpactAnalysisUtils.getWorkspaceStream(SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getWorkspaceConnection(ImpactAnalysisUtils.getWorkspaceHandle(shareable), monitor), monitor);
        if (stream != null) {
            jazzFile.streamId = stream.getItemId().getUuidValue();
        }
        IShare share = shareable.getShare(monitor);
        ISharingDescriptor desc = share.getSharingDescriptor();
        jazzFile.componentId = desc.getComponent().getItemId().getUuidValue();
        if (remote.testAttribute((Object)remote, "remoteType", "ibmi")) {
            jazzFile.platform = IIBMiPlatformObject.class;
        } else if (remote.testAttribute((Object)remote, "remoteType", "zos")) {
            jazzFile.platform = IZosPlatformObject.class;
        }
        IVersionableHandle vh = shareable.getVersionable((IProgressMonitor)new NullProgressMonitor());
        if (vh != null) {
            jazzFile.fileItemId = vh.getItemId().getUuidValue();
            String fileSlug = ImpactAnalysisUtils.getSlug(jazzFile.fileItemId);
            jazzFile.fileResourceURI = "http://www.ibm.com/xmlns/prod/rational/rtc/scd/file/" + fileSlug;
        }
        return jazzFile;
    }

    public String getStreamId() {
        return this.streamId;
    }

    public String getFileItemId() {
        return this.fileItemId;
    }

    public String getFileResourceURI() {
        return this.fileResourceURI;
    }

    public String getComponentId() {
        return this.componentId;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public Class<? extends IPlatformObject> getPlatform() {
        return this.platform;
    }

    public ITeamRepository getTeamRepository() {
        return this.teamRepository;
    }
}

