/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.util;

import com.ibm.team.enterprise.common.ui.util.Utils;
import com.ibm.team.enterprise.metadata.query.common.Attribute;
import com.ibm.team.enterprise.metadata.query.common.AttributeColumn;
import com.ibm.team.enterprise.metadata.query.common.IAttribute;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.internal.filesystem.ui.adapters.AbstractAdaptableRemoteResource;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IFlowEntry;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class ImpactAnalysisUtils {
    public static ITeamRepository getTeamRepository(IShareable shareable) {
        if (shareable == null) {
            return null;
        }
        IShare share = null;
        try {
            share = shareable.getShare((IProgressMonitor)new NullProgressMonitor());
        }
        catch (FileSystemException fileSystemException) {
            // empty catch block
        }
        if (share == null) {
            return null;
        }
        return ImpactAnalysisUtils.lookupRepository(share.getSharingDescriptor().getRepositoryId());
    }

    public static ITeamRepository lookupRepository(UUID repoId) {
        return Utils.getTeamRepository((UUID)repoId);
    }

    public static IShareable getSharable(IAdaptable adaptable) {
        if (adaptable == null) {
            return null;
        }
        IShareable shareable = (IShareable)adaptable.getAdapter(IShareable.class);
        if (shareable != null) {
            return shareable;
        }
        AbstractAdaptableRemoteResource aarr = (AbstractAdaptableRemoteResource)adaptable.getAdapter(AbstractAdaptableRemoteResource.class);
        if (aarr != null) {
            shareable = (IShareable)aarr.getAdapter(IShareable.class);
        }
        return shareable;
    }

    public static IWorkspaceHandle getWorkspaceHandle(IShareable share) throws FileSystemException {
        IShare s = share.getShare((IProgressMonitor)new NullProgressMonitor());
        ISharingDescriptor desc = s.getSharingDescriptor();
        return (IWorkspaceHandle)desc.getConnectionHandle();
    }

    public static IWorkspace getWorkspaceStream(IWorkspaceConnection wsConn, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkspace defaultAcceptWorkspace;
        if (wsConn.isStream()) {
            return wsConn.getResolvedWorkspace();
        }
        IFlowEntry defaultAcceptFlowEntry = wsConn.getFlowTable().getDefaultAcceptFlow();
        if (defaultAcceptFlowEntry != null && (defaultAcceptWorkspace = (IWorkspace)wsConn.teamRepository().itemManager().fetchPartialItem((IItemHandle)defaultAcceptFlowEntry.getFlowNode(), 0, Collections.singletonList(IWorkspace.STREAM_PROPERTY), monitor)).isStream()) {
            return defaultAcceptWorkspace;
        }
        return null;
    }

    public static String getSlug(String itemId) {
        StringBuffer slugBuffer = new StringBuffer("_itemId=");
        slugBuffer.append(itemId);
        return slugBuffer.toString();
    }

    public static List<AttributeColumn> getViewerColumns() {
        ArrayList<AttributeColumn> columns = new ArrayList<AttributeColumn>();
        Attribute attribute = new Attribute(null, "http://www.ibm.com/xmlns/prod/rational/rtc/metadata/sourcefile/scm/", "fileName");
        AttributeColumn column = new AttributeColumn((IAttribute)attribute);
        columns.add(column);
        attribute = new Attribute(null, "http://www.ibm.com/xmlns/prod/rational/rtc/metadata/sourcefile/scm/", "filePath");
        column = new AttributeColumn((IAttribute)attribute);
        columns.add(column);
        attribute = new Attribute(null, "http://www.ibm.com/xmlns/prod/rational/rtc/metadata/sourcefile/scm/", "componentName");
        column = new AttributeColumn((IAttribute)attribute);
        columns.add(column);
        attribute = new Attribute(null, "http://www.ibm.com/xmlns/prod/rational/rtc/metadata/sourcefile/dependency/", "dependencyReferenceType");
        column = new AttributeColumn((IAttribute)attribute);
        columns.add(column);
        return columns;
    }
}

