/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.util;

import com.ibm.team.enterprise.build.client.dependencyset.ClientFactory;
import com.ibm.team.enterprise.build.client.dependencyset.IDependencySetClient;
import com.ibm.team.enterprise.metadata.ui.query.util.JazzFile;
import com.ibm.team.enterprise.metadata.ui.query.util.SCMUtil;
import com.ibm.team.enterprise.rdf.query.client.IDependencyQueryClient;
import com.ibm.team.enterprise.rdf.query.common.select.result.Binding;
import com.ibm.team.enterprise.rdf.query.common.select.result.SelectResult;
import com.ibm.team.enterprise.rdf.query.common.select.result.SelectResultFeedParser;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;

public class ImpactAnalysisCalculator {
    protected JazzFile jazzFile;
    protected ITeamRepository fTeamRepository;
    private Boolean ignoreFileTypes;

    public ImpactAnalysisCalculator(IResource resource, IProgressMonitor monitor) throws TeamRepositoryException {
        this.jazzFile = JazzFile.createJazzFile(resource, monitor);
    }

    public ImpactAnalysisCalculator(JazzFile jazzFile) {
        this.jazzFile = jazzFile;
    }

    public boolean isIgnoreFileTypes(IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.ignoreFileTypes == null) {
            if (this.fTeamRepository == null) {
                this.fTeamRepository = this.jazzFile.getTeamRepository();
            }
            IDependencySetClient dependencySetClient = ClientFactory.getDependencySetClient((ITeamRepository)this.fTeamRepository);
            this.ignoreFileTypes = dependencySetClient.isIgnoreFileTypeForDependencySearch(monitor);
        }
        return this.ignoreFileTypes;
    }

    public void setIgnoreFileTypes(boolean ignore) {
        this.ignoreFileTypes = ignore;
    }

    public List<SelectResult> calculateLogicalDependencies(String searchStreamUUID, IProgressMonitor monitor) throws TeamRepositoryException {
        this.fTeamRepository = this.jazzFile.getTeamRepository();
        List<SelectResult> results = this.calculateLogicalDependencies(this.jazzFile, searchStreamUUID, monitor);
        ArrayList<SelectResult> dependenciesResults = new ArrayList<SelectResult>();
        HashMap dependenciesMap = new HashMap();
        for (SelectResult result : results) {
            List dependencyFields = result.getBindings();
            String fileName = null;
            String filePath = null;
            for (Binding dependencyField : dependencyFields) {
                if (dependencyField.getName().equals("fileName")) {
                    fileName = this.computeDependencyLogicName(dependencyField.getValue());
                    continue;
                }
                if (!dependencyField.getName().equals("filePath")) continue;
                filePath = dependencyField.getValue();
            }
            if (dependenciesMap.containsKey(String.valueOf(fileName) + filePath)) continue;
            result.add(new Binding("repositoryId", this.fTeamRepository.getId().getUuidValue()));
            dependenciesResults.add(result);
            dependenciesMap.put(String.valueOf(fileName) + filePath, null);
        }
        SCMUtil.addComponentNameBinding(this.fTeamRepository, results);
        return dependenciesResults;
    }

    public List<SelectResult> calculateLogicalDependencies2(String searchStreamUUID, IProgressMonitor monitor) throws TeamRepositoryException {
        this.fTeamRepository = this.jazzFile.getTeamRepository();
        ArrayList<SelectResult> allDependencies = new ArrayList<SelectResult>();
        this.calculateLogicalDependenciesRecursively(this.jazzFile, searchStreamUUID, allDependencies, monitor);
        ArrayList<SelectResult> dependenciesResults = new ArrayList<SelectResult>();
        HashMap dependenciesMap = new HashMap();
        for (SelectResult result : allDependencies) {
            List dependencyFields = result.getBindings();
            String fileName = null;
            String filePath = null;
            for (Binding dependencyField : dependencyFields) {
                if (dependencyField.getName().equals("fileName")) {
                    fileName = this.computeDependencyLogicName(dependencyField.getValue());
                    continue;
                }
                if (!dependencyField.getName().equals("filePath")) continue;
                filePath = dependencyField.getValue();
            }
            if (dependenciesMap.containsKey(String.valueOf(fileName) + filePath)) continue;
            result.add(new Binding("repositoryId", this.fTeamRepository.getId().getUuidValue()));
            dependenciesResults.add(result);
            dependenciesMap.put(String.valueOf(fileName) + filePath, null);
        }
        SCMUtil.addComponentNameBinding(this.fTeamRepository, allDependencies);
        return dependenciesResults;
    }

    private void calculateLogicalDependenciesRecursively(JazzFile jazzFile, String searchStreamUUID, List<SelectResult> allDependencies, IProgressMonitor monitor) throws TeamRepositoryException {
        List<SelectResult> logicalDependencies = this.calculateLogicalDependencies(jazzFile, searchStreamUUID, monitor);
        for (SelectResult logicalDependency : logicalDependencies) {
            JazzFile logicalFile = JazzFile.createJazzFile(logicalDependency, monitor);
            if (logicalFile.getFileItemId() == null) continue;
            allDependencies.add(logicalDependency);
            this.calculateLogicalDependenciesRecursively(logicalFile, searchStreamUUID, allDependencies, monitor);
        }
    }

    protected List<SelectResult> calculateLogicalDependencies(JazzFile jazzFile, String searchStreamUUID, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<SelectResult> resolvedDependencies = new ArrayList<SelectResult>();
        IDependencyQueryClient dependencyQueryClient = com.ibm.team.enterprise.rdf.query.client.ClientFactory.getDependencyQueryClient((ITeamRepository)this.fTeamRepository);
        String results = dependencyQueryClient.executeLogicalDependenciesQuery(UUID.valueOf((String)jazzFile.getStreamId()), UUID.valueOf((String)jazzFile.getFileItemId()), monitor);
        if (results == null) {
            return resolvedDependencies;
        }
        List logicalDependencies = null;
        try {
            SelectResultFeedParser parser = new SelectResultFeedParser();
            logicalDependencies = parser.parse((InputStream)new ByteArrayInputStream(results.getBytes("UTF-8")));
            if (logicalDependencies.size() == 0) {
                return resolvedDependencies;
            }
        }
        catch (Exception e) {
            throw new TeamRepositoryException(e.getMessage());
        }
        for (SelectResult logicalDependency : logicalDependencies) {
            List dependencyFields = logicalDependency.getBindings();
            String dependencyLogicalName = null;
            String dependencyFileType = null;
            String dependencyReferenceType = null;
            for (Binding dependencyField : dependencyFields) {
                if (dependencyField.getName().equals("dependencyLogicalName")) {
                    dependencyLogicalName = this.computeDependencyLogicName(dependencyField.getValue());
                    continue;
                }
                if (dependencyField.getName().equals("dependencyFileType") && !this.isIgnoreFileTypes(monitor)) {
                    dependencyFileType = dependencyField.getValue();
                    continue;
                }
                if (!"dependencyReferenceType".equals(dependencyField.getName())) continue;
                dependencyReferenceType = dependencyField.getValue();
            }
            results = dependencyQueryClient.executeDependenciesMetadataQuery(UUID.valueOf((String)(searchStreamUUID != null ? searchStreamUUID : jazzFile.getStreamId())), dependencyLogicalName, dependencyFileType, monitor);
            if (results == null) continue;
            try {
                SelectResultFeedParser parser = new SelectResultFeedParser();
                List results2 = parser.parse((InputStream)new ByteArrayInputStream(results.getBytes("UTF-8")));
                if (dependencyReferenceType != null) {
                    Binding binding = new Binding("dependencyReferenceType", dependencyReferenceType);
                    for (SelectResult result2 : results2) {
                        result2.add(binding);
                    }
                }
                resolvedDependencies.addAll(results2);
            }
            catch (Exception e) {
                throw new TeamRepositoryException(e.getMessage());
            }
        }
        return resolvedDependencies;
    }

    protected String computeDependencyLogicName(String rawDependencyLogicName) {
        return rawDependencyLogicName;
    }

    public List<SelectResult> calculateLogicalImpacts(String searchStreamUUID, IProgressMonitor monitor) throws TeamRepositoryException {
        this.fTeamRepository = this.jazzFile.getTeamRepository();
        List<SelectResult> results = this.calculateLogicalImpacts(this.jazzFile, searchStreamUUID, monitor);
        ArrayList<SelectResult> impactResults = new ArrayList<SelectResult>();
        HashMap logicImpactMap = new HashMap();
        for (SelectResult result : results) {
            List dependencyFields = result.getBindings();
            String fileName = null;
            String filePath = null;
            for (Binding dependencyField : dependencyFields) {
                if (dependencyField.getName().equals("fileName")) {
                    fileName = this.computeDependencyLogicName(dependencyField.getValue());
                    continue;
                }
                if (!dependencyField.getName().equals("filePath")) continue;
                filePath = dependencyField.getValue();
            }
            if (logicImpactMap.containsKey(String.valueOf(fileName) + filePath)) continue;
            result.add(new Binding("repositoryId", this.fTeamRepository.getId().getUuidValue()));
            impactResults.add(result);
            logicImpactMap.put(String.valueOf(fileName) + filePath, null);
        }
        SCMUtil.addComponentNameBinding(this.fTeamRepository, results);
        return impactResults;
    }

    protected List<SelectResult> calculateLogicalImpacts(JazzFile jazzFile, String searchStreamUUID, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<SelectResult> impacts = new ArrayList<SelectResult>();
        IDependencyQueryClient dependencyQueryClient = com.ibm.team.enterprise.rdf.query.client.ClientFactory.getDependencyQueryClient((ITeamRepository)this.fTeamRepository);
        String results = dependencyQueryClient.executeFileDependencyDataQuery(UUID.valueOf((String)jazzFile.getStreamId()), UUID.valueOf((String)jazzFile.getFileItemId()), monitor);
        if (results == null) {
            return impacts;
        }
        List fileDependencyData = null;
        try {
            SelectResultFeedParser parser = new SelectResultFeedParser();
            fileDependencyData = parser.parse((InputStream)new ByteArrayInputStream(results.getBytes("UTF-8")));
            if (fileDependencyData.size() == 0) {
                return impacts;
            }
        }
        catch (Exception e) {
            throw new TeamRepositoryException(e.getMessage());
        }
        List bindings = ((SelectResult)fileDependencyData.get(0)).getBindings();
        String logicalName = null;
        String fileType = null;
        for (Binding binding : bindings) {
            if (binding.getName().equals("logicalName")) {
                logicalName = binding.getValue();
                continue;
            }
            if (!binding.getName().equals("fileType") || this.isIgnoreFileTypes(monitor)) continue;
            fileType = binding.getValue();
        }
        if (logicalName == null || logicalName.length() == 0) {
            return impacts;
        }
        results = dependencyQueryClient.executeImpactsQuery(UUID.valueOf((String)(searchStreamUUID != null ? searchStreamUUID : jazzFile.getStreamId())), logicalName, fileType, monitor);
        if (results != null) {
            try {
                SelectResultFeedParser parser = new SelectResultFeedParser();
                impacts.addAll(parser.parse((InputStream)new ByteArrayInputStream(results.getBytes("UTF-8"))));
            }
            catch (Exception e) {
                throw new TeamRepositoryException(e.getMessage());
            }
        }
        return impacts;
    }
}

