/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class DependencySetFileParser
extends DefaultHandler {
    private final XMLReader fParser = XMLReaderFactory.createXMLReader();
    private List<String> fDependencyFiles;
    private String fileId;
    private StringBuilder chars;
    private boolean inUuid = false;

    public DependencySetFileParser() throws SAXException {
        this.fParser.setContentHandler(this);
        this.fParser.setDTDHandler(this);
        this.fParser.setEntityResolver(this);
        this.fParser.setErrorHandler(this);
    }

    public List<String> parse(InputStream inputStream) throws SAXException, IOException {
        this.fDependencyFiles = new ArrayList<String>();
        this.fParser.parse(new InputSource(inputStream));
        return this.fDependencyFiles;
    }

    public List<String> parse(String input) throws SAXException, IOException {
        return this.parse(new ByteArrayInputStream(input.getBytes()));
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (localName.equalsIgnoreCase("file")) {
            this.fileId = "";
        } else if (localName.equals("uuid")) {
            this.inUuid = true;
            this.chars = new StringBuilder();
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (localName.equalsIgnoreCase("file")) {
            this.fDependencyFiles.add(this.fileId);
        } else if (localName.equals("uuid")) {
            this.fileId = this.chars.toString();
            this.inUuid = false;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.inUuid) {
            this.chars.append(new String(ch, start, length));
        }
    }
}

