/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.util;

import com.ibm.team.enterprise.metadata.ui.query.util.IValueConverter;
import com.ibm.team.jface.util.ConvertingSelectionProvider;
import java.util.ArrayList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class ConvertingValueSelectionProvider
implements ISelectionProvider {
    private IValueConverter valueConverter;
    private ISelection lastSelection = StructuredSelection.EMPTY;
    private final ConvertingSelectionProvider convertingSelectionProvider;

    public ConvertingValueSelectionProvider(ISelectionProvider provider) {
        this.convertingSelectionProvider = new ConvertingSelectionProvider(provider){

            protected ISelection convertFrom(ISelection viewerSelection) {
                if (viewerSelection instanceof IStructuredSelection) {
                    IStructuredSelection structuredSelection = (IStructuredSelection)viewerSelection;
                    ArrayList converted = new ArrayList();
                    for (Object object : structuredSelection) {
                        if (object == Constants.NULL) {
                            converted.add(null);
                            continue;
                        }
                        Object value = object;
                        if (ConvertingValueSelectionProvider.this.valueConverter != null) {
                            value = ConvertingValueSelectionProvider.this.valueConverter.convertFrom(object);
                        }
                        if (value == null || "".equals(value)) continue;
                        converted.add(value);
                    }
                    return new StructuredSelection(converted);
                }
                return viewerSelection;
            }

            public ISelection convertTo(ISelection selection) {
                if (selection instanceof IStructuredSelection) {
                    IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                    ArrayList<Object> converted = new ArrayList<Object>();
                    for (Object object : structuredSelection) {
                        if (object == null) {
                            converted.add((Object)Constants.NULL);
                            continue;
                        }
                        if (ConvertingValueSelectionProvider.this.valueConverter != null) {
                            converted.add(ConvertingValueSelectionProvider.this.valueConverter.convertTo(object));
                            continue;
                        }
                        converted.add(object);
                    }
                    return new StructuredSelection(converted);
                }
                return selection;
            }
        };
    }

    public ISelection getLastSelection(boolean convert) {
        if (convert) {
            return this.convertingSelectionProvider.convertTo(this.lastSelection);
        }
        return this.lastSelection;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.convertingSelectionProvider.addSelectionChangedListener(listener);
    }

    public ISelection getSelection() {
        return this.convertingSelectionProvider.getSelection();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.convertingSelectionProvider.removeSelectionChangedListener(listener);
    }

    public void setSelection(ISelection selection) {
        this.lastSelection = selection;
        this.convertingSelectionProvider.setSelection(selection);
    }

    public void setValueConverter(IValueConverter converter) {
        this.valueConverter = converter;
    }

    static enum Constants {
        NULL;

    }
}

