/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.part;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class WrapLayout
extends Layout {
    public int horizontalSpacing = 0;
    public int verticalSpacing = 0;

    public void setSpacing(int horizontal, int vertical) {
        this.horizontalSpacing = horizontal;
        this.verticalSpacing = vertical;
    }

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        Control[] children = composite.getChildren();
        int x = 0;
        int y = 0;
        int rightEdge = wHint != -1 ? wHint : composite.getClientArea().width;
        int maxRowHeight = 0;
        int width = 0;
        int height = 0;
        Control[] controlArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            Point size = control.computeSize(-1, -1, flushCache);
            if (size.y > maxRowHeight) {
                maxRowHeight = size.y;
            }
            if (x + size.x > rightEdge) {
                x = 0;
                y += maxRowHeight + this.verticalSpacing;
                maxRowHeight = size.y;
            }
            width = Math.max(width, x + size.x);
            height = Math.max(height, y + maxRowHeight);
            x += size.x + this.horizontalSpacing;
            ++n2;
        }
        Point size = new Point(width, height);
        return size;
    }

    protected void layout(Composite composite, boolean flushCache) {
        Control[] children = composite.getChildren();
        Rectangle clientArea = composite.getClientArea();
        int x = clientArea.x;
        int y = clientArea.y;
        int rightEdge = clientArea.x + clientArea.width;
        int maxRowHeight = 0;
        int columns = 0;
        int i = 0;
        while (i < children.length) {
            Control control = children[i];
            Point size = control.computeSize(-1, -1, flushCache);
            if (size.y > maxRowHeight) {
                maxRowHeight = size.y;
                int j = 0;
                while (j < columns) {
                    Control prior = children[i - j - 1];
                    Rectangle bounds = prior.getBounds();
                    bounds.height = maxRowHeight;
                    prior.setBounds(bounds);
                    ++j;
                }
            }
            if (x + size.x > rightEdge) {
                x = clientArea.x;
                y += maxRowHeight + this.verticalSpacing;
                maxRowHeight = size.y;
                columns = 0;
            }
            ++columns;
            control.setBounds(x, y, size.x, maxRowHeight);
            x += size.x + this.horizontalSpacing;
            ++i;
        }
    }

    protected boolean flushCache(Control control) {
        return true;
    }
}

