/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.part;

import com.ibm.team.enterprise.metadata.ui.query.action.RunAction;
import com.ibm.team.enterprise.metadata.ui.query.editor.QueryEditorInput;
import com.ibm.team.enterprise.metadata.ui.query.part.Messages;
import com.ibm.team.jface.JazzResources;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.editor.SharedHeaderFormEditor;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Form;

public class TitlePart {
    private QueryEditorInput input;
    private SharedHeaderFormEditor editor;
    private Form titleForm;
    private IHyperlinkListener hyperlinkListener;
    private ResourceManager resourceManager;

    public void init(SharedHeaderFormEditor editor) {
        this.editor = editor;
        this.titleForm = editor.getHeaderForm().getForm().getForm();
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)this.titleForm);
        this.updateTitle();
        this.createContextMenu(this.titleForm);
        this.createActionArea(this.titleForm);
    }

    private void createContextMenu(Form form) {
        IMenuManager menuMgr = form.getMenuManager();
        menuMgr.add((IContributionItem)new Separator("additions"));
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IContributionItem)new Separator("additions"));
            }
        });
        if (menuMgr instanceof MenuManager) {
            this.editor.getSite().registerContextMenu(this.editor.getSite().getId(), (MenuManager)menuMgr, (ISelectionProvider)new TitleSelectionProvider());
        }
    }

    private void createActionArea(Form titleForm) {
        IToolBarManager toolBarManager = titleForm.getToolBarManager();
        ControlContribution run = new ControlContribution("run"){

            protected Control createControl(Composite parent) {
                Button button = TitlePart.this.editor.getToolkit().createButton(parent, Messages.TitlePart_RUN, 8);
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        RunAction runAction = new RunAction();
                        runAction.setActivePart(TitlePart.this.getEditor().getSite().getPart());
                        runAction.selectionChanged((ISelection)new StructuredSelection((Object)TitlePart.this.input.getMetadataQuery()));
                        runAction.selectionChanged((ISelection)new StructuredSelection((Object)TitlePart.this.input.getTeamRepository()));
                        runAction.selectionChanged((ISelection)new StructuredSelection((Object)TitlePart.this.input.getProjectArea()));
                        runAction.run();
                    }
                });
                return button;
            }
        };
        toolBarManager.add((IContributionItem)run);
        ControlContribution save = new ControlContribution("save"){

            protected Control createControl(Composite parent) {
                final Button button = TitlePart.this.editor.getToolkit().createButton(parent, Messages.TitlePart_SAVE, 8);
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        TitlePart.this.editor.getSite().getPage().saveEditor((IEditorPart)TitlePart.this.editor, false);
                    }
                });
                TitlePart.this.editor.addPropertyListener(new IPropertyListener(){

                    public void propertyChanged(Object source, int propId) {
                        if (source instanceof IEditorPart && propId == 257) {
                            button.setEnabled(TitlePart.this.editor.isDirty() && TitlePart.this.checkSaveButtonEnablement());
                        }
                    }
                });
                button.setEnabled(TitlePart.this.editor.isDirty());
                return button;
            }
        };
        toolBarManager.add((IContributionItem)save);
        ControlContribution saveCopy = new ControlContribution("saveCopy"){

            protected Control createControl(Composite parent) {
                final Button button = TitlePart.this.editor.getToolkit().createButton(parent, Messages.TitlePart_SAVE_COPY, 8);
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        TitlePart.this.editor.doSaveAs();
                    }
                });
                TitlePart.this.editor.addPropertyListener(new IPropertyListener(){

                    public void propertyChanged(Object source, int propId) {
                        if (source instanceof IEditorPart && propId == 257) {
                            button.setEnabled(TitlePart.this.editor.isSaveAsAllowed());
                        }
                    }
                });
                button.setEnabled(TitlePart.this.editor.isSaveAsAllowed());
                return button;
            }
        };
        toolBarManager.add((IContributionItem)saveCopy);
        titleForm.updateToolBar();
    }

    protected void updateTitle() {
        this.setImage(this.getImage());
        this.setTitle(this.getName());
    }

    protected void setImage(ImageDescriptor imageDescriptor) {
        if (imageDescriptor != null) {
            Image image = JazzResources.getImageWithDefault((ResourceManager)this.getResourceManager(), (ImageDescriptor)imageDescriptor);
            this.setBusy(false, image);
        }
    }

    protected void setTitle(String text) {
        if (text == null || !text.equals(this.titleForm.getText())) {
            this.titleForm.setText(text);
        }
    }

    private void setBusy(boolean isBusy, Image image) {
        this.titleForm.setBusy(isBusy);
        this.titleForm.setImage(image);
    }

    private ResourceManager getResourceManager() {
        if (this.resourceManager == null) {
            this.resourceManager = new LocalResourceManager(JFaceResources.getResources());
        }
        return this.resourceManager;
    }

    public void setInput(Object input) {
        this.input = input instanceof QueryEditorInput ? (QueryEditorInput)input : null;
        this.updateTitle();
    }

    public void setStatus(String title, IStatus status) {
        IMessageManager messageManager = this.editor.getHeaderForm().getMessageManager();
        messageManager.removeAllMessages();
        if (this.hyperlinkListener != null) {
            this.titleForm.removeMessageHyperlinkListener(this.hyperlinkListener);
            this.hyperlinkListener = null;
        }
        if (status != null) {
            this.showStatus(messageManager, title, status);
        }
    }

    public void clearStatus() {
        this.setStatus("", null);
    }

    private void showStatus(IMessageManager messageManager, String title, IStatus status) {
        if (status.isOK()) {
            return;
        }
        this.hyperlinkListener = new ShowStatusListener(this.editor.getSite().getShell(), title, status);
        this.titleForm.addMessageHyperlinkListener(this.hyperlinkListener);
        messageManager.addMessage((Object)status, title, null, this.getMessageType(status));
    }

    private int getMessageType(IStatus status) {
        int type;
        switch (status.getSeverity()) {
            case 4: 
            case 8: {
                type = 3;
                break;
            }
            case 2: {
                type = 2;
                break;
            }
            case 1: {
                type = 1;
                break;
            }
            default: {
                type = 0;
            }
        }
        return type;
    }

    public void dispose() {
        if (this.hyperlinkListener != null) {
            this.hyperlinkListener = null;
        }
    }

    protected SharedHeaderFormEditor getEditor() {
        return this.editor;
    }

    protected String getName() {
        return Messages.TitlePart_NAME_LABEL;
    }

    protected ImageDescriptor getImage() {
        return this.input != null ? this.input.getImageDescriptor() : null;
    }

    protected boolean checkSaveButtonEnablement() {
        return true;
    }

    private static class ShowStatusListener
    extends HyperlinkAdapter {
        private Shell parentShell;
        private String title;
        private String message;
        private IStatus status;

        public ShowStatusListener(Shell parentShell, String title, IStatus status) {
            this.parentShell = parentShell;
            this.title = title;
            this.message = status.getMessage();
            String details = status.getException() != null && status.getException().getMessage() != null && status.getException().getMessage().length() > 0 ? status.getException().getMessage() : Messages.INTERNAL_ERROR;
            this.status = new Status(status.getSeverity(), status.getPlugin(), status.getCode(), details, status.getException());
        }

        public void linkActivated(HyperlinkEvent e) {
            this.openDialog();
        }

        public void openDialog() {
            ErrorDialog.openError((Shell)this.parentShell, (String)this.title, (String)this.message, (IStatus)this.status);
        }
    }

    private class TitleSelectionProvider
    implements ISelectionProvider {
        private TitleSelectionProvider() {
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public ISelection getSelection() {
            Object selection = null;
            return selection != null ? new StructuredSelection(selection) : StructuredSelection.EMPTY;
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public void setSelection(ISelection selection) {
        }
    }
}

