/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.part;

import com.ibm.team.enterprise.metadata.query.common.AttributeExpression;
import com.ibm.team.enterprise.metadata.query.common.Expression;
import com.ibm.team.enterprise.metadata.query.common.Term;
import com.ibm.team.enterprise.metadata.ui.query.action.AddConditionsAction;
import com.ibm.team.enterprise.metadata.ui.query.action.ChangeTermOperatorAction;
import com.ibm.team.enterprise.metadata.ui.query.action.RemoveChildrenAction;
import com.ibm.team.enterprise.metadata.ui.query.editor.QueryEditorInput;
import com.ibm.team.enterprise.metadata.ui.query.editor.QueryEditorToolkit;
import com.ibm.team.enterprise.metadata.ui.query.event.WorkingCopyChangeEvent;
import com.ibm.team.enterprise.metadata.ui.query.part.AbstractConditionPart;
import com.ibm.team.enterprise.metadata.ui.query.part.ConditionPart;
import com.ibm.team.enterprise.metadata.ui.query.part.CustomSection;
import com.ibm.team.enterprise.metadata.ui.query.part.QueryEditorFormPart;
import com.ibm.team.enterprise.metadata.ui.query.part.WrapLayout;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.SharedScrolledComposite;

public class TermPart
extends QueryEditorFormPart {
    private static boolean WORK_AROUND_32664 = "gtk".equals(SWT.getPlatform());
    private final Term term;
    private CustomSection customSection;
    private Composite conditionComposite;
    private Action addConditionsAction;
    private Action removeAction;
    private final List<PartAssociation> fPartAssociations = new ArrayList<PartAssociation>();

    public TermPart(Term term) {
        this.term = term;
    }

    @Override
    protected void update(WorkingCopyChangeEvent event) {
        if (!event.isExpressionChangeEventType()) {
            return;
        }
        switch (event.getMetadataQueryChangeEventSubType()) {
            case TERM_OPERATOR_CHANGED: {
                this.updateOperator();
                break;
            }
            case TERM_CONDITION_ADDED: {
                this.addCondition(event.getExpression());
                break;
            }
            case TERM_CONDITION_REMOVED: {
                this.removeCondition(event.getExpression());
                break;
            }
            case TERM_CLEARED: {
                this.removeAllConditions();
                break;
            }
        }
        this.updateButtonEnablement();
    }

    private void updateOperator() {
        Term.Operator operator = this.term.getOperator();
        this.setOperatorLabel(operator.getLabel(), operator.getDescription());
    }

    private void setOperatorLabel(String label, String description) {
        this.getCustomSection().setTitle(label);
        this.getCustomSection().setMenuLabel(description);
    }

    public void createContent(Composite parent) {
        QueryEditorToolkit toolkit = (QueryEditorToolkit)this.getSite().getToolkit();
        GridLayoutFactory.fillDefaults().applyTo(parent);
        this.customSection = toolkit.createCustomSection(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.customSection);
        GridLayoutFactory.fillDefaults().applyTo(this.customSection.getClientComposite());
        this.conditionComposite = toolkit.createComposite(this.customSection.getClientComposite());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.conditionComposite);
        WrapLayout wrapLayout = new WrapLayout();
        wrapLayout.setSpacing(10, 10);
        this.conditionComposite.setLayout((Layout)wrapLayout);
        this.installOperatorMenu();
        this.installToolbar();
        this.updateOperator();
        this.createConditionSections();
        this.updateButtonEnablement();
    }

    private void installOperatorMenu() {
        IMenuManager operatorMenu = this.customSection.getMenuManager();
        operatorMenu.add((IAction)new ChangeTermOperatorAction(this.term, Term.Operator.GROUP));
        operatorMenu.add((IAction)new ChangeTermOperatorAction(this.term, Term.Operator.ALTERNATIVE));
        operatorMenu.update(true);
    }

    private void installToolbar() {
        this.removeAction = new RemoveChildrenAction(this.term);
        IToolBarManager toolbar = this.customSection.getToolBarManager();
        toolbar.add((IAction)this.removeAction);
        this.installAddConditionAction();
        toolbar.update(true);
    }

    private void installAddConditionAction() {
        QueryEditorInput input = this.getInput();
        if (input != null && this.customSection != null && this.addConditionsAction == null) {
            this.addConditionsAction = new AddConditionsAction(this.customSection.getShell(), this.term);
            this.customSection.getToolBarManager().add((IAction)this.addConditionsAction);
        }
    }

    private void createConditionSections() {
        for (Expression expression : this.term.getExpressions()) {
            this.addCondition(expression);
        }
    }

    private void addCondition(Expression condition) {
        if (condition instanceof AttributeExpression) {
            this.addSingleCondition((AttributeExpression)condition);
        }
    }

    private void addSingleCondition(AttributeExpression expression) {
        ConditionPart part = new ConditionPart(expression);
        this.showPart(part);
    }

    private void showPart(AbstractConditionPart part) {
        part.init(this.getSite());
        part.setInput(this.getInput());
        part.createContent(this.conditionComposite);
        QueryEditorFormPart predecessor = this.findPredecessor(part.getExpression());
        CustomSection predecessorControl = this.getControl(predecessor);
        if (predecessorControl != null) {
            part.getCustomSection().moveBelow((Control)predecessorControl);
        }
        this.associatePart(part.getExpression(), part);
        this.refreshLayout();
        if (!WORK_AROUND_32664) {
            part.setFocus();
        }
    }

    private void associatePart(Expression expression, QueryEditorFormPart part) {
        this.fPartAssociations.add(new PartAssociation(expression, part));
    }

    private QueryEditorFormPart getAssociatedPart(Expression expression) {
        for (PartAssociation partAssociation : this.fPartAssociations) {
            if (partAssociation.expression != expression) continue;
            return partAssociation.part;
        }
        return null;
    }

    private QueryEditorFormPart disassociatePart(Expression expression) {
        for (PartAssociation partAssociation : this.fPartAssociations) {
            if (partAssociation.expression != expression) continue;
            this.fPartAssociations.remove(partAssociation);
            return partAssociation.part;
        }
        return null;
    }

    private QueryEditorFormPart findPredecessor(Expression expression) {
        return this.getAssociatedPart(expression);
    }

    private void removeCondition(Expression condition) {
        QueryEditorFormPart part = this.disassociatePart(condition);
        if (part != null) {
            part.dispose();
            this.refreshLayout();
        }
    }

    private void removeAllConditions() {
        for (PartAssociation partAssociation : this.fPartAssociations) {
            partAssociation.part.dispose();
        }
        this.fPartAssociations.clear();
        this.refreshLayout();
    }

    private void refreshLayout() {
        SharedScrolledComposite form = this.getScrolledComposite();
        if (form != null) {
            form.reflow(true);
            form.layout(true, true);
        } else {
            this.customSection.layout(true, true);
        }
    }

    private SharedScrolledComposite getScrolledComposite() {
        Composite parent = this.customSection.getParent();
        while (parent != null) {
            if (parent instanceof SharedScrolledComposite) {
                return (SharedScrolledComposite)parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    private void updateButtonEnablement() {
        this.removeAction.setEnabled(!this.term.getExpressions().isEmpty());
    }

    CustomSection getCustomSection() {
        return this.customSection;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.fPartAssociations.clear();
        this.customSection.dispose();
    }

    private CustomSection getControl(QueryEditorFormPart part) {
        if (part instanceof ConditionPart) {
            return ((ConditionPart)part).getCustomSection();
        }
        if (part instanceof TermPart) {
            return ((TermPart)part).getCustomSection();
        }
        return null;
    }

    private static class PartAssociation {
        final Expression expression;
        final QueryEditorFormPart part;

        public PartAssociation(Expression e, QueryEditorFormPart p) {
            this.expression = e;
            this.part = p;
        }
    }
}

