/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.part;

import com.ibm.team.enterprise.metadata.query.common.Expression;
import com.ibm.team.enterprise.metadata.query.common.IMetadataQuery;
import com.ibm.team.enterprise.metadata.query.common.MetadataQueryChangeEvent;
import com.ibm.team.enterprise.metadata.query.common.Statement;
import com.ibm.team.enterprise.metadata.ui.query.editor.QueryEditorInput;
import com.ibm.team.enterprise.metadata.ui.query.editor.QueryEditorToolkit;
import com.ibm.team.enterprise.metadata.ui.query.event.WorkingCopyChangeEvent;
import com.ibm.team.enterprise.metadata.ui.query.part.QueryEditorFormPart;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.FormText;

public class SourcePart
extends QueryEditorFormPart {
    public static final String PART_ID = "com.ibm.team.enterprise.metadata.ui.query.part.source";
    private FormText sourceText;

    @Override
    protected void update(WorkingCopyChangeEvent event) {
        if (event.isExpressionChangeEventType()) {
            this.updateContent(event.getExpression());
        } else if (event.getMetadataQueryChangeEventType() == MetadataQueryChangeEvent.Type.STREAM_SCOPE_CHANGED && event.getStatement() != null) {
            this.updateContent(event.getStatement());
        }
    }

    public void createContent(Composite parent) {
        QueryEditorToolkit toolkit = (QueryEditorToolkit)this.getSite().getToolkit();
        GridLayoutFactory.fillDefaults().applyTo(parent);
        this.sourceText = toolkit.createFormText(parent, true);
        this.sourceText.setWhitespaceNormalized(false);
        this.sourceText.setBackground(null);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.sourceText);
    }

    public boolean stretchHorizontally() {
        return true;
    }

    public boolean stretchVertically() {
        return true;
    }

    private void updateText(String text) {
        this.sourceText.setText(text, false, true);
    }

    private void updateContent(Expression expression) {
        if (expression != null) {
            this.updateText(expression.getParent().getParent().getSPARQLString());
        }
    }

    private void updateContent(Statement statement) {
        if (statement != null) {
            this.updateText(statement.getSPARQLString());
        }
    }

    @Override
    public void setInput(Object input) {
        super.setInput(input);
        if (input instanceof QueryEditorInput && !((QueryEditorInput)input).isNew()) {
            IMetadataQuery query = ((QueryEditorInput)input).getMetadataQuery();
            this.updateText(query.getStatement().getSPARQLString());
        }
    }
}

