/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.part;

import com.ibm.team.enterprise.metadata.common.query.util.AttributeProviderFactory;
import com.ibm.team.enterprise.metadata.query.common.AttributeColumn;
import com.ibm.team.enterprise.metadata.query.common.AttributeSortColumn;
import com.ibm.team.enterprise.metadata.query.common.IAttribute;
import com.ibm.team.enterprise.metadata.query.common.MetadataQueryChangeEvent;
import com.ibm.team.enterprise.metadata.query.common.Statement;
import com.ibm.team.enterprise.metadata.ui.query.editor.QueryEditor;
import com.ibm.team.enterprise.metadata.ui.query.editor.QueryEditorToolkit;
import com.ibm.team.enterprise.metadata.ui.query.event.WorkingCopyChangeEvent;
import com.ibm.team.enterprise.metadata.ui.query.part.AttributeColumnContentProvider;
import com.ibm.team.enterprise.metadata.ui.query.part.AttributeColumnLabelProvider;
import com.ibm.team.enterprise.metadata.ui.query.part.Messages;
import com.ibm.team.enterprise.metadata.ui.query.part.QueryEditorFormPart;
import com.ibm.team.enterprise.metadata.ui.query.part.SlushBucket;
import com.ibm.team.enterprise.metadata.ui.query.util.AccessibleUtil;
import com.ibm.team.enterprise.metadata.ui.query.util.DefaultViewerComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorPart;

public class SortingPart
extends QueryEditorFormPart {
    public static final String PART_ID = "com.ibm.team.enterprise.metadata.ui.query.part.sorting";
    private static final String[] SORT_DIRECTION_LITERALS = new String[]{Messages.SortingPart_DIRECTION_ASC, Messages.SortingPart_DIRECTION_DESC};
    private final SelectionAdapter buttonDispatcher = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            if (SortingPart.this.slushBucket.getAddButton() == e.widget) {
                SortingPart.this.handleAdd();
            } else if (SortingPart.this.slushBucket.getAddAllButton() == e.widget) {
                SortingPart.this.handleAddAll();
            } else if (SortingPart.this.slushBucket.getRemoveButton() == e.widget) {
                SortingPart.this.handleRemove();
            } else if (SortingPart.this.slushBucket.getRemoveAllButton() == e.widget) {
                SortingPart.this.handleRemoveAll();
            } else if (SortingPart.this.slushBucket.getUpButton() == e.widget) {
                SortingPart.this.handleMoveUp();
            } else if (SortingPart.this.slushBucket.getDownButton() == e.widget) {
                SortingPart.this.handleMoveDown();
            } else if (SortingPart.this.slushBucket.getDefaultsButton() == e.widget) {
                SortingPart.this.handleSetDefaults();
            }
        }
    };
    private final IDoubleClickListener doubleClickDispatcher = new IDoubleClickListener(){

        public void doubleClick(DoubleClickEvent event) {
            if (SortingPart.this.availableColumnViewer == event.getViewer()) {
                SortingPart.this.handleAdd();
            } else if (SortingPart.this.selectedColumnViewer == event.getViewer()) {
                SortingPart.this.handleRemove();
            }
        }
    };
    private TableViewer availableColumnViewer;
    private TableViewer selectedColumnViewer;
    private SlushBucket slushBucket;
    private Statement statement;
    private List<AttributeSortColumn> availableSortColumns;

    @Override
    protected void update(WorkingCopyChangeEvent event) {
        if (event.getMetadataQueryChangeEventType() == MetadataQueryChangeEvent.Type.SELECT_SORT_COLUMN_CHANGED) {
            MetadataQueryChangeEvent.SubType subType = event.getMetadataQueryChangeEventSubType();
            switch (subType) {
                case SORT_COLUMN_ADDED: {
                    this.addSortColumns(event.getMetadataQueryChangeEvent().getSortColumns());
                    break;
                }
                case SORT_COLUMN_REMOVED: {
                    this.removeSortColumns(event.getMetadataQueryChangeEvent().getSortColumns());
                    break;
                }
                case SORT_COLUMN_REORDERED: {
                    this.updateSortColumns();
                    break;
                }
                case SORT_COLUMN_CHANGED: {
                    this.updateAll();
                    break;
                }
            }
        }
    }

    @Override
    public void setInput(Object input) {
        super.setInput(input);
        this.statement = this.getInput().getStatement();
        this.availableSortColumns = AttributeProviderFactory.getInstance().getAvailableAttributeSortColumns();
        IEditorPart editor = this.getSite().getWorkbenchPage().getActiveEditor();
        if (editor instanceof QueryEditor) {
            this.availableSortColumns.addAll(AttributeProviderFactory.getInstance().createAttributeSortColumn2(((QueryEditor)editor).getCustomAttributes()));
        }
        this.availableColumnViewer.setInput(this.availableSortColumns);
        this.selectedColumnViewer.setInput((Object)this.statement);
        this.updateAll();
    }

    public void refreshAvailableColumns(List<IAttribute> customAttributes) {
        this.availableSortColumns = AttributeProviderFactory.getInstance().getAvailableAttributeSortColumns();
        this.availableSortColumns.addAll(AttributeProviderFactory.getInstance().createAttributeSortColumn2(customAttributes));
        this.availableColumnViewer.setInput(this.availableSortColumns);
        ArrayList<AttributeSortColumn> deletedColumns = new ArrayList<AttributeSortColumn>();
        int numItems = this.selectedColumnViewer.getTable().getItemCount();
        int i = 0;
        while (i < numItems) {
            AttributeSortColumn attributeColumn = (AttributeSortColumn)this.selectedColumnViewer.getElementAt(i);
            if (!this.isInAvailableColumn(attributeColumn)) {
                deletedColumns.add(attributeColumn);
            }
            ++i;
        }
        this.selectedColumnViewer.remove((Object[])deletedColumns.toArray(new AttributeSortColumn[deletedColumns.size()]));
        numItems = this.selectedColumnViewer.getTable().getItemCount();
        ArrayList<AttributeSortColumn> selectedAttributeColumns = new ArrayList<AttributeSortColumn>();
        int i2 = 0;
        while (i2 < numItems) {
            selectedAttributeColumns.add((AttributeSortColumn)this.selectedColumnViewer.getElementAt(i2));
            ++i2;
        }
        this.addSortColumns(selectedAttributeColumns);
    }

    private boolean isInAvailableColumn(AttributeSortColumn attributeColumn) {
        for (AttributeSortColumn availableColumn : this.availableSortColumns) {
            if (!attributeColumn.getAttribute().getDisplayName().equals(availableColumn.getAttribute().getDisplayName())) continue;
            return true;
        }
        return false;
    }

    public void createContent(Composite parent) {
        QueryEditorToolkit toolkit = (QueryEditorToolkit)this.getSite().getToolkit();
        this.slushBucket = toolkit.createSlushBucket(parent, Messages.SortingPart_AVAILABLE_COLUMNS, Messages.SortingPart_SELECTED_COLUMNS);
        this.availableColumnViewer = new TableViewer(this.slushBucket.getAvailableTable());
        this.availableColumnViewer.setContentProvider((IContentProvider)new AttributeColumnContentProvider());
        this.availableColumnViewer.setLabelProvider((IBaseLabelProvider)new AttributeColumnLabelProvider());
        this.availableColumnViewer.setComparator((ViewerComparator)new DefaultViewerComparator(AttributeColumn.createComparator()));
        this.availableColumnViewer.addFilter((ViewerFilter)new AvailableColumnsFilter());
        Table selectedTable = this.slushBucket.getSelectedTable();
        selectedTable.setHeaderVisible(true);
        selectedTable.setLinesVisible(true);
        TableLayout selectedTableLayout = new TableLayout();
        selectedTable.setLayout((Layout)selectedTableLayout);
        TableColumn attributeColumn = new TableColumn(selectedTable, 0);
        attributeColumn.setText(Messages.SortingPart_COLUMN);
        attributeColumn.setResizable(false);
        selectedTableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(60));
        TableColumn sortingColumn = new TableColumn(selectedTable, 0);
        sortingColumn.setText(Messages.SortingPart_DIRECTION);
        sortingColumn.setResizable(false);
        selectedTableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(40));
        this.selectedColumnViewer = new TableViewer(this.slushBucket.getSelectedTable());
        this.selectedColumnViewer.setContentProvider((IContentProvider)new SelectedSortColumnContentProvider());
        TableViewerColumn attributeViewerColumn = new TableViewerColumn(this.selectedColumnViewer, attributeColumn);
        attributeViewerColumn.setLabelProvider(AttributeColumnLabelProvider.createCellLabelProvider());
        TableViewerColumn sortingViewerColumn = new TableViewerColumn(this.selectedColumnViewer, sortingColumn);
        sortingViewerColumn.setEditingSupport((EditingSupport)new SortCriteriaEditingSupport(this.selectedColumnViewer));
        sortingViewerColumn.setLabelProvider((CellLabelProvider)new SortColumnDirectionLabelProvider());
        this.slushBucket.addSelectionListener((SelectionListener)this.buttonDispatcher);
        this.availableColumnViewer.addDoubleClickListener(this.doubleClickDispatcher);
        this.selectedColumnViewer.addDoubleClickListener(this.doubleClickDispatcher);
        AccessibleUtil.setAccessibleName((Control)this.slushBucket.getAvailableTable(), Messages.SortingPart_AVAILABLE_COLUMNS);
        AccessibleUtil.setAccessibleName((Control)this.slushBucket.getSelectedTable(), Messages.SortingPart_SELECTED_COLUMNS);
    }

    private void handleAdd() {
        List<AttributeSortColumn> addedColumns = this.getSortColumnsFromSelection(this.availableColumnViewer.getSelection());
        this.statement.getSelectClause().addSortColumns(addedColumns);
    }

    private void handleAddAll() {
        ArrayList<AttributeSortColumn> sortColumns = new ArrayList<AttributeSortColumn>(this.availableSortColumns.size());
        for (AttributeSortColumn available : this.availableSortColumns) {
            sortColumns.add(new AttributeSortColumn((AttributeColumn)available));
        }
        this.statement.getSelectClause().addSortColumns(sortColumns);
    }

    private void handleRemove() {
        List<AttributeSortColumn> sortColumns = this.getSortColumnsFromSelection(this.selectedColumnViewer.getSelection());
        this.statement.getSelectClause().removeSortColumns(sortColumns);
    }

    private void handleRemoveAll() {
        this.statement.getSelectClause().removeAllSortColumns();
    }

    private void handleMoveUp() {
        List<AttributeSortColumn> movedSortColumns = this.getSortColumnsFromSelection(this.selectedColumnViewer.getSelection());
        this.statement.getSelectClause().moveSortColumns(movedSortColumns, -1);
    }

    private void handleMoveDown() {
        List<AttributeSortColumn> movedSortColumns = this.getSortColumnsFromSelection(this.selectedColumnViewer.getSelection());
        this.statement.getSelectClause().moveSortColumns(movedSortColumns, 1);
    }

    private void addSortColumns(List<AttributeSortColumn> sortColumns) {
        this.selectedColumnViewer.refresh();
        this.selectedColumnViewer.setSelection((ISelection)new StructuredSelection(sortColumns));
        if (sortColumns.size() > 0) {
            this.selectedColumnViewer.editElement((Object)sortColumns.get(0), 1);
        }
        this.availableColumnViewer.remove(sortColumns.toArray());
        this.slushBucket.updateButtonEnablement();
    }

    private void removeSortColumns(List<AttributeSortColumn> sortColumns) {
        this.selectedColumnViewer.refresh();
        this.availableColumnViewer.add(sortColumns.toArray());
        this.availableColumnViewer.setSelection((ISelection)new StructuredSelection(sortColumns));
        this.slushBucket.updateButtonEnablement();
    }

    private void updateAll() {
        this.selectedColumnViewer.refresh();
        this.availableColumnViewer.refresh();
        TableItem[] items = this.selectedColumnViewer.getTable().getItems();
        ArrayList<AttributeSortColumn> columns = new ArrayList<AttributeSortColumn>(items.length);
        TableItem[] tableItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            columns.add((AttributeSortColumn)item.getData());
            ++n2;
        }
        this.availableColumnViewer.remove(columns.toArray());
        this.slushBucket.updateButtonEnablement();
    }

    private void updateSortColumns() {
        this.selectedColumnViewer.refresh();
        this.slushBucket.updateButtonEnablement();
    }

    private void handleSetDefaults() {
        this.statement.getSelectClause().setSortColumns(AttributeProviderFactory.getInstance().getDefaultAttributeSortColumns());
    }

    private List<AttributeSortColumn> getSortColumnsFromSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            ArrayList<AttributeSortColumn> columns = new ArrayList<AttributeSortColumn>(structuredSelection.size());
            for (Object element : structuredSelection) {
                if (!(element instanceof AttributeSortColumn)) continue;
                columns.add((AttributeSortColumn)element);
            }
            return columns;
        }
        return Collections.emptyList();
    }

    public boolean stretchHorizontally() {
        return true;
    }

    public boolean stretchVertically() {
        return true;
    }

    private class AvailableColumnsFilter
    extends ViewerFilter {
        private AvailableColumnsFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return true;
        }
    }

    private static class SelectedSortColumnContentProvider
    implements IStructuredContentProvider {
        private SelectedSortColumnContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Statement) {
                Statement statement = (Statement)inputElement;
                return statement.getSelectClause().getSortColumns().toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static class SortColumnDirectionLabelProvider
    extends CellLabelProvider {
        private SortColumnDirectionLabelProvider() {
        }

        public void update(ViewerCell cell) {
            AttributeSortColumn column = (AttributeSortColumn)cell.getElement();
            AttributeSortColumn.Direction direction = column.getDirection();
            cell.setText(direction == AttributeSortColumn.Direction.ASCENDING ? SORT_DIRECTION_LITERALS[0] : SORT_DIRECTION_LITERALS[1]);
        }
    }

    private static class SortCriteriaEditingSupport
    extends EditingSupport {
        private final TableViewer tableViewer;
        private CellEditor cellEditor;

        public SortCriteriaEditingSupport(TableViewer viewer) {
            super((ColumnViewer)viewer);
            this.tableViewer = viewer;
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            if (this.cellEditor == null) {
                this.cellEditor = new ComboBoxCellEditor((Composite)this.tableViewer.getTable(), SORT_DIRECTION_LITERALS, 8);
            }
            return this.cellEditor;
        }

        protected Object getValue(Object element) {
            if (element instanceof AttributeSortColumn) {
                AttributeSortColumn column = (AttributeSortColumn)element;
                return column.getDirection() == AttributeSortColumn.Direction.ASCENDING ? 0 : 1;
            }
            return 0;
        }

        protected void setValue(Object element, Object value) {
            if (element instanceof AttributeSortColumn && value instanceof Integer) {
                AttributeSortColumn column = (AttributeSortColumn)element;
                Integer index = (Integer)value;
                column.setDirection(index == 0 ? AttributeSortColumn.Direction.ASCENDING : AttributeSortColumn.Direction.DESCENDING);
                this.tableViewer.refresh();
            }
        }
    }
}

