/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.part;

import com.ibm.team.enterprise.metadata.ui.query.editor.QueryEditorToolkit;
import com.ibm.team.enterprise.metadata.ui.query.part.Messages;
import com.ibm.team.enterprise.metadata.ui.query.util.AccessibleUtil;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class SlushBucket {
    private final Table availableTable;
    private final Table selectedTable;
    private final Button addButton;
    private final Button removeButton;
    private final Button addAllButton;
    private final Button removeAllButton;
    private final Button moveUpButton;
    private final Button moveDownButton;
    private final Button defaultsButton;

    public SlushBucket(Composite parent, QueryEditorToolkit toolkit, String availableText, String selectedText) {
        GridLayoutFactory.fillDefaults().margins(0, 5).numColumns(4).applyTo(parent);
        Label availableLabel = toolkit.createLabel(parent, availableText);
        Label selectedLabel = toolkit.createLabel(parent, selectedText);
        Composite availableBorder = toolkit.createBorder(parent);
        this.availableTable = toolkit.createTable(availableBorder, 65538);
        Composite buttonComposite = toolkit.createComposite(parent);
        this.defaultsButton = this.createButton(toolkit, buttonComposite, Messages.SlushBucket_SET_DEFAULTS, 0x1000000);
        this.addButton = this.createButton(toolkit, buttonComposite, ">", Messages.SlushBucket_MOVE_TO_RIGHT, 0x1000000);
        this.removeButton = this.createButton(toolkit, buttonComposite, "<", Messages.SlushBucket_MOVE_TO_LEFT, 0x1000000);
        this.addAllButton = this.createButton(toolkit, buttonComposite, ">>", Messages.SlushBucket_MOVE_ALL_TO_RIGHT, 0x1000000);
        this.removeAllButton = this.createButton(toolkit, buttonComposite, "<<", Messages.SlushBucket_MOVE_ALL_TO_LEFT, 0x1000000);
        Composite composite = toolkit.createComposite(parent);
        GridDataFactory.fillDefaults().grab(true, true).hint(1, -1).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().applyTo(composite);
        Composite selectedBorder = toolkit.createBorder(composite);
        this.selectedTable = toolkit.createTable(selectedBorder, 65538);
        Composite upDownComposite = toolkit.createComposite(parent);
        this.moveUpButton = this.createButton(toolkit, upDownComposite, Messages.SlushBucket_SLUSHBUCKET_MOVE_UP, 0x1000000);
        this.moveDownButton = this.createButton(toolkit, upDownComposite, Messages.SlushBucket_SLUSHBUCKET_MOVE_DOWN, 0x1000000);
        availableLabel.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        selectedLabel.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.addButton.setToolTipText(Messages.SlushBucket_SLUSHBUCKET_ADD);
        this.removeButton.setToolTipText(Messages.SlushBucket_SLUSHBUCKET_REMOVE);
        this.addAllButton.setToolTipText(Messages.SlushBucket_SLUSHBUCKET_ADD_ALL);
        this.removeAllButton.setToolTipText(Messages.SlushBucket_SLUSHBUCKET_REMOVE_ALL);
        this.moveUpButton.setToolTipText(Messages.SlushBucket_SLUSHBUCKET_MOVE_UP_TOOLTIP);
        this.moveDownButton.setToolTipText(Messages.SlushBucket_SLUSHBUCKET_MOVE_DOWN_TOOLTIP);
        FillLayout buttonLayout = new FillLayout(512);
        buttonLayout.spacing = 5;
        buttonLayout.marginWidth = 10;
        buttonComposite.setLayout((Layout)buttonLayout);
        FillLayout upDownLayout = new FillLayout(512);
        buttonLayout.spacing = 5;
        buttonLayout.marginWidth = 10;
        upDownComposite.setLayout((Layout)upDownLayout);
        GridDataFactory.swtDefaults().align(1, 128).applyTo((Control)upDownComposite);
        GridDataFactory.swtDefaults().span(2, 1).applyTo((Control)availableLabel);
        GridDataFactory.swtDefaults().span(2, 1).applyTo((Control)selectedLabel);
        int viewerHeight = this.availableTable.getItemHeight() * 10;
        GridDataFactory.fillDefaults().grab(true, true).hint(-1, viewerHeight).applyTo((Control)availableBorder);
        GridDataFactory.fillDefaults().grab(true, true).hint(-1, viewerHeight).applyTo((Control)selectedBorder);
        this.installListeners();
    }

    private Button createButton(QueryEditorToolkit toolkit, Composite parent, String text, int style) {
        return this.createButton(toolkit, parent, text, null, style);
    }

    private Button createButton(QueryEditorToolkit toolkit, Composite parent, String text, String accessibilityText, int style) {
        Button button = toolkit.createButton(parent, text, style);
        button.setBackground(parent.getBackground());
        if (accessibilityText != null) {
            AccessibleUtil.setAccessibleName((Control)button, accessibilityText);
        }
        return button;
    }

    public void updateButtonEnablement() {
        this.updateAvailableButtons();
        this.updateSelectionButtons();
    }

    public void addSelectionListener(SelectionListener listener) {
        this.getAddButton().addSelectionListener(listener);
        this.getAddAllButton().addSelectionListener(listener);
        this.getRemoveButton().addSelectionListener(listener);
        this.getRemoveAllButton().addSelectionListener(listener);
        this.getUpButton().addSelectionListener(listener);
        this.getDownButton().addSelectionListener(listener);
        this.getDefaultsButton().addSelectionListener(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.getAddButton().removeSelectionListener(listener);
        this.getAddAllButton().removeSelectionListener(listener);
        this.getRemoveButton().removeSelectionListener(listener);
        this.getRemoveAllButton().removeSelectionListener(listener);
        this.getUpButton().removeSelectionListener(listener);
        this.getDownButton().removeSelectionListener(listener);
        this.getDefaultsButton().removeSelectionListener(listener);
    }

    private void installListeners() {
        this.availableTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SlushBucket.this.updateAvailableButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                SlushBucket.this.updateAvailableButtons();
            }
        });
        this.selectedTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SlushBucket.this.updateSelectionButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                SlushBucket.this.updateSelectionButtons();
            }
        });
        this.selectedTable.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                SlushBucket.this.adaptColumns(e);
            }
        });
    }

    private void adaptColumns(ControlEvent e) {
        TableColumn tableColumn;
        Table table = (Table)e.widget;
        TableColumn[] columns = table.getColumns();
        int tableWidth = table.getClientArea().width;
        if (tableWidth == 0) {
            return;
        }
        int totalColumnWidth = 0;
        TableColumn[] tableColumnArray = columns;
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            tableColumn = tableColumnArray[n2];
            totalColumnWidth += tableColumn.getWidth();
            ++n2;
        }
        if (totalColumnWidth == 0) {
            return;
        }
        tableColumnArray = columns;
        n = columns.length;
        n2 = 0;
        while (n2 < n) {
            tableColumn = tableColumnArray[n2];
            int currentWidth = tableColumn.getWidth();
            tableColumn.setWidth(currentWidth * tableWidth / totalColumnWidth);
            ++n2;
        }
    }

    private void updateAvailableButtons() {
        this.addButton.setEnabled(this.availableTable.getSelectionCount() > 0);
        this.addAllButton.setEnabled(this.availableTable.getItemCount() > 0);
    }

    private void updateSelectionButtons() {
        int[] indices = this.selectedTable.getSelectionIndices();
        int itemCount = this.selectedTable.getItemCount();
        this.removeButton.setEnabled(indices.length > 0);
        this.removeAllButton.setEnabled(itemCount > 0);
        this.moveUpButton.setEnabled(this.getMinIndex(indices) > 0);
        this.moveDownButton.setEnabled(this.getMaxIndex(indices) < itemCount - 1);
    }

    private int getMaxIndex(int[] indices) {
        int maxIndex = indices.length > 0 ? -1 : Integer.MAX_VALUE;
        int[] nArray = indices;
        int n = indices.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            if (index > maxIndex) {
                maxIndex = index;
            }
            ++n2;
        }
        return maxIndex;
    }

    private int getMinIndex(int[] indices) {
        int minIndex = indices.length > 0 ? Integer.MAX_VALUE : -1;
        int[] nArray = indices;
        int n = indices.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            if (index < minIndex) {
                minIndex = index;
            }
            ++n2;
        }
        return minIndex;
    }

    public Table getAvailableTable() {
        return this.availableTable;
    }

    public Table getSelectedTable() {
        return this.selectedTable;
    }

    public Button getAddButton() {
        return this.addButton;
    }

    public Button getRemoveButton() {
        return this.removeButton;
    }

    public Button getAddAllButton() {
        return this.addAllButton;
    }

    public Button getRemoveAllButton() {
        return this.removeAllButton;
    }

    public Button getUpButton() {
        return this.moveUpButton;
    }

    public Button getDownButton() {
        return this.moveDownButton;
    }

    public Button getDefaultsButton() {
        return this.defaultsButton;
    }
}

