/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.part;

import com.ibm.team.enterprise.metadata.query.common.IMetadataQuery;
import com.ibm.team.enterprise.metadata.query.common.MetadataQueryChangeEvent;
import com.ibm.team.enterprise.metadata.query.common.Statement;
import com.ibm.team.enterprise.metadata.query.common.StreamScope;
import com.ibm.team.enterprise.metadata.ui.MetadataUIPlugin;
import com.ibm.team.enterprise.metadata.ui.query.dialog.StreamSelectionDialog;
import com.ibm.team.enterprise.metadata.ui.query.editor.QueryEditorInput;
import com.ibm.team.enterprise.metadata.ui.query.editor.QueryEditorToolkit;
import com.ibm.team.enterprise.metadata.ui.query.event.WorkingCopyChangeEvent;
import com.ibm.team.enterprise.metadata.ui.query.part.Messages;
import com.ibm.team.enterprise.metadata.ui.query.part.QueryEditorFormPart;
import com.ibm.team.enterprise.metadata.ui.query.util.AccessibleUtil;
import com.ibm.team.enterprise.metadata.ui.query.util.SCMUtil;
import com.ibm.team.enterprise.metadata.ui.query.util.Utils;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspace;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;

public class ScopePart
extends QueryEditorFormPart {
    public static final String PART_ID = "com.ibm.team.enterprise.metadata.ui.query.part.scope";
    private Button allStreamRadioButton;
    private Button singleStreamRadioButton;
    private Text streamText;
    private Button browseStreamButton;
    List<IWorkspace> fAvailableStreams = null;

    @Override
    protected void update(WorkingCopyChangeEvent event) {
        Statement statement;
        if (event.getMetadataQueryChangeEventType() == MetadataQueryChangeEvent.Type.STREAM_SCOPE_CHANGED && (statement = event.getStatement()) != null) {
            this.updateSelection(statement.getStreamScope());
        }
    }

    public void createContent(Composite parent) {
        QueryEditorToolkit toolkit = (QueryEditorToolkit)this.getSite().getToolkit();
        GridLayoutFactory.fillDefaults().applyTo(parent);
        Group scopeGroup = toolkit.createGroup(parent, Messages.ScopePart_SCOPY_GROUP_LABEL, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo((Composite)scopeGroup);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)scopeGroup);
        this.allStreamRadioButton = toolkit.createButton((Composite)scopeGroup, Messages.ScopePart_ALL_STREAM_RADIO_LABEL, 16);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)this.allStreamRadioButton);
        this.allStreamRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                boolean selected = ScopePart.this.allStreamRadioButton.getSelection();
                ScopePart.this.getInput().getStatement().getStreamScope().setAllStreams(selected);
                ScopePart.this.streamText.setEnabled(!selected);
            }
        });
        this.singleStreamRadioButton = toolkit.createButton((Composite)scopeGroup, Messages.ScopePart_STREAM_RADIO_LABEL, 16);
        GridDataFactory.fillDefaults().applyTo((Control)this.singleStreamRadioButton);
        this.singleStreamRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                boolean selected = ScopePart.this.singleStreamRadioButton.getSelection();
                ScopePart.this.getInput().getStatement().getStreamScope().setAllStreams(!selected);
                ScopePart.this.streamText.setEnabled(selected);
                ScopePart.this.browseStreamButton.setEnabled(selected);
            }
        });
        this.streamText = new Text((Composite)scopeGroup, 2056);
        GridDataFactory.fillDefaults().grab(true, false).minSize(300, -1).applyTo((Control)this.streamText);
        AccessibleUtil.setAccessibleName((Control)this.streamText, this.singleStreamRadioButton.getText());
        this.browseStreamButton = new Button((Composite)scopeGroup, 8);
        this.browseStreamButton.setText(Messages.ScopePart_BROWSE_BUTTON_LABEL);
        GridDataFactory.fillDefaults().applyTo((Control)this.browseStreamButton);
        this.browseStreamButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                List availableStreams = ScopePart.this.getAvailableStreams();
                StreamSelectionDialog dialog = new StreamSelectionDialog(ScopePart.this.streamText.getShell(), (IProcessAreaHandle)ScopePart.this.getInput().getProjectArea());
                dialog.setElements(availableStreams.toArray(new IWorkspace[availableStreams.size()]));
                if (dialog.open() == 0) {
                    IWorkspaceConnection selectedStream = dialog.getSelectedStreamConnection();
                    try {
                        ScopePart.this.setComponentsUUIDsToStreamScope(selectedStream, ScopePart.this.getInput().getStatement().getStreamScope());
                    }
                    catch (TeamRepositoryException e) {
                        MetadataUIPlugin.getDefault().logError("", (Exception)((Object)e));
                    }
                    ScopePart.this.streamText.setText(Utils.getStreamDisplayName(selectedStream));
                    ScopePart.this.getInput().getStatement().getStreamScope().setStreamUUID(selectedStream.getResolvedWorkspace().getItemId().getUuidValue());
                }
            }
        });
        this.allStreamRadioButton.setSelection(false);
        this.singleStreamRadioButton.setSelection(true);
        this.streamText.setEnabled(true);
        this.browseStreamButton.setEnabled(true);
    }

    private void setComponentsUUIDsToStreamScope(IWorkspaceConnection stream, StreamScope streamScope) throws TeamRepositoryException {
        if (stream != null && streamScope != null) {
            List components = stream.getComponents();
            List componentUUIDs = streamScope.getComponentUUIDs();
            componentUUIDs.clear();
            if (components != null && components.size() > 0) {
                for (Object component : components) {
                    if (!(component instanceof IComponentHandle)) continue;
                    componentUUIDs.add(((IComponentHandle)component).getItemId().getUuidValue());
                }
            }
        }
    }

    public boolean stretchHorizontally() {
        return false;
    }

    public boolean stretchVertically() {
        return false;
    }

    private void updateSelection(StreamScope scope) {
        boolean isAllStreams = scope.isAllStreams();
        if (isAllStreams) {
            this.allStreamRadioButton.setSelection(true);
            this.singleStreamRadioButton.setSelection(false);
            this.streamText.setEnabled(false);
            this.browseStreamButton.setEnabled(false);
        } else {
            this.allStreamRadioButton.setSelection(false);
            this.singleStreamRadioButton.setSelection(true);
            this.streamText.setEnabled(true);
            this.browseStreamButton.setEnabled(true);
        }
    }

    @Override
    public void setInput(Object input) {
        super.setInput(input);
        if (input instanceof QueryEditorInput) {
            IWorkspace stream;
            IMetadataQuery query = ((QueryEditorInput)input).getMetadataQuery();
            Statement statement = query.getStatement();
            this.updateSelection(statement.getStreamScope());
            if (!statement.getStreamScope().isAllStreams() && statement.getStreamScope().getStreamUUID() != null && (stream = this.getStream(statement.getStreamScope().getStreamUUID())) != null) {
                this.streamText.setText(Utils.getStreamDisplayName(stream));
                try {
                    IWorkspaceConnection connection = SCMUtil.getWorkspaceConnection(stream);
                    this.setComponentsUUIDsToStreamScope(connection, statement.getStreamScope());
                }
                catch (TeamRepositoryException e) {
                    MetadataUIPlugin.getDefault().logError("", (Exception)((Object)e));
                }
            }
        }
    }

    private IWorkspace getStream(String uuid) {
        List<IWorkspace> availableStreams = this.getAvailableStreams();
        for (IWorkspace stream : availableStreams) {
            if (!stream.getItemId().getUuidValue().equals(uuid)) continue;
            return stream;
        }
        return null;
    }

    private List<IWorkspace> getAvailableStreams() {
        if (this.fAvailableStreams == null) {
            this.fAvailableStreams = SCMUtil.getAllStreams(this.getInput().getTeamRepository());
        }
        return this.fAvailableStreams;
    }
}

