/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.part;

import com.ibm.team.enterprise.metadata.common.query.util.Util;
import com.ibm.team.enterprise.metadata.ui.query.editor.QueryEditorInput;
import com.ibm.team.enterprise.metadata.ui.query.editor.QueryEditorToolkit;
import com.ibm.team.enterprise.metadata.ui.query.event.WorkingCopyChangeEvent;
import com.ibm.team.enterprise.metadata.ui.query.part.Messages;
import com.ibm.team.enterprise.metadata.ui.query.part.QueryEditorFormPart;
import com.ibm.team.enterprise.metadata.ui.query.util.AccessibleUtil;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NamePart
extends QueryEditorFormPart {
    public static final String PART_ID = "com.ibm.team.enterprise.metadata.ui.query.part.name";
    private Text text;
    private ControlDecoration errorDecoration;

    public void createContent(Composite parent) {
        QueryEditorToolkit toolkit = (QueryEditorToolkit)this.getSite().getToolkit();
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 10;
        parent.setLayout((Layout)layout);
        Label label = toolkit.createLabel(parent, Messages.NamePart_NAME_LABEL);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        Composite container = toolkit.createBorder(parent);
        container.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.text = toolkit.createText(container, "");
        this.text.setTextLimit(100);
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NamePart.this.verifyName();
                String name = NamePart.this.text.getText();
                if (!NamePart.this.getInput().getMetadataQuery().getName().equals(name)) {
                    NamePart.this.getInput().getMetadataQuery().setName(name);
                }
            }
        });
        AccessibleUtil.setAccessibleName((Control)this.text, label.getText());
        this.text.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.updateTextEnablement();
        this.addDecorations();
    }

    private void verifyName() {
        IStatus status = Util.verifyQueryName((String)this.text.getText());
        if (!status.isOK()) {
            this.setErrorMessage(status.getMessage());
        } else {
            this.setErrorMessage(null);
        }
    }

    @Override
    public void setInput(Object input) {
        super.setInput(input);
        this.updateTextEnablement();
        if (input instanceof QueryEditorInput && (!((QueryEditorInput)input).isNew() || ((QueryEditorInput)input).isNew() && !((QueryEditorInput)input).getName().equals(com.ibm.team.enterprise.metadata.ui.query.editor.Messages.QueryEditorInput_NEW_NAME))) {
            this.text.setText(((QueryEditorInput)input).getMetadataQuery().getName());
        }
    }

    private void updateTextEnablement() {
        if (this.text != null) {
            this.text.setEnabled(this.getInput() != null);
        }
    }

    public boolean stretchHorizontally() {
        return true;
    }

    public boolean stretchVertically() {
        return false;
    }

    @Override
    protected void update(WorkingCopyChangeEvent event) {
    }

    private void addDecorations() {
        this.errorDecoration = new ControlDecoration((Control)this.text.getParent(), 0x1004000);
        this.errorDecoration.hide();
        this.errorDecoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage());
    }

    private void setErrorMessage(String message) {
        if (message != null) {
            this.errorDecoration.setDescriptionText(message);
            this.errorDecoration.show();
        } else {
            this.errorDecoration.hide();
        }
    }
}

