/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.part;

import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class CustomSectionTitle
extends Hyperlink {
    private DisposeListener fDisposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            CustomSectionTitle.this.onDispose(e);
        }
    };
    public static final String TITLE_HREF = "title_href";
    public static final String MENU_HREF = "menu_href";
    private static final int MENU_HANDLE_WIDTH = 5;
    private String menuText = "";
    private Rectangle menuTextBox;
    private boolean hovering = false;
    private boolean menuMode = false;
    private boolean hoverHighlighting = false;
    private BoldFontHolder boldFontHolder = new BoldFontHolder();
    private Color textHoverColor = this.getForeground();
    private Color menuTextHoverBackground = this.getBackground();
    private int menuBoxVMargin = 1;
    private int menuBoxHMargin = 2;
    private int menuTextSpacing = 5;

    public CustomSectionTitle(Composite parent, int style) {
        super(parent, style);
        this.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                CustomSectionTitle.this.handleMouseMove(e);
            }
        });
        this.addDisposeListener(this.fDisposeListener);
    }

    public void setHoverHighlighting(boolean on) {
        this.hoverHighlighting = on;
    }

    public void setMenuText(String text) {
        this.menuText = text != null ? text : "";
        this.getParent().layout();
        this.redraw();
    }

    public void setTextHoverColor(Color color) {
        this.textHoverColor = color;
    }

    public void setMenuTextHoverBackground(Color color) {
        this.menuTextHoverBackground = color;
    }

    public Color getTextFGColor() {
        return this.hoverHighlighting && this.hovering && !this.menuMode ? this.textHoverColor : this.getForeground();
    }

    public Object getHref() {
        return this.menuMode ? MENU_HREF : TITLE_HREF;
    }

    protected Point computeTextSize(int widthHint, int heightHint) {
        GC gc = new GC((Drawable)this);
        String text = this.getText();
        gc.setFont(this.boldFontHolder.getBoldFont((Control)this));
        Point titleExtent = gc.textExtent(text != null ? text : "");
        gc.setFont(this.getFont());
        Point menuExtent = this.getMaxMenuExtent(gc);
        int width = titleExtent.x + menuExtent.x + this.menuTextSpacing + 2 * this.menuBoxHMargin + 5;
        Point extent = new Point(width, Math.max(titleExtent.y, menuExtent.y));
        if (extent.x < widthHint) {
            extent.x = widthHint;
        }
        if (extent.y < heightHint) {
            extent.y = heightHint;
        }
        gc.dispose();
        return extent;
    }

    private Point getMaxMenuExtent(GC gc) {
        Point maxExtent = gc.textExtent(this.getMenuText());
        Menu menu = this.getMenu();
        if (menu == null || menu.getItemCount() == 0) {
            return maxExtent;
        }
        MenuItem[] menuItemArray = menu.getItems();
        int n = menuItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem menuItem = menuItemArray[n2];
            Point extent = gc.textExtent(menuItem.getText());
            maxExtent = Geometry.max((Point)maxExtent, (Point)extent);
            ++n2;
        }
        return maxExtent;
    }

    protected void paintText(GC gc, Rectangle bounds) {
        gc.setFont(this.boldFontHolder.getBoldFont((Control)this));
        gc.setForeground(this.getTextFGColor());
        String textToDraw = this.getText();
        Point textExtent = gc.textExtent(textToDraw);
        gc.drawText(textToDraw, bounds.x, bounds.y, true);
        gc.setFont(this.getFont());
        gc.setForeground(this.getForeground());
        String menuTextToDraw = this.getMenuText();
        Point menuTextExtent = gc.textExtent(menuTextToDraw);
        int menuTextStart = bounds.x + textExtent.x + this.menuTextSpacing;
        this.menuTextBox = new Rectangle(menuTextStart - this.menuBoxHMargin, bounds.y - this.menuBoxVMargin, menuTextExtent.x + 5 * this.menuBoxHMargin + 5, bounds.height + 2 * this.menuBoxVMargin);
        if (this.menuMode) {
            gc.setBackground(this.menuTextHoverBackground);
            gc.fillRoundRectangle(this.menuTextBox.x, this.menuTextBox.y, this.menuTextBox.width, this.menuTextBox.height, 2, 2);
        }
        this.drawMenuHandle(gc, this.menuTextBox.x + this.menuTextBox.width - 2 * this.menuBoxHMargin - 5, this.menuTextBox.y + this.menuTextBox.height / 2);
        gc.drawText(menuTextToDraw, menuTextStart, bounds.y, true);
    }

    private void drawMenuHandle(GC gc, int x, int y) {
        gc.drawLine(x, y - 1, x + 4, y - 1);
        gc.drawLine(x + 1, y, x + 3, y);
        gc.drawLine(x + 2, y + 1, x + 2, y + 1);
    }

    private String getMenuText() {
        return this.menuText;
    }

    protected void handleActivate(Event e) {
        Menu menu;
        super.handleActivate(e);
        if ((this.isOverMenu(e.x) || e.type == 1) && (menu = this.getMenu()) != null) {
            Point location = this.toDisplay(this.menuTextBox.x, this.menuTextBox.y + this.menuTextBox.height);
            menu.setLocation(location);
            menu.setVisible(true);
        }
    }

    protected void handleEnter(Event e) {
        if (e.type == 6) {
            this.hovering = true;
            this.menuMode = this.isOverMenu(e.x);
        }
        super.handleEnter(e);
    }

    protected void handleExit(Event e) {
        if (e.type == 7) {
            this.hovering = false;
            this.menuMode = false;
        }
        super.handleExit(e);
    }

    private void handleMouseMove(MouseEvent e) {
        boolean overMenu = this.isOverMenu(e.x);
        if (overMenu != this.menuMode) {
            this.menuMode = overMenu;
            this.redraw();
        }
    }

    private boolean isOverMenu(int x) {
        if (this.menuTextBox == null) {
            return false;
        }
        return x > this.menuTextBox.x && x < this.menuTextBox.x + this.menuTextBox.width;
    }

    private void onDispose(DisposeEvent e) {
        this.boldFontHolder.dispose();
    }

    private static class BoldFontHolder {
        private Font normalFont;
        private Font boldFont;
        private ResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());

        public Font getBoldFont(Font font) {
            this.initBoldFont(font);
            return this.boldFont;
        }

        public Font getBoldFont(Control control) {
            return this.getBoldFont(control.getFont());
        }

        private void initBoldFont(Font font) {
            if (this.normalFont == null || !this.normalFont.equals((Object)font)) {
                this.normalFont = font;
                this.dispose();
            }
            if (this.boldFont == null) {
                this.boldFont = this.createBoldFont(this.normalFont);
            }
        }

        private Font createBoldFont(Font regularFont) {
            FontData[] fontDatas = regularFont.getFontData();
            int i = 0;
            while (i < fontDatas.length) {
                fontDatas[i].setStyle(fontDatas[i].getStyle() | 1);
                ++i;
            }
            return this.resourceManager.createFont(FontDescriptor.createFrom((FontData[])fontDatas));
        }

        public void dispose() {
            this.resourceManager.dispose();
        }
    }
}

