/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.part;

import com.ibm.team.enterprise.common.ui.EESharedImages;
import com.ibm.team.enterprise.metadata.ui.MetadataUIPlugin;
import com.ibm.team.enterprise.metadata.ui.query.control.AbstractSelectionProvider;
import com.ibm.team.enterprise.metadata.ui.query.part.CustomSectionTitle;
import com.ibm.team.jface.preview.DomainAdapterUtils;
import com.ibm.team.jface.preview.IDomainAdapter;
import com.ibm.team.jface.tooltip.TooltipSupport;
import java.util.HashMap;
import java.util.Stack;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;

public class CustomSection
extends Composite {
    private static boolean WORK_AROUND_30701 = "win32".equals(SWT.getPlatform());
    public static final int STYLE_STATUS = 2;
    private static final int BORDER_RADIUS = 6;
    private final PaintListener borderPaintListener = new PaintListener(){

        public void paintControl(PaintEvent e) {
            CustomSection.this.onPaint(e);
        }
    };
    private final DisposeListener disposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            CustomSection.this.onDispose(e);
        }
    };
    private Label titleLabel;
    private ToolBarManager toolBarManager;
    private Composite titleComposite;
    private Composite clientComposite;
    private Color borderColor = MetadataUIPlugin.getDefault().getMidShadow();
    private CustomSectionTitle sectionTitle;
    private CLabel statusLabel;
    private MenuManager menuManager;
    private final HashMap<String, String> messageMap = new HashMap();
    private final Stack<String> keyStack = new Stack();
    private Image fInfoIcon;
    private AbstractSelectionProvider fSelectionProvider;

    public CustomSection(Composite parent, int style) {
        super(parent, 0);
        this.setBackgroundMode(1);
        this.addPaintListener(this.borderPaintListener);
        this.addDisposeListener(this.disposeListener);
        this.createControls(style);
    }

    private void createControls(int style) {
        FormLayout formLayout = new FormLayout();
        formLayout.marginHeight = 2;
        formLayout.marginWidth = 2;
        this.setLayout((Layout)formLayout);
        this.titleComposite = new Composite((Composite)this, 0);
        FormData titleFormData = new FormData();
        titleFormData.left = new FormAttachment(0);
        titleFormData.right = new FormAttachment(100);
        titleFormData.top = new FormAttachment(0);
        this.titleComposite.setLayoutData((Object)titleFormData);
        GridLayoutFactory.fillDefaults().numColumns(2).extendedMargins(5, 5, 1, 1).applyTo(this.titleComposite);
        this.sectionTitle = new CustomSectionTitle(this.titleComposite, 0);
        GridDataFactory.swtDefaults().grab(true, false).applyTo((Control)this.sectionTitle);
        this.toolBarManager = new ToolBarManager(0x800000);
        ToolBar toolBar = this.toolBarManager.createControl(this.titleComposite);
        GridDataFactory.swtDefaults().align(0x1000008, 0x1000000).applyTo((Control)toolBar);
        if ((style & 2) != 0) {
            this.statusLabel = new CLabel((Composite)this, 524288);
            this.fInfoIcon = EESharedImages.getInstance().getImage("IMG_INFO");
            new TooltipSupport((Control)this.statusLabel, true, false){

                protected Object mapElement(int x, int y) {
                    Rectangle bounds;
                    if (CustomSection.this.statusLabel != null && !CustomSection.this.statusLabel.isDisposed() && CustomSection.this.statusLabel.getImage() != null && (bounds = CustomSection.this.statusLabel.getImage().getBounds()).contains(x, y)) {
                        return CustomSection.this.fSelectionProvider;
                    }
                    return null;
                }

                protected String getMarkup(Object element, boolean isFocus) {
                    if (element == null) {
                        return null;
                    }
                    Object finalElem = this.doResolve(element);
                    if (finalElem == null) {
                        return null;
                    }
                    IDomainAdapter adapter = DomainAdapterUtils.getDomainAdapter((Object)finalElem);
                    if (adapter == null) {
                        return null;
                    }
                    IDomainAdapter.Info info = new IDomainAdapter.Info();
                    info.isHoverTooltip = !isFocus;
                    info.isFocusTooltip = isFocus;
                    return this.getMarkupInBackground(adapter, finalElem, info, null);
                }
            }.setPreferredFocusSize(TooltipSupport.PREFERRED_SIZE);
            FormData statusFormData = new FormData();
            statusFormData.left = new FormAttachment(0, 10);
            statusFormData.right = new FormAttachment(100, -10);
            statusFormData.bottom = new FormAttachment(100, -7);
            this.statusLabel.setLayoutData((Object)statusFormData);
        }
        this.clientComposite = new Composite((Composite)this, 1);
        this.clientComposite.setBackground(null);
        FormData clientFormData = new FormData();
        clientFormData.left = new FormAttachment(0, 10);
        clientFormData.right = new FormAttachment(100, -10);
        clientFormData.bottom = this.statusLabel != null ? new FormAttachment((Control)this.statusLabel, -4) : new FormAttachment(100, -10);
        clientFormData.top = new FormAttachment((Control)this.titleComposite, 10);
        this.clientComposite.setLayoutData((Object)clientFormData);
    }

    public void setBorderColor(Color color) {
        Assert.isNotNull((Object)color);
        this.borderColor = color;
    }

    public void setTitleForegroundColor(Color color) {
        this.sectionTitle.setForeground(color);
    }

    public void setTitleBackgroundColor(Color color) {
        this.titleComposite.setBackground(color);
    }

    public void setTitle(String text) {
        Assert.isNotNull((Object)text);
        this.sectionTitle.setText(text);
    }

    public void setTitleToolTip(String toolTipText) {
        this.titleLabel.setToolTipText(toolTipText);
    }

    public void setMenuHoverBackgroundColor(Color color) {
        this.sectionTitle.setMenuTextHoverBackground(color);
    }

    public void setMenuLabel(String label) {
        this.sectionTitle.setMenuText(label);
    }

    public void setSelectionProvider(AbstractSelectionProvider fSelectionProvider) {
        this.fSelectionProvider = fSelectionProvider;
    }

    public void setStatusText(String key, String statusText) {
        if (this.statusLabel == null) {
            return;
        }
        if (statusText == null || "".equals(statusText)) {
            this.messageMap.remove(key);
            this.keyStack.remove(key);
        } else {
            this.messageMap.put(key, statusText);
            if (!this.keyStack.contains(key)) {
                this.keyStack.push(key);
            }
        }
        if (this.keyStack.isEmpty()) {
            this.statusLabel.setText("");
            this.statusLabel.setImage(null);
        } else {
            this.statusLabel.setImage(this.fInfoIcon);
            this.statusLabel.setText(this.messageMap.get(this.keyStack.peek()));
        }
    }

    public IMenuManager getMenuManager() {
        if (this.menuManager == null) {
            this.menuManager = new MenuManager("#popup");
            Menu menu = this.menuManager.createContextMenu((Control)this.sectionTitle);
            this.sectionTitle.setMenu(menu);
        }
        return this.menuManager;
    }

    public IToolBarManager getToolBarManager() {
        return this.toolBarManager;
    }

    public Composite getClientComposite() {
        return this.clientComposite;
    }

    private void onPaint(PaintEvent e) {
        GC gc = e.gc;
        Color foreground = this.getForeground();
        try {
            Rectangle clientArea = this.getClientArea();
            if (!WORK_AROUND_30701) {
                gc.setAntialias(1);
            }
            gc.setForeground(this.borderColor);
            gc.drawRoundRectangle(0, 0, clientArea.width - 1, clientArea.height - 1, 6, 6);
            gc.setForeground(this.getBackground());
            gc.drawPoint(0, clientArea.height - 1);
            gc.drawPoint(clientArea.width - 1, clientArea.height - 1);
        }
        finally {
            if (!WORK_AROUND_30701) {
                gc.setAntialias(0);
            }
            gc.setForeground(foreground);
        }
    }

    private void onDispose(DisposeEvent e) {
    }
}

