/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.part;

import com.ibm.team.enterprise.metadata.query.common.AttributeExpression;
import com.ibm.team.enterprise.metadata.query.common.AttributeOperator;
import com.ibm.team.enterprise.metadata.query.common.Expression;
import com.ibm.team.enterprise.metadata.query.common.IAttribute;
import com.ibm.team.enterprise.metadata.ui.query.control.AbstractSelectionProvider;
import com.ibm.team.enterprise.metadata.ui.query.control.ConditionControlInput;
import com.ibm.team.enterprise.metadata.ui.query.control.IConditionControl;
import com.ibm.team.enterprise.metadata.ui.query.event.WorkingCopyChangeEvent;
import com.ibm.team.enterprise.metadata.ui.query.part.AbstractConditionPart;
import com.ibm.team.enterprise.metadata.ui.query.part.Messages;
import java.text.ChoiceFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;

public class ConditionPart
extends AbstractConditionPart {
    private final AttributeExpression expression;
    private IConditionControl conditionControl;
    private boolean showSummary;

    public ConditionPart(AttributeExpression expression) {
        this.expression = expression;
        this.showSummary = false;
    }

    @Override
    protected void update(WorkingCopyChangeEvent event) {
        if (!event.isExpressionChangeEventType()) {
            return;
        }
        switch (event.getMetadataQueryChangeEventSubType()) {
            case EXPRESSION_OPERATOR_CHANGED: {
                this.updateOperator();
                break;
            }
        }
    }

    @Override
    protected String getPartTitle() {
        if (this.expression.getAttribute().getParent() != null) {
            return String.valueOf(this.expression.getAttribute().getParent().getDisplayConditionName()) + " > " + this.expression.getAttribute().getDisplayConditionName();
        }
        return this.expression.getAttribute().getDisplayConditionName();
    }

    @Override
    protected void createPartContent(Composite contentArea) {
        this.createConditionPartContent(contentArea);
    }

    @Override
    protected Expression getExpression() {
        return this.expression;
    }

    public void setFocus() {
        if (this.conditionControl != null) {
            this.conditionControl.setFocus();
        }
    }

    protected void createConditionPartContent(Composite contentArea) {
        this.conditionControl = this.getInput().getControlFactory().createConditionControl(this.expression.getAttribute());
        if (this.conditionControl == null) {
            return;
        }
        this.conditionControl.init(this);
        this.createOperatorMenu();
        this.updateOperator();
        this.conditionControl.createContent(contentArea);
        if (this.conditionControl instanceof AbstractSelectionProvider) {
            this.getCustomSection().setSelectionProvider((AbstractSelectionProvider)((Object)this.conditionControl));
        }
        this.updateStatus();
        this.setInput();
        this.updateValues();
        this.installListeners();
    }

    private void setInput() {
        this.conditionControl.setInput(new ConditionControlInput(this.getInput().getProjectArea(), this.expression));
    }

    private void updateValues() {
    }

    private void installListeners() {
        this.conditionControl.getSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ConditionPart.this.handleSelectionChanged(event);
            }
        });
    }

    protected List<AttributeOperator> getOperators() {
        return this.expression.getAttribute().getOperators();
    }

    protected void handleSetOperator(AttributeOperator operator) {
        this.expression.setOperator(operator);
    }

    private void updateOperator() {
        this.getCustomSection().setMenuLabel(this.expression.getOperator().getDisplayName());
    }

    private void createOperatorMenu() {
        IMenuManager operatorMenu = this.getMenuManager();
        List<AttributeOperator> operators = this.getOperators();
        for (AttributeOperator operator : operators) {
            SetOperatorAction action = new SetOperatorAction(operator);
            operatorMenu.add((IAction)action);
        }
        operatorMenu.update(true);
    }

    private void handleSelectionChanged(SelectionChangedEvent event) {
        ArrayList<Object> values = new ArrayList<Object>(this.getSelectionValues(event.getSelection()));
        Object expreValue = this.expression.getValue();
        if (expreValue != null && !(expreValue instanceof List)) {
            if (!values.isEmpty()) {
                this.expression.setValue(values.get(0));
            } else {
                this.expression.setValue((Object)"");
            }
        }
        this.updateStatus();
    }

    private List<Object> getSelectionValues(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            return structuredSelection.toList();
        }
        return Collections.emptyList();
    }

    @Override
    public void showSummary(boolean show) {
        this.showSummary = show;
    }

    private void updateStatus() {
        if (this.showSummary) {
            Object value;
            int number = 0;
            if (this.expression != null && (value = this.expression.getValue()) != null) {
                if (value instanceof List) {
                    number = ((List)value).size();
                    if (IAttribute.AttributeType.COMPONENT_TREE.equals((Object)this.expression.getAttribute().getType()) && number >= 2) {
                        String second = ((List)value).get(1).toString();
                        boolean isCurrentPA = Boolean.valueOf(second);
                        number = isCurrentPA ? --number : (number -= 2);
                    }
                } else {
                    number = value instanceof Map ? ((Map)value).keySet().size() : (value.toString().isEmpty() ? 0 : 1);
                }
            }
            ChoiceFormat choiceFormat = new ChoiceFormat(Messages.ConditionPart_SELECTED_VALUES_CHOICEFORMAT);
            String format = choiceFormat.format(number);
            String message = NLS.bind((String)format, (Object)number);
            this.getCustomSection().setStatusText("count", message);
        }
    }

    @Override
    public boolean isDisposed() {
        return this.getCustomSection().isDisposed();
    }

    private class SetOperatorAction
    extends Action {
        private AttributeOperator operator;

        public SetOperatorAction(AttributeOperator operator) {
            super(operator.getDisplayName());
            this.operator = operator;
        }

        public void run() {
            ConditionPart.this.handleSetOperator(this.operator);
        }
    }
}

