/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.part;

import com.ibm.team.enterprise.metadata.common.query.util.AttributeProviderFactory;
import com.ibm.team.enterprise.metadata.query.common.AttributeColumn;
import com.ibm.team.enterprise.metadata.query.common.IAttribute;
import com.ibm.team.enterprise.metadata.query.common.MetadataQueryChangeEvent;
import com.ibm.team.enterprise.metadata.query.common.Statement;
import com.ibm.team.enterprise.metadata.ui.query.editor.QueryEditor;
import com.ibm.team.enterprise.metadata.ui.query.editor.QueryEditorToolkit;
import com.ibm.team.enterprise.metadata.ui.query.event.WorkingCopyChangeEvent;
import com.ibm.team.enterprise.metadata.ui.query.part.AttributeColumnContentProvider;
import com.ibm.team.enterprise.metadata.ui.query.part.AttributeColumnLabelProvider;
import com.ibm.team.enterprise.metadata.ui.query.part.Messages;
import com.ibm.team.enterprise.metadata.ui.query.part.QueryEditorFormPart;
import com.ibm.team.enterprise.metadata.ui.query.part.SlushBucket;
import com.ibm.team.enterprise.metadata.ui.query.util.AccessibleUtil;
import com.ibm.team.enterprise.metadata.ui.query.util.DefaultViewerComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorPart;

public class ColumnsPart
extends QueryEditorFormPart {
    public static final String PART_ID = "com.ibm.team.enterprise.metadata.ui.query.part.columns";
    private final SelectionAdapter buttonDispatcher = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            if (ColumnsPart.this.slushBucket.getAddButton() == e.widget) {
                ColumnsPart.this.handleAdd();
            } else if (ColumnsPart.this.slushBucket.getAddAllButton() == e.widget) {
                ColumnsPart.this.handleAddAll();
            } else if (ColumnsPart.this.slushBucket.getRemoveButton() == e.widget) {
                ColumnsPart.this.handleRemove();
            } else if (ColumnsPart.this.slushBucket.getRemoveAllButton() == e.widget) {
                ColumnsPart.this.handleRemoveAll();
            } else if (ColumnsPart.this.slushBucket.getUpButton() == e.widget) {
                ColumnsPart.this.handleMoveUp();
            } else if (ColumnsPart.this.slushBucket.getDownButton() == e.widget) {
                ColumnsPart.this.handleMoveDown();
            } else if (ColumnsPart.this.slushBucket.getDefaultsButton() == e.widget) {
                ColumnsPart.this.handleSetDefaults();
            }
        }
    };
    private final IDoubleClickListener doubleClickDispatcher = new IDoubleClickListener(){

        public void doubleClick(DoubleClickEvent event) {
            if (ColumnsPart.this.availableColumnViewer == event.getViewer()) {
                ColumnsPart.this.handleAdd();
            } else if (ColumnsPart.this.selectedColumnViewer == event.getViewer()) {
                ColumnsPart.this.handleRemove();
            }
        }
    };
    private TableViewer availableColumnViewer;
    private TableViewer selectedColumnViewer;
    private SlushBucket slushBucket;
    private Statement statement;
    private List<AttributeColumn> availableColumns;

    @Override
    protected void update(WorkingCopyChangeEvent event) {
        if (event.getMetadataQueryChangeEventType() == MetadataQueryChangeEvent.Type.SELECT_COLUMN_CHANGED) {
            MetadataQueryChangeEvent.SubType subType = event.getMetadataQueryChangeEventSubType();
            switch (subType) {
                case COLUMN_ADDED: {
                    this.addColumns(event.getMetadataQueryChangeEvent().getColumns());
                    break;
                }
                case COLUMN_REMOVED: {
                    this.removeColumns(event.getMetadataQueryChangeEvent().getColumns());
                    break;
                }
                case COLUMN_REORDERED: {
                    this.updateColumns();
                    break;
                }
                case COLUMN_CHANGED: {
                    this.updateAll();
                    break;
                }
            }
        }
    }

    @Override
    public void setInput(Object input) {
        super.setInput(input);
        this.statement = this.getInput().getStatement();
        this.availableColumns = AttributeProviderFactory.getInstance().getAvailableAttributeColumns();
        IEditorPart editor = this.getSite().getWorkbenchPage().getActiveEditor();
        if (editor instanceof QueryEditor) {
            this.availableColumns.addAll(AttributeProviderFactory.getInstance().createAttributeColumn(((QueryEditor)editor).getCustomAttributes()));
        }
        this.availableColumnViewer.setInput(this.availableColumns);
        this.selectedColumnViewer.setInput((Object)this.statement);
        this.slushBucket.updateButtonEnablement();
        this.updateAll();
    }

    public void refreshAvailableColumns(List<IAttribute> customAttributes) {
        this.availableColumns = AttributeProviderFactory.getInstance().getAvailableAttributeColumns();
        this.availableColumns.addAll(AttributeProviderFactory.getInstance().createAttributeColumn(customAttributes));
        this.availableColumnViewer.setInput(this.availableColumns);
        ArrayList<AttributeColumn> deletedColumns = new ArrayList<AttributeColumn>();
        int numItems = this.selectedColumnViewer.getTable().getItemCount();
        int i = 0;
        while (i < numItems) {
            AttributeColumn attributeColumn = (AttributeColumn)this.selectedColumnViewer.getElementAt(i);
            if (!this.isInAvailableColumn(attributeColumn)) {
                deletedColumns.add(attributeColumn);
            }
            ++i;
        }
        this.selectedColumnViewer.remove((Object[])deletedColumns.toArray(new AttributeColumn[deletedColumns.size()]));
        numItems = this.selectedColumnViewer.getTable().getItemCount();
        ArrayList<AttributeColumn> selectedAttributeColumns = new ArrayList<AttributeColumn>();
        int i2 = 0;
        while (i2 < numItems) {
            selectedAttributeColumns.add((AttributeColumn)this.selectedColumnViewer.getElementAt(i2));
            ++i2;
        }
        this.addColumns(selectedAttributeColumns);
    }

    private boolean isInAvailableColumn(AttributeColumn attributeColumn) {
        for (AttributeColumn availableColumn : this.availableColumns) {
            if (!attributeColumn.getAttribute().getDisplayName().equals(availableColumn.getAttribute().getDisplayName())) continue;
            return true;
        }
        return false;
    }

    public void createContent(Composite parent) {
        QueryEditorToolkit toolkit = (QueryEditorToolkit)this.getSite().getToolkit();
        this.slushBucket = toolkit.createSlushBucket(parent, Messages.ColumnsPart_AVAILABLE_COLUMNS, Messages.ColumnsPart_SELECTED_COLUMNS);
        this.availableColumnViewer = new TableViewer(this.slushBucket.getAvailableTable());
        this.availableColumnViewer.setContentProvider((IContentProvider)new AttributeColumnContentProvider());
        this.availableColumnViewer.setLabelProvider((IBaseLabelProvider)new AttributeColumnLabelProvider());
        this.availableColumnViewer.setComparator((ViewerComparator)new DefaultViewerComparator(AttributeColumn.createComparator()));
        this.availableColumnViewer.addFilter((ViewerFilter)new AvailableColumnsFilter());
        this.selectedColumnViewer = new TableViewer(this.slushBucket.getSelectedTable());
        this.selectedColumnViewer.setContentProvider((IContentProvider)new SelectedColumnsContentProvider());
        this.selectedColumnViewer.setLabelProvider((IBaseLabelProvider)new AttributeColumnLabelProvider());
        this.slushBucket.addSelectionListener((SelectionListener)this.buttonDispatcher);
        this.availableColumnViewer.addDoubleClickListener(this.doubleClickDispatcher);
        this.selectedColumnViewer.addDoubleClickListener(this.doubleClickDispatcher);
        AccessibleUtil.setAccessibleName((Control)this.slushBucket.getAvailableTable(), Messages.ColumnsPart_AVAILABLE_COLUMNS);
        AccessibleUtil.setAccessibleName((Control)this.slushBucket.getSelectedTable(), Messages.ColumnsPart_SELECTED_COLUMNS);
    }

    private void handleAdd() {
        List<AttributeColumn> columns = this.getColumnsFromSelection(this.availableColumnViewer.getSelection());
        this.statement.getSelectClause().addColumns(columns);
    }

    private void handleAddAll() {
        this.statement.getSelectClause().addColumns(this.availableColumns);
    }

    private void handleRemove() {
        List<AttributeColumn> columns = this.getColumnsFromSelection(this.selectedColumnViewer.getSelection());
        this.statement.getSelectClause().removeColumns(columns);
    }

    private void handleRemoveAll() {
        this.statement.getSelectClause().removeAllColumns();
    }

    private void handleMoveUp() {
        List<AttributeColumn> columns = this.getColumnsFromSelection(this.selectedColumnViewer.getSelection());
        this.statement.getSelectClause().moveColumns(columns, -1);
    }

    private void handleMoveDown() {
        List<AttributeColumn> columns = this.getColumnsFromSelection(this.selectedColumnViewer.getSelection());
        this.statement.getSelectClause().moveColumns(columns, 1);
    }

    private void addColumns(List<AttributeColumn> columns) {
        this.selectedColumnViewer.refresh();
        this.selectedColumnViewer.setSelection((ISelection)new StructuredSelection(columns));
        this.availableColumnViewer.remove(columns.toArray());
        this.slushBucket.updateButtonEnablement();
    }

    private void removeColumns(List<AttributeColumn> columns) {
        this.selectedColumnViewer.refresh();
        this.availableColumnViewer.add(columns.toArray());
        this.availableColumnViewer.setSelection((ISelection)new StructuredSelection(columns));
        this.slushBucket.updateButtonEnablement();
    }

    private void updateAll() {
        this.selectedColumnViewer.refresh();
        this.availableColumnViewer.refresh();
        TableItem[] items = this.selectedColumnViewer.getTable().getItems();
        ArrayList<AttributeColumn> columns = new ArrayList<AttributeColumn>(items.length);
        TableItem[] tableItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            columns.add((AttributeColumn)item.getData());
            ++n2;
        }
        this.availableColumnViewer.remove(columns.toArray());
        this.slushBucket.updateButtonEnablement();
    }

    private void updateColumns() {
        this.selectedColumnViewer.refresh();
        this.slushBucket.updateButtonEnablement();
    }

    private void handleSetDefaults() {
        this.statement.getSelectClause().setColumns(AttributeProviderFactory.getInstance().getDefaultAttributeColumns());
    }

    private List<AttributeColumn> getColumnsFromSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            ArrayList<AttributeColumn> columns = new ArrayList<AttributeColumn>(structuredSelection.size());
            for (Object element : structuredSelection) {
                if (!(element instanceof AttributeColumn)) continue;
                columns.add((AttributeColumn)element);
            }
            return columns;
        }
        return Collections.emptyList();
    }

    public boolean stretchHorizontally() {
        return true;
    }

    public boolean stretchVertically() {
        return true;
    }

    private class AvailableColumnsFilter
    extends ViewerFilter {
        private AvailableColumnsFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return true;
        }
    }

    private static class SelectedColumnsContentProvider
    implements IStructuredContentProvider {
        private SelectedColumnsContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Statement) {
                Statement statement = (Statement)inputElement;
                return statement.getSelectClause().getColumns().toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

