/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.part;

import com.ibm.team.enterprise.metadata.query.common.Expression;
import com.ibm.team.enterprise.metadata.ui.query.action.AddConditionsAction;
import com.ibm.team.enterprise.metadata.ui.query.action.RemoveConditionAction;
import com.ibm.team.enterprise.metadata.ui.query.control.IConditionControlSite;
import com.ibm.team.enterprise.metadata.ui.query.editor.QueryEditorToolkit;
import com.ibm.team.enterprise.metadata.ui.query.part.CustomSection;
import com.ibm.team.enterprise.metadata.ui.query.part.QueryEditorFormPart;
import com.ibm.team.jface.GradientUtilities;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class AbstractConditionPart
extends QueryEditorFormPart
implements IConditionControlSite {
    private CustomSection customSection;

    public void createContent(Composite parent) {
        QueryEditorToolkit toolkit = (QueryEditorToolkit)this.getToolkit();
        this.customSection = toolkit.createCustomSection(parent, 2);
        this.customSection.setTitle(this.getPartTitle());
        FormColors colors = this.getToolkit().getColors();
        GradientUtilities.setVerticalGradient((Composite)this.customSection, (Color)colors.getColor("org.eclipse.ui.forms.H_GRADIENT_END"), (Color)colors.getColor("org.eclipse.ui.forms.H_GRADIENT_START"));
        this.createPartContent(this.customSection.getClientComposite());
        this.installToolbarActions();
    }

    private void installToolbarActions() {
        this.getToolBarManager().add((IAction)new RemoveConditionAction(this.getExpression()));
        this.getToolBarManager().add((IAction)new AddConditionsAction(this.customSection.getShell(), this.getExpression().getParent()));
        this.getToolBarManager().update(false);
    }

    public boolean stretchHorizontally() {
        return true;
    }

    public boolean stretchVertically() {
        return true;
    }

    @Override
    public IToolBarManager getToolBarManager() {
        return this.getCustomSection().getToolBarManager();
    }

    @Override
    public FormToolkit getToolkit() {
        return this.getSite().getToolkit();
    }

    @Override
    public void showStatusText(String text) {
        this.getCustomSection().setStatusText("status", text);
    }

    protected IMenuManager getMenuManager() {
        return this.getCustomSection().getMenuManager();
    }

    protected CustomSection getCustomSection() {
        return this.customSection;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.getCustomSection().dispose();
    }

    protected abstract Expression getExpression();

    protected abstract void createPartContent(Composite var1);

    protected abstract String getPartTitle();
}

