/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.navigator;

import com.ibm.team.enterprise.common.ui.IEnterpriseExtensionsNode;
import com.ibm.team.enterprise.common.ui.domain.AbstractEnterpriseExtensionsNode;
import com.ibm.team.enterprise.metadata.client.query.IMetadataQueryClient;
import com.ibm.team.enterprise.metadata.common.query.IScdQueryDescriptor;
import com.ibm.team.enterprise.metadata.ui.MetadataUIPlugin;
import com.ibm.team.enterprise.metadata.ui.query.action.NewMetadataQueryAction;
import com.ibm.team.enterprise.metadata.ui.query.navigator.Messages;
import com.ibm.team.enterprise.metadata.ui.query.navigator.QueryNodeEE;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.progress.IElementCollector;

public class SharedQueriesNodeEE
extends AbstractEnterpriseExtensionsNode {
    public static final String NODE_PATH_ID = "SourceCodeData/SharedQueries";
    public static final String NODE_ID = "com.ibm.team.enterprise.metadata.ui.query.sharedqueries";
    private boolean isFetching;

    public void contributeContextMenuActions(IMenuManager manager, IStructuredSelection selection) {
        Object selected;
        if (selection.size() == 1 && (selected = selection.getFirstElement()) instanceof SharedQueriesNodeEE) {
            IProjectAreaHandle projectAreaHandle = ((SharedQueriesNodeEE)((Object)selected)).getProjectAreaHandle();
            NewMetadataQueryAction newQueryAction = new NewMetadataQueryAction(projectAreaHandle);
            newQueryAction.setActivePart(null, this.getDomainSubtreeRoot().getDomain().getWorkbenchPart());
            manager.appendToGroup("jazz.new.group", (IAction)newQueryAction);
        }
        super.contributeContextMenuActions(manager, selection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchDeferredChildren(IElementCollector collector, IProgressMonitor monitor) {
        SharedQueriesNodeEE sharedQueriesNodeEE = this;
        synchronized (sharedQueriesNodeEE) {
            if (this.isFetching) {
                return;
            }
            this.isFetching = true;
        }
        try {
            monitor.beginTask("", -1);
            this.collectSharedQueryNodes(collector, monitor);
        }
        catch (Throwable throwable) {
            SharedQueriesNodeEE sharedQueriesNodeEE2 = this;
            synchronized (sharedQueriesNodeEE2) {
                this.isFetching = false;
            }
            throw throwable;
        }
        SharedQueriesNodeEE sharedQueriesNodeEE3 = this;
        synchronized (sharedQueriesNodeEE3) {
            this.isFetching = false;
        }
    }

    private void collectSharedQueryNodes(IElementCollector collector, IProgressMonitor monitor) {
        IProjectAreaHandle projectAreaHandle = this.getProjectAreaHandle();
        ArrayList<QueryNodeEE> queryNodes = new ArrayList<QueryNodeEE>();
        ITeamRepository repository = (ITeamRepository)projectAreaHandle.getOrigin();
        IMetadataQueryClient client = (IMetadataQueryClient)repository.getClientLibrary(IMetadataQueryClient.class);
        try {
            IScdQueryDescriptor[] queryDescriptors;
            IScdQueryDescriptor[] iScdQueryDescriptorArray = queryDescriptors = client.getQueryScdQueryDescriptors(projectAreaHandle);
            int n = queryDescriptors.length;
            int n2 = 0;
            while (n2 < n) {
                IScdQueryDescriptor queryDescriptor = iScdQueryDescriptorArray[n2];
                queryNodes.add(new QueryNodeEE(queryDescriptor, this.getDomainSubtreeRoot(), this.getProjectAreaHandle(), (IEnterpriseExtensionsNode)this));
                ++n2;
            }
        }
        catch (TeamRepositoryException e) {
            e.printStackTrace();
        }
        collector.add(queryNodes.toArray(), monitor);
        collector.done();
    }

    public boolean hasChildren() {
        return true;
    }

    public Image getIcon() {
        return MetadataUIPlugin.getImage("icons/obj16/shared_queries.gif");
    }

    public String getLabel() {
        return Messages.SharedQueriesNode_label;
    }
}

