/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.editor;

import com.ibm.team.enterprise.metadata.query.common.Statement;
import com.ibm.team.enterprise.metadata.ui.query.action.RunAction;
import com.ibm.team.enterprise.metadata.ui.query.editor.QueryEditorInput;
import com.ibm.team.enterprise.metadata.ui.query.editor.QueryEditorToolkit;
import com.ibm.team.ui.editor.TeamFormPage;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class SourcePage
extends TeamFormPage {
    private Statement statement;
    private QueryEditorToolkit toolkit;
    private StyledText text;
    private Button runButton;

    public SourcePage(QueryEditorToolkit toolkit, Statement statement) {
        super("source", "Source (for development debugging only)");
        this.statement = statement;
        this.toolkit = toolkit;
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        Composite body = form.getBody();
        FormLayout layout = new FormLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        body.setLayout((Layout)layout);
        GridLayoutFactory.fillDefaults().applyTo(body);
        this.runButton = this.toolkit.createButton(body, "Edit and click here to run", 8);
        this.runButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QueryEditorInput input = (QueryEditorInput)SourcePage.this.getEditorInput();
                RunAction runAction = new RunAction();
                runAction.setActivePart(SourcePage.this.getEditor().getSite().getPart());
                runAction.selectionChanged((ISelection)new StructuredSelection((Object)input.getMetadataQuery()));
                runAction.selectionChanged((ISelection)new StructuredSelection((Object)SourcePage.this.text.getText()));
                runAction.selectionChanged((ISelection)new StructuredSelection((Object)input.getTeamRepository()));
                runAction.selectionChanged((ISelection)new StructuredSelection((Object)input.getProjectArea()));
                runAction.run();
            }
        });
        this.text = new StyledText(body, 2048);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.text);
        managedForm.setInput((Object)this.getEditorInput());
    }

    public void setActive(boolean active) {
        super.setActive(active);
        if (active) {
            this.text.setText(this.statement.getSPARQLString());
        }
    }
}

