/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.editor;

import com.ibm.team.enterprise.metadata.common.query.util.MetadataQuery;
import com.ibm.team.enterprise.metadata.query.common.IMetadataQuery;
import com.ibm.team.enterprise.metadata.query.common.IMetadataQueryChangeListener;
import com.ibm.team.enterprise.metadata.query.common.MetadataQueryChangeEvent;
import com.ibm.team.enterprise.metadata.query.common.Statement;
import com.ibm.team.enterprise.metadata.ui.query.control.BasicQueryEditorControlFactory;
import com.ibm.team.enterprise.metadata.ui.query.editor.Messages;
import com.ibm.team.enterprise.metadata.ui.query.event.IWorkingCopyListener;
import com.ibm.team.enterprise.metadata.ui.query.event.WorkingCopyChangeEvent;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

public class QueryEditorInput
implements IEditorInput {
    private BasicQueryEditorControlFactory controlFactory;
    private IMetadataQuery metadataQuery;
    private List<IWorkingCopyListener> listeners;
    private ITeamRepository repository;
    private IProjectAreaHandle projectArea;
    private boolean isDirty = false;
    private String name;
    private boolean isNew;

    public QueryEditorInput(IProjectAreaHandle projectArea) {
        this(projectArea, null);
    }

    public QueryEditorInput(IProjectAreaHandle projectArea, IMetadataQuery metadataQuery) {
        try {
            this.projectArea = projectArea;
            this.repository = (ITeamRepository)projectArea.getOrigin();
            if (metadataQuery == null) {
                this.isNew = true;
                this.name = Messages.QueryEditorInput_NEW_NAME;
                this.metadataQuery = new MetadataQuery("", this.repository.getRepositoryURI(), projectArea.getItemId().getUuidValue(), new Statement());
            } else {
                this.isNew = false;
                this.name = metadataQuery.getName();
                this.metadataQuery = metadataQuery;
            }
            this.metadataQuery.addListener(new IMetadataQueryChangeListener(){

                public void queryChanged(MetadataQueryChangeEvent event) {
                    QueryEditorInput.this.isDirty = true;
                    for (IWorkingCopyListener listener : QueryEditorInput.this.listeners) {
                        listener.workingCopyChanged(new WorkingCopyChangeEvent(event));
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean exists() {
        return true;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return Messages.QueryEditorInput_TOOLTIP;
    }

    public BasicQueryEditorControlFactory getControlFactory() {
        if (this.controlFactory == null) {
            this.controlFactory = new BasicQueryEditorControlFactory();
        }
        return this.controlFactory;
    }

    public Statement getStatement() {
        return this.metadataQuery.getStatement();
    }

    public void addListener(IWorkingCopyListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<IWorkingCopyListener>();
        }
        this.listeners.add(listener);
    }

    public Object getAdapter(Class arg0) {
        return null;
    }

    public IProjectAreaHandle getProjectArea() {
        return this.projectArea;
    }

    public ITeamRepository getTeamRepository() {
        return this.repository;
    }

    public IMetadataQuery getMetadataQuery() {
        return this.metadataQuery;
    }

    public void setIsDirty(boolean isDirty) {
        this.isDirty = isDirty;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof QueryEditorInput)) {
            return false;
        }
        if (this.projectArea == null || this.metadataQuery == null) {
            return false;
        }
        QueryEditorInput aInput = (QueryEditorInput)obj;
        IProjectAreaHandle aProjectArea = aInput.getProjectArea();
        IMetadataQuery aMetadataQuery = aInput.getMetadataQuery();
        if (aProjectArea == null || aMetadataQuery == null) {
            return false;
        }
        return this.projectArea.getItemId().equals((Object)aProjectArea.getItemId()) && this.metadataQuery.getName().equals(aMetadataQuery.getName());
    }

    public void setIsNew(boolean isNew) {
        this.isNew = isNew;
    }

    public void setName(String name) {
        this.name = name;
    }
}

