/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.editor;

import com.ibm.team.enterprise.metadata.client.query.IMetadataQueryClient;
import com.ibm.team.enterprise.metadata.common.query.util.Util;
import com.ibm.team.enterprise.metadata.query.common.IAttribute;
import com.ibm.team.enterprise.metadata.query.common.IMetadataQuery;
import com.ibm.team.enterprise.metadata.query.common.MetadataQueryChangeEvent;
import com.ibm.team.enterprise.metadata.ui.query.action.DuplicateMetadataQueryAction;
import com.ibm.team.enterprise.metadata.ui.query.editor.Messages;
import com.ibm.team.enterprise.metadata.ui.query.editor.QueryConditionsPage;
import com.ibm.team.enterprise.metadata.ui.query.editor.QueryEditorInput;
import com.ibm.team.enterprise.metadata.ui.query.editor.QueryEditorToolkit;
import com.ibm.team.enterprise.metadata.ui.query.editor.QueryResultLayoutPage;
import com.ibm.team.enterprise.metadata.ui.query.editor.SourcePage;
import com.ibm.team.enterprise.metadata.ui.query.event.IWorkingCopyListener;
import com.ibm.team.enterprise.metadata.ui.query.event.UIWorkingCopyAdapter;
import com.ibm.team.enterprise.metadata.ui.query.event.WorkingCopyChangeEvent;
import com.ibm.team.enterprise.metadata.ui.query.part.QueryEditorHeaderSection;
import com.ibm.team.enterprise.metadata.ui.query.part.TitlePart;
import com.ibm.team.enterprise.metadata.ui.query.view.ViewUtil;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.ui.editor.TeamFormColors;
import com.ibm.team.ui.editor.TeamFormEditor;
import com.ibm.team.ui.editor.TeamFormPartContainer;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.editor.SharedHeaderFormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class QueryEditor
extends TeamFormEditor {
    public static final String ID = "com.ibm.team.enterprise.metadata.ui.query.editor.QueryEditor";
    private TitlePart titlePart;
    private final UIWorkingCopyAdapter uiWorkingCopyAdapter = new UIWorkingCopyAdapter();
    private QueryEditorToolkit toolkit;
    private List<IAttribute> customAttributeCache;
    private IMetadataQuery newCopyQuery;

    public QueryEditor() {
        this.uiWorkingCopyAdapter.addListener(new IWorkingCopyListener(){

            @Override
            public void workingCopyChanged(WorkingCopyChangeEvent event) {
                if (event.getMetadataQueryChangeEvent() != null && event.getMetadataQueryChangeEventType() == MetadataQueryChangeEvent.Type.NAME_CHANGED) {
                    QueryEditor.this.setPartName(event.getMetadataQueryChangeEvent().getName());
                }
                QueryEditor.this.firePropertyChange(257);
            }
        });
    }

    protected void addPages() {
        try {
            ((QueryEditorInput)this.getEditorInput()).addListener(this.uiWorkingCopyAdapter);
            QueryConditionsPage page = new QueryConditionsPage(this.toolkit, this.titlePart);
            page.initialize((FormEditor)this);
            this.addPage((IFormPage)page);
            QueryResultLayoutPage page2 = new QueryResultLayoutPage();
            page2.initialize((FormEditor)this);
            this.addPage((IFormPage)page2);
            SourcePage page3 = new SourcePage(this.toolkit, ((QueryEditorInput)this.getEditorInput()).getStatement());
            page3.initialize((FormEditor)this);
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    public void doSaveAs() {
        if (this.getEditorInput() instanceof QueryEditorInput) {
            final QueryEditorInput input = (QueryEditorInput)this.getEditorInput();
            if (!this.validate(input.getMetadataQuery())) {
                return;
            }
            final String newName = DuplicateMetadataQueryAction.generateNewName2(input.getMetadataQuery().getName());
            IStatus status = this.runLongOperation(new IRunnableWithProgress(){

                public void run(IProgressMonitor operationMonitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            operationMonitor.beginTask(Messages.QueryEditor_SAVE_JOB_NAME, 100);
                            IMetadataQueryClient client = (IMetadataQueryClient)input.getTeamRepository().getClientLibrary(IMetadataQueryClient.class);
                            QueryEditor.this.newCopyQuery = client.saveCopy(input.getMetadataQuery(), newName, operationMonitor);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        operationMonitor.done();
                    }
                }
            }, MessageFormat.format(Messages.QueryEditor_SAVE_ERROR, newName));
            if (status.isOK()) {
                try {
                    QueryEditorInput newInput = new QueryEditorInput(input.getProjectArea(), this.newCopyQuery);
                    this.getEditorSite().getPage().openEditor((IEditorInput)newInput, ID);
                    ViewUtil.refreshTeamArtifacts(newInput);
                }
                catch (PartInitException e) {
                    this.setStatus(Messages.QueryEditor_SAVE_PROBLEM, status);
                }
            } else {
                this.setStatus(Messages.QueryEditor_SAVE_PROBLEM, status);
            }
        }
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    protected void createHeaderContents(IManagedForm headerForm) {
        this.titlePart = new TitlePart();
        this.titlePart.init((SharedHeaderFormEditor)this);
        this.titlePart.setInput(this.getEditorInput());
        QueryEditorHeaderSection headerSection = new QueryEditorHeaderSection();
        Composite head = headerForm.getForm().getForm().getHead();
        Control headClient = TeamFormPartContainer.setup((TeamFormPartContainer)headerSection, (IManagedForm)headerForm, (Composite)head);
        headerForm.addPart((IFormPart)headerSection);
        headerForm.getForm().setHeadClient(headClient);
        this.setPartName(this.getEditorInput().getName());
    }

    protected FormToolkit createToolkit(Display display) {
        this.toolkit = new QueryEditorToolkit((FormColors)new TeamFormColors(display));
        return this.toolkit;
    }

    public Object getAdapter(Class adapter) {
        if (UIWorkingCopyAdapter.class.equals((Object)adapter)) {
            return this.uiWorkingCopyAdapter;
        }
        return super.getAdapter(adapter);
    }

    public void doSave(IProgressMonitor monitor) {
        super.doSave(monitor);
        if (this.getEditorInput() instanceof QueryEditorInput) {
            final QueryEditorInput input = (QueryEditorInput)this.getEditorInput();
            if (!this.validate(input.getMetadataQuery())) {
                return;
            }
            IStatus status = this.runLongOperation(new IRunnableWithProgress(){

                public void run(IProgressMonitor operationMonitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            operationMonitor.beginTask(Messages.QueryEditor_SAVE_JOB_NAME, 100);
                            IMetadataQueryClient client = (IMetadataQueryClient)input.getTeamRepository().getClientLibrary(IMetadataQueryClient.class);
                            if (input.isNew()) {
                                client.saveMetadataQuery(input.getMetadataQuery(), false, operationMonitor);
                            } else {
                                client.modifyMetadataQuery(input.getMetadataQuery(), input.getName(), operationMonitor);
                            }
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        operationMonitor.done();
                    }
                }
            }, MessageFormat.format(Messages.QueryEditor_SAVE_ERROR, input.getMetadataQuery().getName()));
            if (status.isOK()) {
                this.setStatus(null, Status.OK_STATUS);
                input.setIsDirty(false);
                input.setIsNew(false);
                input.setName(input.getMetadataQuery().getName());
                this.firePropertyChange(257);
                ViewUtil.refreshTeamArtifacts(input);
            } else {
                this.setStatus(Messages.QueryEditor_SAVE_PROBLEM, status);
            }
        }
    }

    public boolean isDirty() {
        if (this.getEditorInput() instanceof QueryEditorInput) {
            return ((QueryEditorInput)this.getEditorInput()).isDirty();
        }
        return super.isDirty();
    }

    private IStatus runLongOperation(IRunnableWithProgress runnable, String defaultErrorMessage) {
        try {
            this.getSite().getWorkbenchWindow().run(true, true, runnable);
            return Status.OK_STATUS;
        }
        catch (InvocationTargetException e) {
            return new Status(4, "com.ibm.team.enterprise.metadata.ui", defaultErrorMessage, e.getTargetException());
        }
        catch (InterruptedException e) {
            throw new OperationCanceledException(e.getMessage());
        }
    }

    private boolean validate(IMetadataQuery query) {
        IStatus status = Util.verifyQueryName((String)query.getName());
        if (!status.isOK()) {
            this.setStatus(status.getMessage(), (IStatus)new Status(4, "com.ibm.team.enterprise.metadata.ui", 4, Messages.QueryEditor_NAME_VALIDATION_ACTIONREQUEST, null));
            return false;
        }
        if (!query.getStatement().getStreamScope().isAllStreams() && query.getStatement().getStreamScope().getStreamUUID() == null) {
            this.setStatus(Messages.QueryEditor_STREAM_SCOPE_VALIDATION_ERROR, (IStatus)new Status(4, "com.ibm.team.enterprise.metadata.ui", 4, Messages.QueryEditor_STREAM_SCOPE_VALIDATION_ACTIONREQUEST, null));
            return false;
        }
        return true;
    }

    private void setStatus(String message, IStatus status) {
        this.titlePart.setStatus(message, status);
    }

    protected Composite createPageContainer(Composite parent) {
        String helpId = "com.ibm.team.filesystem.ide.ui.editor_conditions";
        if (this.getActivePage() == 1) {
            helpId = "com.ibm.team.filesystem.ide.ui.editor_resultLayout";
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, helpId);
        return super.createPageContainer(parent);
    }

    public List<IAttribute> getCustomAttributes() {
        if (this.customAttributeCache == null) {
            this.fetchCustomAttributes();
        }
        return this.customAttributeCache;
    }

    private void fetchCustomAttributes() {
        Thread thread = new Thread(){

            @Override
            public void run() {
                QueryEditor.this.cacheCustomAttributes();
            }
        };
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void cacheCustomAttributes() {
        this.customAttributeCache = new ArrayList<IAttribute>();
        QueryEditorInput input = (QueryEditorInput)this.getEditorInput();
        IMetadataQueryClient client = (IMetadataQueryClient)input.getTeamRepository().getClientLibrary(IMetadataQueryClient.class);
        try {
            this.customAttributeCache = client.getCustomAttributes(input.getTeamRepository());
        }
        catch (TeamRepositoryException teamRepositoryException) {
            // empty catch block
        }
    }

    public void clearCustomAttributeCache() {
        this.customAttributeCache = null;
    }
}

