/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.dialog;

import com.ibm.team.enterprise.metadata.ui.MetadataUIPlugin;
import com.ibm.team.enterprise.metadata.ui.query.dialog.Messages;
import com.ibm.team.enterprise.metadata.ui.query.dialog.StreamLabelProvider;
import com.ibm.team.enterprise.metadata.ui.query.util.SCMUtil;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IWorkspace;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class StreamSelectionDialog
extends ElementListSelectionDialog {
    private IProcessAreaHandle fProjectArea = null;
    private Button fShowAllItemsButton;
    private Button fShowSubSetItemsButton;
    private Object[] fElements = null;
    private Map<String, Set<String>> fPaToStreamsMap = null;

    public StreamSelectionDialog(Shell parent, IProcessAreaHandle processArea) {
        super(parent, (ILabelProvider)new StreamLabelProvider(processArea));
        this.setTitle(Messages.StreamSelectionDialog_TITLE);
        this.setMessage(Messages.StreamSelectionDialog_DESCRIPTION);
        this.fProjectArea = processArea;
    }

    public IWorkspace getSelectedStream() {
        if (this.getResult().length > 0) {
            return (IWorkspace)this.getResult()[0];
        }
        return null;
    }

    public IWorkspaceConnection getSelectedStreamConnection() {
        IWorkspaceConnection result = null;
        IWorkspace stream = this.getSelectedStream();
        if (stream != null) {
            try {
                result = SCMUtil.getWorkspaceConnection(stream);
            }
            catch (TeamRepositoryException e) {
                MetadataUIPlugin.getDefault().logError(null, (Exception)((Object)e));
            }
        }
        return result;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.ibm.team.filesystem.ide.ui.dialog_selectStream");
        if (this.fProjectArea != null) {
            GridLayoutFactory.swtDefaults().applyTo(composite);
            GridDataFactory.createFrom((GridData)GridDataFactory.fillDefaults().grab(true, true).create()).applyTo((Control)composite);
            this.createRadioButtonBar(composite);
            StreamLabelProvider streamLabelProvider = (StreamLabelProvider)this.fFilteredList.getLabelProvider();
            streamLabelProvider.setShowProjectArea(this.fShowAllItemsButton.getSelection());
            this.fPaToStreamsMap = streamLabelProvider.getPAToSteamsMap();
            this.setProjectAreaElements();
        }
        return composite;
    }

    private void createRadioButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 4);
        int defaultMargin = 4;
        GridLayoutFactory.fillDefaults().numColumns(2).margins(defaultMargin, defaultMargin).equalWidth(true).applyTo(composite);
        GridDataFactory.fillDefaults().applyTo((Control)composite);
        this.fShowSubSetItemsButton = this.createRadioButton(composite, Messages.StreamSelectionDialog_SHOW_STREAMS_IN_PROJECT_AREA, this.getShowListener(), true);
        this.fShowAllItemsButton = this.createRadioButton(composite, Messages.StreamSelectionDialog_SHOW_ALL_STREAMS, this.getShowListener(), false);
    }

    private Button createRadioButton(Composite parent, String text, SelectionAdapter adapter, boolean isSelected) {
        Button newButton = new Button(parent, 16);
        newButton.setText(text);
        newButton.addSelectionListener((SelectionListener)adapter);
        newButton.setSelection(isSelected);
        GridDataFactory.fillDefaults().grab(true, false).align(1, 4).applyTo((Control)newButton);
        return newButton;
    }

    private SelectionAdapter getShowListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection() && StreamSelectionDialog.this.fElements != null && StreamSelectionDialog.this.fProjectArea != null) {
                    if (e.widget == StreamSelectionDialog.this.fShowSubSetItemsButton) {
                        StreamSelectionDialog.this.setProjectAreaElements();
                    } else {
                        ((StreamLabelProvider)StreamSelectionDialog.this.fFilteredList.getLabelProvider()).setShowProjectArea(true);
                        StreamSelectionDialog.this.setListElements(StreamSelectionDialog.this.fElements);
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
    }

    private void setProjectAreaElements() {
        ArrayList<Object> subsetElements = new ArrayList<Object>();
        if (this.fElements != null) {
            Object[] objectArray = this.fElements;
            int n = this.fElements.length;
            int n2 = 0;
            while (n2 < n) {
                Object stream = objectArray[n2];
                if (stream instanceof IWorkspace && ((IWorkspace)stream).getOwner() instanceof IAuditableHandle && this.existInProjectArea(this.fProjectArea, ((IWorkspace)stream).getOwner())) {
                    subsetElements.add(stream);
                }
                ++n2;
            }
            ((StreamLabelProvider)this.fFilteredList.getLabelProvider()).setShowProjectArea(false);
            this.setListElements(subsetElements.toArray());
        }
    }

    private boolean existInProjectArea(IProcessAreaHandle pa, IAuditableHandle owner) {
        Set<String> streams;
        boolean result = false;
        if (owner == null || pa == null) {
            return result;
        }
        UUID ownerUUID = owner.getItemId();
        UUID paUUID = pa.getItemId();
        if (pa.getItemId().equals((Object)ownerUUID)) {
            result = true;
        } else if (this.fPaToStreamsMap != null && (streams = this.fPaToStreamsMap.get(paUUID.getUuidValue())) != null && streams.contains(ownerUUID.getUuidValue())) {
            result = true;
        }
        return result;
    }

    public void setElements(Object[] elements) {
        this.fElements = elements;
        super.setElements(elements);
    }

    public void setListElements(Object[] elements) {
        if (this.fElements == null && elements != null && elements.length != 0 && elements[0] instanceof IWorkspace) {
            this.fElements = elements;
        }
        super.setListElements(elements);
    }
}

