/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.dialog;

import com.ibm.team.enterprise.metadata.ui.query.dialog.Messages;
import com.ibm.team.enterprise.metadata.ui.query.util.Utils;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.common.IWorkspace;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;

public class StreamLabelProvider
extends LabelProvider {
    private boolean fShowProcessArea = true;
    private boolean fShowDescription = true;
    private Map<String, String> fUUIDToProcessAreaNames = null;
    private IProcessAreaHandle fProcessArea = null;
    private Map<String, Set<String>> fPAToTeamAreasMap = null;

    public StreamLabelProvider() {
        this(null);
    }

    public StreamLabelProvider(IProcessAreaHandle processArea) {
        this.fProcessArea = processArea;
        if (processArea != null) {
            try {
                this.retrieveProcessAreaNames(this.getProcessAreas((ITeamRepository)processArea.getOrigin()));
            }
            catch (TeamRepositoryException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getText(Object element) {
        IProcessAreaHandle pa;
        if (!(element instanceof IWorkspace)) return super.getText(element);
        String text = this.fShowDescription ? Utils.getStreamDisplayName((IWorkspace)element) : ((IWorkspace)element).getName();
        boolean showTeamArea = this.fShowProcessArea;
        if (!this.fShowProcessArea && (pa = (IProcessAreaHandle)((IWorkspace)element).getOwner()) != null && !this.fPAToTeamAreasMap.containsKey(pa.getItemId().getUuidValue())) {
            showTeamArea = true;
        }
        if (!showTeamArea) return text;
        if (this.fProcessArea == null) return text;
        if (this.fUUIDToProcessAreaNames == null) return text;
        try {
            pa = (IProcessAreaHandle)((IWorkspace)element).getOwner();
            if (pa == null) return text;
            if (!this.fUUIDToProcessAreaNames.containsKey(pa.getItemId().getUuidValue())) return text;
            return NLS.bind((String)Messages.StreamLabelProvider_STREAM_WITH_PROJECT_AREA, (Object)text, (Object)this.fUUIDToProcessAreaNames.get(pa.getItemId().getUuidValue()));
        }
        catch (Exception e) {
            e.printStackTrace();
            return super.getText(element);
        }
    }

    public void setShowProjectArea(boolean showProjectArea) {
        this.fShowProcessArea = showProjectArea;
    }

    public void setDescription(boolean showDescription) {
        this.fShowDescription = showDescription;
    }

    private List<IProcessArea> getProcessAreas(final ITeamRepository repository) throws TeamRepositoryException {
        final ArrayList<IProcessArea> processAreas = new ArrayList<IProcessArea>();
        Job fetchProcessAreasJob = new Job(Messages.StreamSelectionDialog_JOB_FETCH_PROCESS_AREAS){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    if (repository != null) {
                        List projectAreaList = repository.itemManager().fetchCompleteItems(repository.itemManager().getKnownSharedItems(IProjectArea.ITEM_TYPE), 2, (IProgressMonitor)new NullProgressMonitor());
                        List teamAreaList = repository.itemManager().fetchCompleteItems(repository.itemManager().getKnownSharedItems(ITeamArea.ITEM_TYPE), 2, (IProgressMonitor)new NullProgressMonitor());
                        processAreas.addAll(projectAreaList);
                        processAreas.addAll(teamAreaList);
                    }
                }
                catch (TeamRepositoryException e) {
                    e.printStackTrace();
                }
                return Status.OK_STATUS;
            }
        };
        fetchProcessAreasJob.schedule();
        try {
            fetchProcessAreasJob.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return processAreas;
    }

    private void retrieveProcessAreaNames(List<IProcessArea> processAreas) {
        this.fUUIDToProcessAreaNames = new HashMap<String, String>();
        this.fPAToTeamAreasMap = new HashMap<String, Set<String>>();
        if (processAreas != null) {
            for (IProcessArea pa : processAreas) {
                if (pa == null) continue;
                this.fUUIDToProcessAreaNames.put(pa.getItemId().getUuidValue(), pa.getName());
                if (!(pa instanceof IProjectArea)) continue;
                List teams = ((IProjectArea)pa).getTeamAreas();
                HashSet<String> streamSet = new HashSet<String>();
                for (ITeamAreaHandle team : teams) {
                    streamSet.add(team.getItemId().getUuidValue());
                }
                this.fPAToTeamAreasMap.put(pa.getItemId().getUuidValue(), streamSet);
            }
        }
    }

    public Map<String, Set<String>> getPAToSteamsMap() {
        return this.fPAToTeamAreasMap;
    }
}

