/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.dialog;

import com.ibm.icu.text.Collator;
import com.ibm.team.enterprise.metadata.client.query.IMetadataQueryClient;
import com.ibm.team.enterprise.metadata.query.common.IAttribute;
import com.ibm.team.enterprise.metadata.ui.MetadataUIPlugin;
import com.ibm.team.enterprise.metadata.ui.query.dialog.AttributeContentProvider;
import com.ibm.team.enterprise.metadata.ui.query.dialog.AttributeLabelProvider;
import com.ibm.team.enterprise.metadata.ui.query.dialog.AttributeNamespace;
import com.ibm.team.enterprise.metadata.ui.query.dialog.Messages;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class SelectAttributeDialog
extends ElementTreeSelectionDialog {
    private static final IStatus STATUS_OK = new Status(0, "com.ibm.team.enterprise.metadata.ui", "");
    private Button removeButton;
    private Button showBuiltInButton;
    private Button showCustomButton;
    private Button showScannerButton;
    private AttributeContentProvider contentProvider;

    public SelectAttributeDialog(AttributeLabelProvider labelProvider, AttributeContentProvider contentProvider, Shell parent) {
        super(parent, (ILabelProvider)labelProvider, (ITreeContentProvider)contentProvider);
        this.contentProvider = contentProvider;
        this.setTitle(Messages.SelectAttributeDialog_TITLE);
        this.setMessage(Messages.SelectAttributeDialog_DESCRIPTION);
        this.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selections) {
                if (selections != null) {
                    Object[] objectArray = selections;
                    int n = selections.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object selection = objectArray[n2];
                        if (selection instanceof IAttribute ? ((IAttribute)selection).getType() == IAttribute.AttributeType.COMPLEX : selection instanceof AttributeNamespace) {
                            return new Status(4, "com.ibm.team.enterprise.metadata.ui", Messages.SelectAttributeDialog_INVALID_SELECTION);
                        }
                        ++n2;
                    }
                }
                return STATUS_OK;
            }
        });
        contentProvider.resetCustomAttributes();
    }

    public List<IAttribute> getSelectedAttributes() {
        ArrayList<IAttribute> attributes = new ArrayList<IAttribute>();
        Object[] objectArray = this.getResult();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            attributes.add((IAttribute)obj);
            ++n2;
        }
        return attributes;
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        TreeViewer viewer = super.createTreeViewer(composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(viewer.getControl(), "com.ibm.team.filesystem.ide.ui.dialog_selectAttributes");
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                boolean isValidSelection = true;
                Iterator iterator = selection.iterator();
                while (iterator.hasNext() && isValidSelection) {
                    Object next = iterator.next();
                    if (next instanceof IAttribute && ((IAttribute)next).getRepositoryUrl() != null) continue;
                    isValidSelection = false;
                }
                SelectAttributeDialog.this.removeButton.setEnabled(isValidSelection);
            }
        });
        viewer.setSorter((ViewerSorter)new AttributeSorter());
        this.createButtonComposite(composite);
        this.createOptionComposite(composite);
        return viewer;
    }

    private void createButtonComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(false, true).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().applyTo(composite);
        this.removeButton = new Button(composite, 8);
        this.removeButton.setText(Messages.SelectAttributeDialog_REMOVE_BUTTON);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.removeButton);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    MessageDialog dialog = new MessageDialog(SelectAttributeDialog.this.getShell(), Messages.SelectAttributeDialog_REMOVE_ATTRIBUTE_TITLE, null, Messages.SelectAttributeDialog_REMOVE_ATTRIBUTE_CONFIRM2, 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1);
                    dialog.setBlockOnOpen(true);
                    if (dialog.open() != 0) {
                        return;
                    }
                    new ProgressMonitorDialog(SelectAttributeDialog.this.getShell()).run(false, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            IMetadataQueryClient client = (IMetadataQueryClient)SelectAttributeDialog.this.contentProvider.getTeamRepository().getClientLibrary(IMetadataQueryClient.class);
                            IStructuredSelection selection = (IStructuredSelection)SelectAttributeDialog.this.getTreeViewer().getSelection();
                            try {
                                if (selection.size() == 1) {
                                    IAttribute selectedAttribute = (IAttribute)selection.getFirstElement();
                                    client.deleteCustomAttribute(selectedAttribute.getAttributeId().getUuidValue(), monitor);
                                } else {
                                    Object[] selectedAttributes = selection.toArray();
                                    String[] names = new String[selectedAttributes.length];
                                    int index = 0;
                                    Object[] objectArray = selectedAttributes;
                                    int n = selectedAttributes.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        Object selectedAttribute = objectArray[n2];
                                        names[index++] = ((IAttribute)selectedAttribute).getAttributeId().getUuidValue();
                                        ++n2;
                                    }
                                    client.deleteCustomAttributes(names, monitor);
                                }
                                SelectAttributeDialog.this.contentProvider.resetCustomAttributes();
                                SelectAttributeDialog.this.getTreeViewer().refresh(false);
                            }
                            catch (Exception e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                    });
                }
                catch (InterruptedException dialog) {
                }
                catch (InvocationTargetException e) {
                    String message = e.getLocalizedMessage();
                    Throwable cause = e.getCause();
                    if (cause != null) {
                        message = cause.getLocalizedMessage();
                    }
                    MessageDialog.openError((Shell)SelectAttributeDialog.this.getShell(), (String)Messages.SelectAttributeDialog_TITLE, (String)message);
                }
            }
        });
    }

    private void refreshViewer() {
        this.getShell().setCursor(this.getShell().getDisplay().getSystemCursor(1));
        this.getTreeViewer().refresh(false);
        this.getShell().setCursor(null);
    }

    private void createOptionComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(composite);
        this.showBuiltInButton = new Button(composite, 32);
        this.showBuiltInButton.setText(Messages.SelectAttributeDialog_SHOW_BUILT_IN);
        GridDataFactory.fillDefaults().applyTo((Control)this.showBuiltInButton);
        this.showBuiltInButton.setSelection(this.contentProvider.isShowBuiltIn());
        this.showBuiltInButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SelectAttributeDialog.this.contentProvider.setShowBuiltIn(SelectAttributeDialog.this.showBuiltInButton.getSelection());
                SelectAttributeDialog.this.refreshViewer();
            }
        });
        this.showScannerButton = new Button(composite, 32);
        this.showScannerButton.setText(Messages.SelectAttributeDialog_SHOW_SCANNER);
        GridDataFactory.fillDefaults().applyTo((Control)this.showScannerButton);
        this.showScannerButton.setSelection(this.contentProvider.isShowScanner());
        this.showScannerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SelectAttributeDialog.this.contentProvider.setShowScanner(SelectAttributeDialog.this.showScannerButton.getSelection());
                SelectAttributeDialog.this.refreshViewer();
            }
        });
        this.showCustomButton = new Button(composite, 32);
        this.showCustomButton.setText(Messages.SelectAttributeDialog_SHOW_CUSTOM);
        GridDataFactory.fillDefaults().applyTo((Control)this.showCustomButton);
        this.showCustomButton.setSelection(this.contentProvider.isShowCustom());
        this.showCustomButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SelectAttributeDialog.this.contentProvider.setShowCustom(SelectAttributeDialog.this.showCustomButton.getSelection());
                SelectAttributeDialog.this.refreshViewer();
            }
        });
    }

    public boolean close() {
        MetadataUIPlugin.getDefault().getUISettings().saveShowBuiltInt(this.showBuiltInButton.getSelection());
        MetadataUIPlugin.getDefault().getUISettings().saveShowCustom(this.showCustomButton.getSelection());
        return super.close();
    }

    class AttributeSorter
    extends ViewerSorter {
        AttributeSorter() {
        }

        protected Comparator<Object> getComparator() {
            return new Comparator<Object>(){
                private final Collator collator = Collator.getInstance((Locale)Locale.getDefault());

                @Override
                public int compare(Object obj1, Object obj2) {
                    if (obj1 instanceof IAttribute) {
                        return this.collator.compare(((IAttribute)obj1).getDisplayName(), ((IAttribute)obj2).getDisplayName());
                    }
                    if (obj1 instanceof AttributeNamespace) {
                        return this.collator.compare(((AttributeNamespace)obj1).getNamespace(), ((AttributeNamespace)obj2).getNamespace());
                    }
                    return this.collator.compare(obj1.toString(), obj2.toString());
                }
            };
        }
    }
}

