/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.dialog;

import com.ibm.team.enterprise.metadata.client.query.MetadataQueryClientUtil;
import com.ibm.team.enterprise.metadata.client.scanner.IMetadataScannerClientLibrary;
import com.ibm.team.enterprise.metadata.common.scanner.IFileMetadataScanner;
import com.ibm.team.enterprise.metadata.common.scanner.IMetadataValueType;
import com.ibm.team.enterprise.metadata.query.common.IAttribute;
import com.ibm.team.enterprise.metadata.ui.MetadataUIPlugin;
import com.ibm.team.enterprise.metadata.ui.query.dialog.AttributeNamespace;
import com.ibm.team.enterprise.metadata.ui.query.editor.QueryEditor;
import com.ibm.team.enterprise.metadata.ui.query.editor.QueryEditorInput;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class AttributeContentProvider
implements ITreeContentProvider {
    private final QueryEditor queryEditor;
    private boolean showCustom;
    private boolean showBuiltIn;
    private boolean showScanner;
    private Map<String, AttributeNamespace> namespaceMap;
    private List<IAttribute> scannerGeneralTypeAttributes;
    private IFileMetadataScanner[] scanners;

    private IFileMetadataScanner[] getScanners() {
        return this.scanners;
    }

    private void setScanners(IFileMetadataScanner[] scanners) {
        this.scanners = scanners;
    }

    public AttributeContentProvider(QueryEditor queryEditor) {
        this.queryEditor = queryEditor;
        this.showCustom = MetadataUIPlugin.getDefault().getUISettings().isShowCustom();
        this.showBuiltIn = MetadataUIPlugin.getDefault().getUISettings().isShowBuiltInt();
        this.showScanner = MetadataUIPlugin.getDefault().getUISettings().isShowScanner();
    }

    public Object[] getChildren(Object object) {
        if (object instanceof List && ((List)object).size() > 0 && ((List)object).get(0) instanceof IAttribute) {
            this.initNamespaces(this.convertToAttributeList((List)object));
            return this.namespaceMap.values().toArray();
        }
        if (object instanceof AttributeNamespace) {
            return ((AttributeNamespace)object).getAttributes();
        }
        if (object instanceof IAttribute) {
            return ((IAttribute)object).getChildAttributes().toArray();
        }
        return new Object[0];
    }

    private List<IAttribute> convertToAttributeList(List list) {
        ArrayList<IAttribute> attributes = new ArrayList<IAttribute>();
        attributes.addAll(list);
        return attributes;
    }

    private void initNamespaces(List<IAttribute> attributes) {
        this.namespaceMap = new HashMap<String, AttributeNamespace>();
        if (this.showBuiltIn) {
            this.addAttributeToNamespaceMap(attributes);
        }
        if (this.showCustom && this.queryEditor != null) {
            this.addAttributeToNamespaceMap(this.queryEditor.getCustomAttributes());
        }
        if (this.showScanner) {
            this.addAttributeToNamespaceMap(this.getScannerGeneralAttributes(this.getTeamRepository()));
        }
    }

    private void addAttributeToNamespaceMap(List<IAttribute> attributes) {
        for (IAttribute attribute : attributes) {
            String attributeNamespace = AttributeNamespace.convertPrefixToNamespace(attribute.getNamespace());
            AttributeNamespace namespace = this.namespaceMap.get(attributeNamespace);
            if (namespace == null) {
                namespace = new AttributeNamespace(attribute.getNamespace());
                namespace.addAttribute(attribute);
                this.namespaceMap.put(attributeNamespace, namespace);
                continue;
            }
            if (this.existInNamespace(namespace, attribute)) continue;
            namespace.addAttribute(attribute);
        }
    }

    private boolean existInNamespace(AttributeNamespace namespace, IAttribute attribute) {
        IAttribute[] iAttributeArray = namespace.getAttributes();
        int n = iAttributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAttribute next = iAttributeArray[n2];
            if (next.getAttributeId().equals((Object)attribute.getAttributeId())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private List<IAttribute> getScannerGeneralAttributes(ITeamRepository repository) {
        if (this.scannerGeneralTypeAttributes == null) {
            this.scannerGeneralTypeAttributes = new ArrayList<IAttribute>();
            if (repository != null) {
                try {
                    this.fetchScanners(repository);
                    IFileMetadataScanner[] iFileMetadataScannerArray = this.scanners;
                    int n = this.scanners.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IFileMetadataScanner scanner = iFileMetadataScannerArray[n2];
                        Map map = scanner.getGeneralMetadataTypes();
                        if (map != null) {
                            Set keys = map.keySet();
                            for (String key : keys) {
                                if (this.isInList(this.scannerGeneralTypeAttributes, key)) continue;
                                IMetadataValueType type = (IMetadataValueType)map.get(key);
                                this.scannerGeneralTypeAttributes.add(MetadataQueryClientUtil.createAttribute(null, (String)key, (String)scanner.getNamespace(), (IMetadataValueType)type, null));
                            }
                        }
                        ++n2;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return this.scannerGeneralTypeAttributes;
    }

    private void fetchScanners(final ITeamRepository repo) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                IMetadataScannerClientLibrary client = (IMetadataScannerClientLibrary)repo.getClientLibrary(IMetadataScannerClientLibrary.class);
                try {
                    AttributeContentProvider.this.setScanners(client.getAllMetadataScanners());
                }
                catch (TeamRepositoryException e) {
                    e.printStackTrace();
                }
            }
        };
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private boolean isInList(List<IAttribute> list, String name) {
        for (IAttribute attr : list) {
            if (!attr.getDisplayName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public Object getParent(Object object) {
        return null;
    }

    public boolean hasChildren(Object object) {
        return this.getChildren(object).length > 0;
    }

    public Object[] getElements(Object object) {
        return this.getChildren(object);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object object1, Object object2) {
    }

    public void setShowBuiltIn(boolean showBuiltIn) {
        this.showBuiltIn = showBuiltIn;
    }

    public void setShowCustom(boolean showCustom) {
        this.showCustom = showCustom;
    }

    public void setShowScanner(boolean showScanner) {
        this.showScanner = showScanner;
    }

    public ITeamRepository getTeamRepository() {
        if (this.queryEditor != null) {
            return ((QueryEditorInput)this.queryEditor.getEditorInput()).getTeamRepository();
        }
        return null;
    }

    public void resetCustomAttributes() {
        this.queryEditor.clearCustomAttributeCache();
    }

    public List<AttributeNamespace> getNamespaces() {
        ArrayList<AttributeNamespace> list = new ArrayList<AttributeNamespace>();
        list.addAll(this.namespaceMap.values());
        return list;
    }

    public boolean isShowBuiltIn() {
        return this.showBuiltIn;
    }

    public boolean isShowCustom() {
        return this.showCustom;
    }

    public boolean isShowScanner() {
        return this.showScanner;
    }
}

