/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.control;

import com.ibm.team.enterprise.metadata.query.common.AttributeExpression;
import com.ibm.team.enterprise.metadata.query.common.Expression;
import com.ibm.team.enterprise.metadata.query.common.MetadataQueryChangeEvent;
import com.ibm.team.enterprise.metadata.query.common.Statement;
import com.ibm.team.enterprise.metadata.ui.query.control.AbstractConditionControl;
import com.ibm.team.enterprise.metadata.ui.query.control.ConditionControlInput;
import com.ibm.team.enterprise.metadata.ui.query.control.Messages;
import com.ibm.team.enterprise.metadata.ui.query.editor.QueryEditorToolkit;
import com.ibm.team.enterprise.metadata.ui.query.util.Utils;
import com.ibm.team.enterprise.metadata.ui.query.util.VariableAwareLabelProvider;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;

public class TreeViewConditionControl
extends AbstractConditionControl {
    private static final int MAGIC_WIDTH_IN_CHARS = 30;
    private static final int MAGIC_HEIGHT_IN_LINES = 8;
    private int fWidthHintInChars = 30;
    private int fHeightHintInLines = 8;
    protected CheckboxTreeViewer fTreeViewer;
    private IBaseLabelProvider fLabelProvider;
    private IContentProvider fContentProvider;
    private ViewerComparator fComparator;
    private boolean fExpandAll = false;
    private boolean fAutoCheckChildren = false;
    protected Button fCheckAllButton = null;
    protected Composite fCheckComposite = null;
    protected int fCheckNum = 1;
    private Composite fBorder;
    protected List<String> fSelectedValues = null;
    protected Statement fStatement = null;
    protected AttributeExpression fExpression = null;
    private ICheckStateListener fCheckStateListener = new ICheckStateListener(){

        public void checkStateChanged(CheckStateChangedEvent event) {
            if (TreeViewConditionControl.this.fAutoCheckChildren) {
                TreeViewConditionControl.this.fTreeViewer.setSubtreeChecked(event.getElement(), event.getChecked());
            }
            TreeViewConditionControl.this.updateAttribute(event.getElement(), event.getChecked());
            TreeViewConditionControl.this.handleCheckedAllButtonStatus(event.getElement(), event.getChecked());
            TreeViewConditionControl.this.notifySelectionChanged(TreeViewConditionControl.this.fTreeViewer.getSelection());
        }
    };

    @Override
    public void createContent(Composite parent) {
        QueryEditorToolkit toolkit = (QueryEditorToolkit)this.getSite().getToolkit();
        this.fCheckComposite = toolkit.createComposite(parent);
        GridLayoutFactory.fillDefaults().numColumns(this.fCheckNum).applyTo(this.fCheckComposite);
        this.fCheckAllButton = toolkit.createButton(this.fCheckComposite, Messages.TREEVIEW_CONTROLE_CHECK_ALL_BUTTON, 32);
        this.fCheckAllButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TreeViewConditionControl.this.handleCheckedAll(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }
        });
        this.addOtherCheckButtons();
        this.fBorder = toolkit.createBorder(parent);
        Tree tree = toolkit.createTree(this.fBorder, 290);
        this.fTreeViewer = new CheckboxTreeViewer(tree);
        this.fTreeViewer.addCheckStateListener(this.fCheckStateListener);
        this.fTreeViewer.setComparator(this.fComparator);
        this.fTreeViewer.setLabelProvider(this.fLabelProvider);
        this.fTreeViewer.setContentProvider(this.fContentProvider);
        GridLayoutFactory.fillDefaults().applyTo(parent);
        GridDataFactory.fillDefaults().grab(true, true).hint(this.getMinWidth(), this.getMinHeight()).applyTo((Control)this.fBorder);
        this.getSite().showSummary(true);
    }

    protected void initSelectedValues() {
        ConditionControlInput conditionInput = this.getInput();
        if (conditionInput != null) {
            this.fExpression = conditionInput.getExpression();
        }
        if (this.fExpression != null) {
            this.fStatement = this.fExpression.getParent().getParent();
            Object value = this.fExpression.getValue();
            if (value instanceof String || value == null) {
                this.fSelectedValues = new ArrayList<String>();
                this.fExpression.setValue(this.fSelectedValues);
                this.addFirstTwoValues(this.fSelectedValues);
            } else if (value instanceof List) {
                this.fSelectedValues = (List)value;
                if (this.fSelectedValues.size() > 0 && this.fSelectedValues.get(0).length() > 5) {
                    this.addFirstTwoValues(this.fSelectedValues);
                    this.fStatement.notifyExpressionChanged(MetadataQueryChangeEvent.Type.TERM_CHANGED, MetadataQueryChangeEvent.SubType.TERM_CONDITION_VALUE_CHANGED, (Expression)this.fExpression);
                } else if (this.fSelectedValues != null && this.fSelectedValues.size() >= 1) {
                    this.handleOtherPropertiesStatues();
                }
            }
        }
    }

    protected void firstHandleCheckAllButtonStatus() {
        boolean isCheckAll;
        if (this.fSelectedValues != null && this.fSelectedValues.size() >= 1 && (isCheckAll = Boolean.valueOf(this.fSelectedValues.get(0)).booleanValue()) && this.fCheckAllButton != null && !this.fCheckAllButton.isDisposed()) {
            this.fCheckAllButton.setSelection(true);
        }
    }

    protected void handleOtherPropertiesStatues() {
    }

    protected boolean isFilter(Object inputObj) {
        return true;
    }

    protected void handleCheckedAllButtonStatus(Object element, boolean isChecked) {
        Object input = this.fTreeViewer.getInput();
        boolean isCheckedAll = this.fCheckAllButton.getSelection();
        boolean nextStatus = true;
        if (input instanceof Object[]) {
            Object[] inputList;
            Object[] objectArray = inputList = (Object[])input;
            int n = inputList.length;
            int n2 = 0;
            while (n2 < n) {
                Object inputObj = objectArray[n2];
                if (!this.isFilter(inputObj)) {
                    if (inputObj == element && !isChecked) {
                        nextStatus = false;
                        break;
                    }
                    if (!this.isInputObjectChecked(inputObj)) {
                        nextStatus = false;
                        break;
                    }
                }
                ++n2;
            }
        } else {
            nextStatus = this.fTreeViewer.getChecked(input);
        }
        if (isCheckedAll != nextStatus) {
            this.fCheckAllButton.setSelection(nextStatus);
            if (this.fSelectedValues == null) {
                this.initSelectedValues();
            }
            if (this.fSelectedValues != null) {
                this.fSelectedValues.remove(0);
                this.fSelectedValues.add(0, Boolean.toString(nextStatus));
            }
        }
    }

    protected boolean isInputObjectChecked(Object inputObj) {
        return this.fTreeViewer.getChecked(inputObj);
    }

    protected void handleCheckedAll(boolean isCheckAction) {
        Object input = this.fTreeViewer.getInput();
        boolean isCheckedAll = this.fCheckAllButton.getSelection();
        if (!isCheckAction && !isCheckedAll) {
            return;
        }
        if (input instanceof Object[]) {
            Object[] inputList;
            Object[] objectArray = inputList = (Object[])input;
            int n = inputList.length;
            int n2 = 0;
            while (n2 < n) {
                Object inputObj = objectArray[n2];
                this.fTreeViewer.setSubtreeChecked(inputObj, isCheckedAll);
                ++n2;
            }
        } else {
            this.fTreeViewer.setSubtreeChecked(input, isCheckedAll);
        }
        this.modifyAttributeValues(this.fTreeViewer.getCheckedElements(), isCheckedAll);
        this.notifySelectionChanged(this.fTreeViewer.getSelection());
    }

    protected void addOtherCheckButtons() {
    }

    protected void updateAttribute(Object selectObject, boolean isChecked) {
    }

    protected void modifyAttributeValues(Object[] checkedElements, boolean isCheckAll) {
        if (checkedElements != null) {
            if (this.fSelectedValues == null) {
                this.initSelectedValues();
            }
            if (this.fSelectedValues != null && this.fExpression != null && this.fStatement != null) {
                List<String> secondValues = this.getOtherProperties(this.fSelectedValues);
                this.fSelectedValues.clear();
                this.fSelectedValues.add(Boolean.toString(isCheckAll));
                if (secondValues != null) {
                    this.fSelectedValues.addAll(secondValues);
                }
                if (checkedElements.length > 0) {
                    Object[] objectArray = checkedElements;
                    int n = checkedElements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object checkedElement = objectArray[n2];
                        this.fSelectedValues.add(this.getRealCheckedElementValue(checkedElement));
                        ++n2;
                    }
                }
                this.fStatement.notifyExpressionChanged(MetadataQueryChangeEvent.Type.TERM_CHANGED, MetadataQueryChangeEvent.SubType.TERM_CONDITION_VALUE_CHANGED, (Expression)this.fExpression);
            }
        }
    }

    protected List<String> getOtherProperties(List<String> value) {
        return null;
    }

    protected void addFirstTwoValues(List<String> value) {
        if (value == null) {
            return;
        }
        value.add(0, "false");
        this.addOtherProperties(value);
    }

    protected void addOtherProperties(List<String> value) {
    }

    protected String getRealCheckedElementValue(Object checkedElement) {
        return checkedElement == null ? null : checkedElement.toString();
    }

    public void setWidthHintInChars(int chars) {
        this.fWidthHintInChars = chars;
    }

    protected int getWidthHintInChars() {
        return this.fWidthHintInChars;
    }

    public void setHeightHintInLines(int lines) {
        this.fHeightHintInLines = lines;
    }

    protected int getHeightHintInLines() {
        return this.fHeightHintInLines;
    }

    protected int getMinWidth() {
        return Utils.convertWidthInCharsToPixels(this.fTreeViewer.getControl(), this.getWidthHintInChars());
    }

    protected int getMinHeight() {
        return this.fTreeViewer.getTree().getItemHeight() * this.getHeightHintInLines();
    }

    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        this.fLabelProvider = new VariableAwareLabelProvider(labelProvider);
    }

    public void setContentProvider(IContentProvider contentProvider) {
        this.fContentProvider = contentProvider;
    }

    public <T> void setComparator(Comparator<? super String> comparator) {
        if (comparator == null) {
            this.fComparator = null;
            return;
        }
        this.fComparator = new ViewerComparator(comparator);
    }

    @Override
    public void setFocus() {
        if (this.fTreeViewer != null) {
            this.fTreeViewer.getControl().setFocus();
        }
    }

    public void setSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            this.notifySelectionChanged((ISelection)structuredSelection);
        }
    }

    @Override
    protected void inputChanged(Object input) {
        Object[] realInput = null;
        if (input instanceof List) {
            realInput = ((List)input).toArray();
        }
        this.fTreeViewer.setInput((Object)realInput);
        if (this.fExpandAll) {
            this.fTreeViewer.expandAll();
        }
    }

    @Override
    public List<String> getSelectDisplayValues() {
        ArrayList<String> result = new ArrayList<String>();
        this.addOtherPropertiesDisplayValues(result);
        if (this.fTreeViewer != null && !this.fTreeViewer.getTree().isDisposed()) {
            Object[] checkedObjs;
            Object[] objectArray = checkedObjs = this.fTreeViewer.getCheckedElements();
            int n = checkedObjs.length;
            int n2 = 0;
            while (n2 < n) {
                Object checkedObj = objectArray[n2];
                result.add(this.getCheckedElementDisplay(checkedObj));
                ++n2;
            }
        }
        return result;
    }

    protected void addOtherPropertiesDisplayValues(List<String> result) {
    }

    protected String getCheckedElementDisplay(Object checkedElement) {
        return checkedElement.toString();
    }
}

