/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.control;

import com.ibm.team.enterprise.metadata.query.common.IValidator;
import com.ibm.team.enterprise.metadata.ui.query.control.AbstractSelectionProvider;
import com.ibm.team.enterprise.metadata.ui.query.control.ConditionControlInput;
import com.ibm.team.enterprise.metadata.ui.query.util.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class TextControl
extends AbstractSelectionProvider {
    private static final String DEFAULT_SEPARATOR = ",";
    private VerifyListener strictVerificationListener = new VerifyListener(){

        public void verifyText(VerifyEvent e) {
            TextControl.this.handleVerification(e);
        }
    };
    private ModifyListener warnModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            TextControl.this.handleVerification(e);
        }
    };
    private Text text;
    private Composite textContainer;
    private ControlDecoration controlDecoration;
    private IValidator validator;
    private boolean multiSelection;

    public TextControl(Composite parent, int style) {
        this(parent, style, false);
    }

    public TextControl(Composite parent, int style, boolean supportContentAssist) {
        this.textContainer = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(this.textContainer);
        this.text = new Text(this.textContainer, style);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.text);
        this.controlDecoration = new ControlDecoration((Control)this.text, 0x1004000);
        this.controlDecoration.hide();
        this.controlDecoration.setShowHover(true);
        this.useMultiSelection(true);
        this.installListeners();
    }

    public void setWidthHintInChars(int chars) {
        int widthInPixels = chars > 0 ? Utils.convertWidthInCharsToPixels((Control)this.text, chars) : -1;
        this.text.setLayoutData((Object)new GridData(widthInPixels, -1));
    }

    public Text getTextControl() {
        return this.text;
    }

    public Composite getTextContainer() {
        return this.textContainer;
    }

    public void setValidator(IValidator validator, Options options) {
        this.validator = validator;
        this.text.removeVerifyListener(this.strictVerificationListener);
        this.text.removeModifyListener(this.warnModifyListener);
        if (options == Options.VERIFY_STRICT) {
            this.text.addVerifyListener(this.strictVerificationListener);
        } else if (options == Options.VERIFY_WARN) {
            this.text.addModifyListener(this.warnModifyListener);
        }
    }

    public boolean isInputValid() {
        if (this.validator == null) {
            return true;
        }
        IStatus status = this.validate(this.text.getText());
        return status.isOK() || 1 == status.getSeverity();
    }

    public void useMultiSelection(boolean multi) {
        this.multiSelection = multi;
    }

    public void setInput(Object input) {
        Object value;
        if (input instanceof ConditionControlInput && (value = ((ConditionControlInput)input).getValue()) != null) {
            this.text.setText(value.toString());
        }
    }

    protected void handleVerification(VerifyEvent e) {
        if (this.validator != null) {
            String currentText = this.text.getText();
            String newText = String.valueOf(currentText.substring(0, e.start)) + e.text + currentText.substring(e.end);
            IStatus status = this.validate(newText);
            if (!status.isOK()) {
                e.doit = false;
                this.controlDecoration.showHoverText(status.getMessage());
            } else {
                this.controlDecoration.hideHover();
            }
        }
    }

    protected void handleVerification(ModifyEvent e) {
        if (this.validator != null) {
            IStatus status = this.validate(this.text.getText());
            this.showValidationStatus(status);
        }
    }

    public void setSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            List<String> currentValues = this.getCurrentValues();
            if (currentValues.containsAll(structuredSelection.toList()) && structuredSelection.toList().containsAll(currentValues)) {
                return;
            }
            StringBuffer buffer = new StringBuffer();
            Iterator iterator = structuredSelection.toList().iterator();
            while (iterator.hasNext()) {
                buffer.append(iterator.next());
                if (!iterator.hasNext()) continue;
                buffer.append(DEFAULT_SEPARATOR);
                buffer.append(" ");
            }
            this.text.setText(buffer.toString());
        }
    }

    private void installListeners() {
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (TextControl.this.isInputValid()) {
                    TextControl.this.notifySelectionChanged((ISelection)new StructuredSelection(TextControl.this.getCurrentValues()));
                } else {
                    TextControl.this.notifySelectionChanged((ISelection)StructuredSelection.EMPTY);
                }
            }
        });
    }

    private List<String> getCurrentValues() {
        return this.getValues(this.text.getText());
    }

    private List<String> getValues(String text) {
        String[] rawValues;
        if (!this.multiSelection) {
            String trimmed = text.trim();
            return trimmed.length() > 0 ? Collections.singletonList(trimmed) : Collections.emptyList();
        }
        ArrayList<String> values = new ArrayList<String>();
        String[] stringArray = rawValues = text.split(DEFAULT_SEPARATOR);
        int n = rawValues.length;
        int n2 = 0;
        while (n2 < n) {
            String rawValue = stringArray[n2];
            String trimmed = rawValue.trim();
            if (trimmed.length() > 0) {
                values.add(trimmed);
            }
            ++n2;
        }
        return values;
    }

    private IStatus validate(String text) {
        List<String> currentValues = this.getValues(text);
        for (String value : currentValues) {
            IStatus status = this.validator.validate((Object)value);
            if (status.isOK()) continue;
            return status;
        }
        return Status.OK_STATUS;
    }

    public void showValidationStatus(IStatus status) {
        if (status.isOK()) {
            this.controlDecoration.hide();
        } else {
            String fieldDecorationId = this.getDecorationId(status);
            FieldDecoration decoration = FieldDecorationRegistry.getDefault().getFieldDecoration(fieldDecorationId);
            this.controlDecoration.setDescriptionText(status.getMessage());
            this.controlDecoration.setImage(decoration.getImage());
            this.controlDecoration.show();
        }
    }

    private String getDecorationId(IStatus status) {
        switch (status.getSeverity()) {
            case 4: {
                return "DEC_ERROR";
            }
            case 2: {
                return "DEC_WARNING";
            }
            case 1: {
                return "DEC_INFORMATION";
            }
        }
        return "DEC_INFORMATION";
    }

    public void setFocus() {
        if (this.text != null) {
            this.text.setFocus();
        }
    }

    @Override
    public Object getExpression() {
        return null;
    }

    @Override
    public List<String> getSelectDisplayValues() {
        return this.getCurrentValues();
    }

    public static enum Options {
        VERIFY_STRICT,
        VERIFY_WARN;

    }
}

