/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.control;

import com.ibm.team.enterprise.metadata.query.common.IValidator;
import com.ibm.team.enterprise.metadata.ui.query.control.AbstractConditionControl;
import com.ibm.team.enterprise.metadata.ui.query.control.TextControl;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class TextConditionControl
extends AbstractConditionControl {
    private TextControl textControl;
    private IValidator validator;
    private TextControl.Options fOptions;
    private int widthHintInChars = -1;
    private ISelectionChangedListener selectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            TextConditionControl.this.notifySelectionChanged(event.getSelection());
        }
    };

    @Override
    public void createContent(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.textControl = new TextControl(parent, 2052, this.hasInputProvider());
        this.textControl.setValidator(this.validator, this.fOptions);
        this.textControl.addSelectionChangedListener(this.selectionChangedListener);
        if (this.widthHintInChars > 0) {
            this.textControl.setWidthHintInChars(this.widthHintInChars);
        }
        this.getSite().getToolkit().adapt((Control)this.textControl.getTextControl(), true, false);
    }

    public void setSelection(ISelection selection) {
        if (this.textControl != null) {
            this.textControl.setSelection(selection);
        }
    }

    @Override
    public void setFocus() {
        if (this.textControl != null) {
            this.textControl.setFocus();
        }
    }

    public void setValidator(IValidator validator, TextControl.Options options) {
        this.validator = validator;
        this.fOptions = options;
        if (this.textControl != null) {
            this.textControl.setValidator(validator, options);
        }
    }

    public void setWidthHintInChars(int chars) {
        this.widthHintInChars = chars;
        if (this.textControl != null) {
            this.textControl.setWidthHintInChars(chars);
        }
    }

    @Override
    protected void inputChanged(Object input) {
        if (this.textControl != null) {
            this.textControl.setInput(input);
        }
    }
}

