/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.control;

import com.ibm.team.enterprise.metadata.query.common.AttributeExpression;
import com.ibm.team.enterprise.metadata.query.common.IAttribute;
import com.ibm.team.enterprise.metadata.ui.query.control.AbstractSelectionProvider;
import com.ibm.team.enterprise.metadata.ui.query.control.Messages;
import com.ibm.team.jface.preview.DomainAdapter;
import com.ibm.team.jface.preview.IDomainAdapter;
import java.util.HashMap;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class ConditionSelectionDomainAdapter
extends DomainAdapter {
    private static final int MAX_ENTRIES = 5;

    protected Object convertToDomainObject(Object object) {
        return object;
    }

    public void generateContentAsHTML(HashMap head, StringBuffer body, Object input, IDomainAdapter.Info info) {
        AbstractSelectionProvider selectionProvider = (AbstractSelectionProvider)input;
        Object expression = selectionProvider.getExpression();
        IAttribute attriObj = null;
        if (expression instanceof AttributeExpression) {
            AttributeExpression expressObj = (AttributeExpression)expression;
            attriObj = expressObj.getAttribute();
            body.append("&nbsp<b>").append(attriObj.getFullDisplayConditionName()).append("</b>").append("&nbsp").append(expressObj.getOperator().getDisplayName());
        }
        body.append("<ul>");
        List<String> selectedValues = selectionProvider.getSelectDisplayValues();
        if (selectedValues == null) {
            return;
        }
        int size = selectedValues.size();
        if (size == 0) {
            body.append("<li> ").append(Messages.CONDITION_TOOLTIP_ANY_VALUE);
        } else if (info.isHoverTooltip) {
            int idx = 0;
            while (idx < 5 && idx < size) {
                String value = selectedValues.get(idx);
                body.append("<li> ").append(value);
                ++idx;
            }
            if (size > 5) {
                int remaining = size - 5;
                body.append("<li> <i>").append(NLS.bind((String)Messages.CONDITION_TOOLTIP_MORE_VALUE, (Object)remaining)).append("</i>");
            }
        } else {
            for (String value : selectedValues) {
                body.append("<li> ").append(value);
            }
        }
        body.append("</ul>");
    }
}

