/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.control;

import com.ibm.team.enterprise.metadata.query.common.Expression;
import com.ibm.team.enterprise.metadata.query.common.IMetadataQueryChangeListener;
import com.ibm.team.enterprise.metadata.query.common.MetadataQueryChangeEvent;
import com.ibm.team.enterprise.metadata.query.common.StreamScope;
import com.ibm.team.enterprise.metadata.ui.MetadataUIPlugin;
import com.ibm.team.enterprise.metadata.ui.query.control.ConditionControlInput;
import com.ibm.team.enterprise.metadata.ui.query.control.IInputProvider;
import com.ibm.team.enterprise.metadata.ui.query.control.Messages;
import com.ibm.team.enterprise.metadata.ui.query.control.TreeViewConditionControl;
import com.ibm.team.enterprise.metadata.ui.query.editor.QueryEditorToolkit;
import com.ibm.team.enterprise.metadata.ui.query.util.SCMUtil;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class ComponentTreeViewerControl
extends TreeViewConditionControl
implements IMetadataQueryChangeListener {
    private static int WIDTH_HINT_INCHARS = 65;
    private static int HEIGHT_HINT_INCHARS = 7;
    private Button fCurrentProjectAreaBtn = null;
    private Map<String, String> fComOwnerNameMap = null;
    private ComponentProjectAreaFilter fComPAFilter = null;
    private ComponentStreamFilter fComStreamFilter = null;
    private ComponentInputProvider fComInputProvider = null;

    private void checkChecked(Object element) {
        if (element != null && this.fCheckAllButton != null && !this.fCheckAllButton.isDisposed() && this.fTreeViewer != null && !this.fTreeViewer.getTree().isDisposed()) {
            this.fTreeViewer.setSubtreeChecked(element, this.fCheckAllButton.getSelection());
        }
    }

    @Override
    protected void updateAttribute(Object selectObject, boolean isChecked) {
        if (selectObject instanceof IComponent && this.fSelectedValues != null && this.fExpression != null && this.fStatement != null) {
            String comUUID = ((IComponent)selectObject).getItemId().getUuidValue();
            boolean isChanged = false;
            if (isChecked) {
                if (!this.fSelectedValues.contains(comUUID)) {
                    this.fSelectedValues.add(comUUID);
                    isChanged = true;
                }
            } else if (this.fSelectedValues.contains(comUUID)) {
                this.fSelectedValues.remove(comUUID);
                isChanged = true;
            }
            if (isChanged) {
                this.fStatement.notifyExpressionChanged(MetadataQueryChangeEvent.Type.TERM_CHANGED, MetadataQueryChangeEvent.SubType.TERM_CONDITION_VALUE_CHANGED, (Expression)this.fExpression);
            }
        }
    }

    @Override
    protected void addOtherPropertiesDisplayValues(List<String> result) {
        if (result != null && this.fCurrentProjectAreaBtn != null && !this.fCurrentProjectAreaBtn.isDisposed() && this.fCurrentProjectAreaBtn.getSelection()) {
            result.add(Messages.COMPONENT_TREEVIEW_CONTROLE_CURRENT_PA_BUTTON);
        }
    }

    @Override
    protected String getRealCheckedElementValue(Object checkedElement) {
        String result = null;
        if (checkedElement instanceof IComponent) {
            result = ((IComponent)checkedElement).getItemId().getUuidValue();
        }
        return result;
    }

    @Override
    protected void inputChanged(Object input) {
        List elements;
        Assert.isLegal((input != null && input instanceof List ? 1 : 0) != 0);
        super.inputChanged(input);
        if (this.fSelectedValues != null && (elements = (List)input) != null) {
            for (IComponent element : elements) {
                String comUUId = element.getItemId().getUuidValue();
                if (!this.fSelectedValues.contains(comUUId)) continue;
                this.fTreeViewer.setSubtreeChecked((Object)element, true);
            }
        }
        this.checkStreamScope();
        this.firstHandleCheckAllButtonStatus();
    }

    @Override
    protected void handleOtherPropertiesStatues() {
        boolean isCurrentPA;
        if (this.fSelectedValues != null && this.fSelectedValues.size() >= 2 && !(isCurrentPA = Boolean.valueOf((String)this.fSelectedValues.get(1)).booleanValue()) && this.fCurrentProjectAreaBtn != null && !this.fCurrentProjectAreaBtn.isDisposed()) {
            this.fCurrentProjectAreaBtn.setSelection(false);
            this.handleCurrentProjectAreaStatue(false);
        }
    }

    @Override
    protected boolean isFilter(Object inputObj) {
        boolean result = false;
        if (inputObj != null && inputObj instanceof IComponent) {
            IComponent comEle = (IComponent)inputObj;
            String comUUId = comEle.getItemId().getUuidValue();
            if (this.fComPAFilter != null && this.fComPAFilter.isShowCurrentPA()) {
                Map<String, String> comOwnerMap = this.fComInputProvider.getCompOwnerMap();
                if (comOwnerMap != null) {
                    String ownerUUID = comOwnerMap.get(comUUId);
                    result = this.fComOwnerNameMap == null || !this.fComOwnerNameMap.containsKey(ownerUUID);
                } else {
                    result = false;
                }
            }
            if (!result && this.fComStreamFilter != null && !this.fComStreamFilter.fAllStream) {
                List<String> componentUUIDs = this.fComStreamFilter.getComponentUUIDs();
                result = !componentUUIDs.isEmpty() && !componentUUIDs.contains(comUUId);
            }
        }
        return result;
    }

    public ComponentTreeViewerControl() {
        this.setContentProvider((IContentProvider)new ComponentContentProvider());
        this.fComInputProvider = new ComponentInputProvider();
        this.setInputProvider(this.fComInputProvider);
        this.setLabelProvider((IBaseLabelProvider)new ComponentLabelProvider());
        this.setWidthHintInChars(WIDTH_HINT_INCHARS);
        this.setHeightHintInLines(HEIGHT_HINT_INCHARS);
        this.fCheckNum = 2;
    }

    @Override
    public void setInput(ConditionControlInput input) {
        super.setInput(input);
        this.setPAOwners();
        this.initSelectedValues();
        if (this.fStatement != null) {
            this.fStatement.addListener((IMetadataQueryChangeListener)this);
        }
    }

    private void setPAOwners() {
        try {
            this.fComOwnerNameMap = SCMUtil.getComponentOwnerUUIDAndNameMap(this.getInput().getProjectArea());
        }
        catch (TeamRepositoryException e) {
            MetadataUIPlugin.getDefault().logError(e.getLocalizedMessage(), (Exception)((Object)e));
        }
        if (this.fComOwnerNameMap == null) {
            this.fComOwnerNameMap = new HashMap<String, String>();
        }
    }

    @Override
    public void createContent(Composite parent) {
        super.createContent(parent);
        this.fComPAFilter = new ComponentProjectAreaFilter();
        this.fComStreamFilter = new ComponentStreamFilter();
        this.fTreeViewer.setFilters(new ViewerFilter[]{this.fComPAFilter, this.fComStreamFilter});
    }

    @Override
    protected void addOtherCheckButtons() {
        QueryEditorToolkit toolkit = (QueryEditorToolkit)this.getSite().getToolkit();
        this.fCurrentProjectAreaBtn = toolkit.createButton(this.fCheckComposite, Messages.COMPONENT_TREEVIEW_CONTROLE_CURRENT_PA_BUTTON, 32);
        this.fCurrentProjectAreaBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ComponentTreeViewerControl.this.handleCurrentProjectAreaStatue(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }
        });
        this.fCurrentProjectAreaBtn.setSelection(true);
    }

    private void handleCurrentProjectAreaStatue(boolean isSelectionAction) {
        this.fComPAFilter.showCurrentPA(this.fCurrentProjectAreaBtn.getSelection());
        this.refreshComponentView();
        if (this.fSelectedValues == null) {
            this.initSelectedValues();
        }
        if (isSelectionAction && this.fSelectedValues != null && this.fStatement != null && this.fExpression != null) {
            this.fSelectedValues.remove(1);
            this.fSelectedValues.add(1, Boolean.toString(this.fCurrentProjectAreaBtn.getSelection()));
            this.fStatement.notifyExpressionChanged(MetadataQueryChangeEvent.Type.TERM_CHANGED, MetadataQueryChangeEvent.SubType.TERM_CONDITION_VALUE_CHANGED, (Expression)this.fExpression);
        }
        this.notifySelectionChanged(this.fTreeViewer.getSelection());
        this.handleCheckedAllButtonStatus(null, false);
    }

    @Override
    protected List<String> getOtherProperties(List<String> value) {
        if (value == null || value.size() < 2) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        result.add(value.get(1));
        return result;
    }

    @Override
    protected void addOtherProperties(List<String> value) {
        if (value != null) {
            value.add(1, "true");
        }
    }

    private void refreshComponentView() {
        this.fTreeViewer.refresh();
        this.handleCheckedAll(false);
        this.fTreeViewer.expandAll();
    }

    @Override
    protected String getCheckedElementDisplay(Object checkedElement) {
        String result = null;
        if (checkedElement instanceof IComponent) {
            result = ((IComponent)checkedElement).getName();
        }
        return result;
    }

    public void queryChanged(MetadataQueryChangeEvent event) {
        if (event.getType() == MetadataQueryChangeEvent.Type.STREAM_SCOPE_CHANGED) {
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ComponentTreeViewerControl.this.checkStreamScope();
                    ComponentTreeViewerControl.this.handleCheckedAllButtonStatus(null, false);
                }
            });
        }
    }

    private void checkStreamScope() {
        StreamScope teamScope = null;
        try {
            if (this.fStatement == null) {
                this.initSelectedValues();
            }
            teamScope = this.fStatement.getStreamScope();
        }
        catch (Exception e) {
            MetadataUIPlugin.getDefault().logError("", e);
        }
        if (teamScope != null && this.fComStreamFilter != null) {
            this.fComStreamFilter.setAllStream(teamScope.isAllStreams());
            if (!teamScope.isAllStreams() && teamScope.getStreamUUID() != null) {
                this.fComStreamFilter.getComponentUUIDs().clear();
                this.fComStreamFilter.getComponentUUIDs().addAll(teamScope.getComponentUUIDs());
            }
            if (this.fTreeViewer != null && !this.fTreeViewer.getTree().isDisposed()) {
                this.refreshComponentView();
            }
        }
    }

    private class ComponentContentProvider
    implements ITreeContentProvider {
        private Object[] fComponents;

        private ComponentContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (oldInput != newInput && newInput instanceof Object[]) {
                this.fComponents = (Object[])newInput;
            }
        }

        public Object[] getChildren(Object parentElement) {
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            Object[] children = this.getChildren(element);
            return children != null && children.length > 0;
        }

        public Object[] getElements(Object inputElement) {
            Object[] result = null;
            if (inputElement instanceof ConditionControlInput) {
                Object value = ((ConditionControlInput)inputElement).getValue();
                if (value instanceof List) {
                    result = ((List)value).toArray();
                }
            } else {
                result = this.fComponents != null ? this.fComponents : new Object[]{};
            }
            return result;
        }

        public void dispose() {
        }
    }

    private class ComponentInputProvider
    implements IInputProvider {
        private Map<String, String> compOwnerMap = null;

        private ComponentInputProvider() {
        }

        @Override
        public Object createInput(IProjectAreaHandle projectAreaHandle, Object values, IProgressMonitor monitor) throws TeamRepositoryException {
            List<IComponent> components = SCMUtil.getComponentsByProjectArea(projectAreaHandle, false);
            if (components != null && components.size() > 0) {
                ArrayList<IComponentHandle> componentHandles = new ArrayList<IComponentHandle>();
                for (IComponent component : components) {
                    componentHandles.add((IComponentHandle)component);
                }
                this.compOwnerMap = SCMUtil.getComponentOwnerMap(projectAreaHandle, componentHandles);
            }
            return components;
        }

        public Map<String, String> getCompOwnerMap() {
            return this.compOwnerMap;
        }
    }

    private class ComponentLabelProvider
    extends LabelProvider {
        private ComponentLabelProvider() {
        }

        public String getText(Object element) {
            String result = null;
            if (element instanceof IComponent) {
                result = ((IComponent)element).getName();
            }
            return result;
        }
    }

    private class ComponentProjectAreaFilter
    extends ViewerFilter {
        private boolean fShowCurrentPA = true;

        private ComponentProjectAreaFilter() {
        }

        public void showCurrentPA(boolean show) {
            this.fShowCurrentPA = show;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            boolean result;
            boolean bl = result = !this.fShowCurrentPA;
            if (!result && element instanceof IComponent) {
                IComponent comEle = (IComponent)element;
                String comUUId = comEle.getItemId().getUuidValue();
                Map<String, String> comOwnerMap = ComponentTreeViewerControl.this.fComInputProvider.getCompOwnerMap();
                if (comOwnerMap != null) {
                    String ownerUUID = comOwnerMap.get(comUUId);
                    if (ComponentTreeViewerControl.this.fComOwnerNameMap != null && ComponentTreeViewerControl.this.fComOwnerNameMap.containsKey(ownerUUID)) {
                        result = true;
                        ComponentTreeViewerControl.this.checkChecked(element);
                    } else {
                        result = false;
                    }
                } else {
                    result = false;
                }
                if (!result) {
                    ComponentTreeViewerControl.this.updateAttribute(element, false);
                    ComponentTreeViewerControl.this.notifySelectionChanged(ComponentTreeViewerControl.this.fTreeViewer.getSelection());
                }
            }
            return result;
        }

        public boolean isShowCurrentPA() {
            return this.fShowCurrentPA;
        }
    }

    private class ComponentStreamFilter
    extends ViewerFilter {
        private boolean fAllStream = true;
        private List<String> fComponentUUIDs = null;

        private ComponentStreamFilter() {
        }

        public void setAllStream(boolean fAllStream) {
            this.fAllStream = fAllStream;
        }

        public List<String> getComponentUUIDs() {
            if (this.fComponentUUIDs == null) {
                this.fComponentUUIDs = new ArrayList<String>();
            }
            return this.fComponentUUIDs;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            boolean result = this.fAllStream;
            if (!result && element instanceof IComponent) {
                IComponent comEle = (IComponent)element;
                String comUUId = comEle.getItemId().getUuidValue();
                List<String> componentUUIDs = this.getComponentUUIDs();
                if (componentUUIDs.isEmpty() || componentUUIDs.contains(comUUId)) {
                    result = true;
                } else {
                    result = false;
                    ComponentTreeViewerControl.this.updateAttribute(element, false);
                    ComponentTreeViewerControl.this.notifySelectionChanged(ComponentTreeViewerControl.this.fTreeViewer.getSelection());
                }
            }
            return result;
        }
    }
}

