/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.control;

import com.ibm.team.enterprise.metadata.query.common.IAttribute;
import com.ibm.team.enterprise.metadata.ui.query.control.ComboConditionControl;
import com.ibm.team.enterprise.metadata.ui.query.control.ComponentTreeViewerControl;
import com.ibm.team.enterprise.metadata.ui.query.control.IConditionControl;
import com.ibm.team.enterprise.metadata.ui.query.control.TextConditionControl;
import com.ibm.team.enterprise.metadata.ui.query.control.TextControl;
import com.ibm.team.enterprise.metadata.ui.query.util.NumberConverter;
import com.ibm.team.enterprise.metadata.ui.query.util.NumberValidator;
import java.util.HashMap;

public class BasicQueryEditorControlFactory {
    private static HashMap<IAttribute.AttributeType, ConditionControl> typeControls = new HashMap();

    static {
        typeControls.put(IAttribute.AttributeType.STRING, ConditionControl.TEXT_CONTROL);
        typeControls.put(IAttribute.AttributeType.NUMBER, ConditionControl.NUMBER_CONTROL);
        typeControls.put(IAttribute.AttributeType.LIST, ConditionControl.ENUM_COMBO_CONTROL);
        typeControls.put(IAttribute.AttributeType.BOOLEAN, ConditionControl.ENUM_BOOLEAN_COMBO_CONTROL);
        typeControls.put(IAttribute.AttributeType.COMPONENT_TREE, ConditionControl.ENUM_COMPONENTTREEVIEW_CONTROL);
    }

    public IConditionControl createConditionControl(IAttribute attribute) {
        ConditionControl control = this.getConditionControl(attribute);
        return control != null ? control.createControl(attribute) : null;
    }

    private ConditionControl getConditionControl(IAttribute attribute) {
        IAttribute.AttributeType attributeType = attribute.getType();
        return typeControls.get(attributeType);
    }

    private static enum ConditionControl {
        TEXT_CONTROL{

            @Override
            protected IConditionControl createControl(IAttribute attribute) {
                TextConditionControl control = new TextConditionControl();
                return control;
            }
        }
        ,
        NUMBER_CONTROL{

            @Override
            protected IConditionControl createControl(IAttribute attribute) {
                String rangeStartString = String.valueOf(Double.MIN_VALUE);
                String rangeEndString = String.valueOf(Double.MAX_VALUE);
                Double rangeStart = null;
                Double rangeEnd = null;
                if (rangeStartString != null && NumberValidator.DOUBLE_VALIDATOR.validate((Object)rangeStartString).isOK()) {
                    rangeStart = new Double(rangeStartString);
                }
                if (rangeEndString != null && NumberValidator.DOUBLE_VALIDATOR.validate((Object)rangeEndString).isOK()) {
                    rangeEnd = new Double(rangeEndString);
                }
                TextConditionControl control = new TextConditionControl();
                control.setValidator(new NumberValidator.DoubleValidator(rangeStart, rangeEnd), TextControl.Options.VERIFY_WARN);
                control.setConverter(NumberConverter.create(Double.class));
                return control;
            }
        }
        ,
        ENUM_COMBO_CONTROL{

            @Override
            protected IConditionControl createControl(IAttribute attribute) {
                ComboConditionControl control = new ComboConditionControl(0);
                return control;
            }
        }
        ,
        ENUM_BOOLEAN_COMBO_CONTROL{

            @Override
            protected IConditionControl createControl(IAttribute attribute) {
                ComboConditionControl control = new ComboConditionControl(8);
                return control;
            }
        }
        ,
        ENUM_COMPONENTTREEVIEW_CONTROL{

            @Override
            protected IConditionControl createControl(IAttribute attribute) {
                ComponentTreeViewerControl control = new ComponentTreeViewerControl();
                return control;
            }
        };


        protected abstract IConditionControl createControl(IAttribute var1);
    }
}

