/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.control;

import com.ibm.team.enterprise.metadata.ui.MetadataUIPlugin;
import com.ibm.team.enterprise.metadata.ui.query.control.AbstractSelectionProvider;
import com.ibm.team.enterprise.metadata.ui.query.control.ConditionControlInput;
import com.ibm.team.enterprise.metadata.ui.query.control.IConditionControl;
import com.ibm.team.enterprise.metadata.ui.query.control.IConditionControlSite;
import com.ibm.team.enterprise.metadata.ui.query.control.IInputProvider;
import com.ibm.team.enterprise.metadata.ui.query.control.Messages;
import com.ibm.team.enterprise.metadata.ui.query.util.ConvertingValueSelectionProvider;
import com.ibm.team.enterprise.metadata.ui.query.util.IValueConverter;
import com.ibm.team.jface.util.UIUpdaterJob;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;

public abstract class AbstractConditionControl
extends AbstractSelectionProvider
implements IConditionControl {
    private final UIUpdaterJob refreshJob = new UIUpdaterJob(Messages.AbstractConditionControl_INITIALIZING_INPUT){
        private Object resolvedInput;
        private IStatus status;

        public IStatus runInBackground(IProgressMonitor monitor) {
            try {
                this.resolvedInput = AbstractConditionControl.this.inputProvider != null ? AbstractConditionControl.this.inputProvider.createInput(AbstractConditionControl.this.getInput().getProjectArea(), AbstractConditionControl.this.input.getValue(), monitor) : "";
                this.status = Status.OK_STATUS;
                return this.status;
            }
            catch (Exception e) {
                this.status = new Status(4, "com.ibm.team.enterprise.metadata.ui", Messages.AbstractConditionControl_LOADING_INPUT_ERROR, (Throwable)e);
                MetadataUIPlugin.log(this.status);
                return Status.OK_STATUS;
            }
        }

        public IStatus runInUI(IProgressMonitor monitor) {
            if (!AbstractConditionControl.this.site.isDisposed()) {
                if (this.status.isOK()) {
                    AbstractConditionControl.this.site.showStatusText("");
                    AbstractConditionControl.this.inputChanged(this.resolvedInput);
                    if (AbstractConditionControl.this.selectionProvider != null) {
                        AbstractConditionControl.this.restoreLastSelection(AbstractConditionControl.this.selectionProvider.getLastSelection(true));
                    }
                } else {
                    AbstractConditionControl.this.site.showStatusText(this.status.getMessage());
                }
            }
            return super.runInUI(monitor);
        }
    };
    private ConvertingValueSelectionProvider selectionProvider;
    private IInputProvider inputProvider;
    private IValueConverter converter;
    private ConditionControlInput input;
    private IConditionControlSite site;
    protected int style;

    public AbstractConditionControl(int style) {
        this.style = style;
    }

    public AbstractConditionControl() {
        this.style = 0;
    }

    @Override
    public void init(IConditionControlSite site) {
        this.site = site;
    }

    public void setInputProvider(IInputProvider provider) {
        this.inputProvider = provider;
    }

    public void setConverter(IValueConverter converter) {
        this.converter = converter;
        if (this.selectionProvider != null) {
            this.selectionProvider.setValueConverter(converter);
        }
    }

    @Override
    public void setInput(ConditionControlInput input) {
        this.input = input;
        if (this.inputProvider != null) {
            this.refreshInput();
        } else {
            this.inputChanged(input);
        }
    }

    protected ConditionControlInput getInput() {
        return this.input;
    }

    private void refreshInput() {
        if (this.inputProvider != null) {
            this.site.showStatusText(Messages.AbstractConditionControl_LOADING_INPUT_MESSAGE);
            this.refreshJob.schedule();
        }
    }

    protected boolean hasInputProvider() {
        return this.inputProvider != null;
    }

    @Override
    public ISelectionProvider getSelectionProvider() {
        if (this.selectionProvider == null) {
            this.selectionProvider = new ConvertingValueSelectionProvider(this);
            this.selectionProvider.setValueConverter(this.converter);
        }
        return this.selectionProvider;
    }

    protected IConditionControlSite getSite() {
        return this.site;
    }

    protected void restoreLastSelection(ISelection selection) {
        this.setSelection(selection);
    }

    protected abstract void inputChanged(Object var1);

    @Override
    public Object getExpression() {
        return this.getInput().getExpression();
    }

    @Override
    public List<String> getSelectDisplayValues() {
        return null;
    }
}

