/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.ui.query.action;

import com.ibm.team.enterprise.metadata.client.collection.ClientFactory;
import com.ibm.team.enterprise.metadata.client.collection.IMetadataCollectionClient;
import com.ibm.team.enterprise.metadata.common.collection.helper.StreamScanningStatusInfo;
import com.ibm.team.enterprise.metadata.ui.query.action.Messages;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.common.IWorkspace;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class SetStreamScanningFromSourceControlAction
extends Action
implements IObjectActionDelegate {
    private IWorkbenchPart part;
    private IProcessAreaHandle processAreaHandle;
    private List<IWorkspace> initialSelectedStreams;
    private ITeamRepository repository;

    public void setActivePart(IAction action, IWorkbenchPart part) {
        this.part = part;
    }

    public void run() {
        try {
            String successMessage;
            final StringBuffer successStreamBuffer = new StringBuffer();
            final StringBuffer ignoreStreamBuffer = new StringBuffer();
            new ProgressMonitorDialog(this.part.getSite().getShell()).run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    if (monitor == null) {
                        monitor = new NullProgressMonitor();
                    }
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                    boolean isDirty = false;
                    try {
                        List scanningStatusInfos = SetStreamScanningFromSourceControlAction.this.getCurrentScanningStatus((IProgressMonitor)progress.newChild(50));
                        for (IWorkspace initialSelectedStream : SetStreamScanningFromSourceControlAction.this.initialSelectedStreams) {
                            StreamScanningStatusInfo scanningStatusInfo = SetStreamScanningFromSourceControlAction.this.findScanningStatusInfo(initialSelectedStream, scanningStatusInfos);
                            if (scanningStatusInfo == null) {
                                scanningStatusInfos.add(new StreamScanningStatusInfo(initialSelectedStream.getItemId(), initialSelectedStream.getName(), true));
                                isDirty = true;
                                successStreamBuffer.append(initialSelectedStream.getName()).append(", ");
                                continue;
                            }
                            if (!scanningStatusInfo.isSetForScanning()) {
                                scanningStatusInfo.setForScanning(true);
                                successStreamBuffer.append(initialSelectedStream.getName()).append(", ");
                                isDirty = true;
                                continue;
                            }
                            ignoreStreamBuffer.append(initialSelectedStream.getName()).append(", ");
                        }
                        if (isDirty) {
                            ClientFactory.getMetadataCollectionClient((ITeamRepository)SetStreamScanningFromSourceControlAction.this.repository).updateStreamScanningStatusInfos(scanningStatusInfos, (IProgressMonitor)progress.newChild(50));
                        }
                    }
                    catch (TeamRepositoryException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
            if (successStreamBuffer.length() > 1) {
                successStreamBuffer.delete(successStreamBuffer.length() - 2, successStreamBuffer.length() - 1);
                successMessage = Messages.bind((String)Messages.SetStreamScanningFromSourceControlAction_SUCCESS_STREAMS, (Object)successStreamBuffer.toString());
            } else {
                successMessage = Messages.SetStreamScanningFromSourceControlAction_NO_STREAM_NEED_TO_BE_SET;
            }
            String ignoreMessage = null;
            if (ignoreStreamBuffer.length() > 1) {
                ignoreStreamBuffer.delete(ignoreStreamBuffer.length() - 2, ignoreStreamBuffer.length() - 1);
                ignoreMessage = Messages.bind((String)Messages.SetStreamScanningFromSourceControlAction_IGNORE_STREAMS, (Object)ignoreStreamBuffer.toString());
            }
            String message = ignoreMessage == null ? successMessage : String.valueOf(successMessage) + "\n" + ignoreMessage;
            MessageDialog.openInformation((Shell)this.part.getSite().getShell(), (String)Messages.SetStreamScanningFromSourceControlAction_MESSAGE_TITLE, (String)message);
        }
        catch (InvocationTargetException e) {
            String errorMessage = Messages.bind((String)Messages.SetStreamScanningFromSourceControlAction_ERROR_OCCURRED, (Object)(e.getCause() != null ? e.getCause().getMessage() : e.getMessage()));
            MessageDialog.openError((Shell)this.part.getSite().getShell(), (String)Messages.SetStreamScanningFromSourceControlAction_MESSAGE_TITLE, (String)errorMessage);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.processAreaHandle = null;
        this.initialSelectedStreams = new ArrayList<IWorkspace>();
        if (selection != null && !selection.isEmpty() && selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)selection;
            for (Object nextObj : ssel) {
                IWorkspace aStream;
                if (!(nextObj instanceof IAdaptable) || (aStream = (IWorkspace)((IAdaptable)nextObj).getAdapter(IWorkspace.class)) == null) continue;
                if (this.processAreaHandle == null) {
                    this.initialSelectedStreams.add(aStream);
                    this.processAreaHandle = (IProcessAreaHandle)aStream.getOwner();
                    continue;
                }
                if (!this.processAreaHandle.sameItemId((IItemHandle)aStream.getOwner())) continue;
                this.initialSelectedStreams.add(aStream);
            }
        }
        if (this.processAreaHandle != null) {
            this.repository = (ITeamRepository)this.processAreaHandle.getOrigin();
        }
        action.setEnabled(this.initialSelectedStreams != null && this.initialSelectedStreams.size() > 0);
    }

    private List<StreamScanningStatusInfo> getCurrentScanningStatus(IProgressMonitor monitor) throws TeamRepositoryException {
        IProjectAreaHandle projectAreaHandle;
        if (this.processAreaHandle instanceof IProjectAreaHandle) {
            projectAreaHandle = (IProjectAreaHandle)this.processAreaHandle;
        } else {
            IProcessArea processArea = (IProcessArea)this.repository.itemManager().fetchCompleteItem((IItemHandle)this.processAreaHandle, 0, monitor);
            projectAreaHandle = processArea.getProjectArea();
        }
        IMetadataCollectionClient client = ClientFactory.getMetadataCollectionClient((ITeamRepository)this.repository);
        return client.getStreamScanningStatusInfos(projectAreaHandle, monitor);
    }

    private StreamScanningStatusInfo findScanningStatusInfo(IWorkspace stream, List<StreamScanningStatusInfo> scanningStatusInfos) {
        for (StreamScanningStatusInfo scanningStatusInfo : scanningStatusInfos) {
            if (!scanningStatusInfo.getStreamUUID().equals((Object)stream.getItemId())) continue;
            return scanningStatusInfo;
        }
        return null;
    }
}

